/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.transport;

import gradlegitproperties.org.eclipse.jgit.lib.ObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.Ref;
import gradlegitproperties.org.eclipse.jgit.lib.Repository;
import gradlegitproperties.org.eclipse.jgit.revwalk.RevWalk;
import gradlegitproperties.org.eclipse.jgit.transport.AdvertiseRefsHook;
import gradlegitproperties.org.eclipse.jgit.transport.ReceivePack;
import gradlegitproperties.org.eclipse.jgit.transport.ServiceMayNotContinueException;
import gradlegitproperties.org.eclipse.jgit.transport.UploadPack;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAdvertiseRefsHook
implements AdvertiseRefsHook {
    @Override
    public void advertiseRefs(UploadPack uploadPack) throws ServiceMayNotContinueException {
        uploadPack.setAdvertisedRefs(this.getAdvertisedRefs(uploadPack.getRepository(), uploadPack.getRevWalk()));
    }

    @Override
    public void advertiseRefs(ReceivePack receivePack) throws ServiceMayNotContinueException {
        Map<String, Ref> refs = this.getAdvertisedRefs(receivePack.getRepository(), receivePack.getRevWalk());
        Set<ObjectId> haves = this.getAdvertisedHaves(receivePack.getRepository(), receivePack.getRevWalk());
        receivePack.setAdvertisedRefs(refs, haves);
    }

    protected abstract Map<String, Ref> getAdvertisedRefs(Repository var1, RevWalk var2) throws ServiceMayNotContinueException;

    protected Set<ObjectId> getAdvertisedHaves(Repository repository, RevWalk revWalk) throws ServiceMayNotContinueException {
        return null;
    }
}

