/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.internal.transport.connectivity;

import gradlegitproperties.org.eclipse.jgit.errors.MissingObjectException;
import gradlegitproperties.org.eclipse.jgit.lib.AnyObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.ProgressMonitor;
import gradlegitproperties.org.eclipse.jgit.revwalk.RevCommit;
import gradlegitproperties.org.eclipse.jgit.revwalk.RevObject;
import gradlegitproperties.org.eclipse.jgit.revwalk.RevWalk;
import gradlegitproperties.org.eclipse.jgit.transport.ConnectivityChecker;
import gradlegitproperties.org.eclipse.jgit.transport.ReceiveCommand;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IterativeConnectivityChecker
implements ConnectivityChecker {
    private static final int MAXIMUM_PARENTS_TO_CHECK = 128;
    private final ConnectivityChecker delegate;
    private Set<ObjectId> forcedHaves = Collections.emptySet();

    public IterativeConnectivityChecker(ConnectivityChecker delegate) {
        this.delegate = delegate;
    }

    @Override
    public void checkConnectivity(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, Set<ObjectId> advertisedHaves, ProgressMonitor pm) throws MissingObjectException, IOException {
        try {
            HashSet<ObjectId> newRefs = new HashSet<ObjectId>();
            HashSet<ObjectId> expectedParents = new HashSet<ObjectId>();
            IterativeConnectivityChecker.getAllObjectIds(connectivityCheckInfo.getCommands()).forEach(oid -> {
                if (advertisedHaves.contains(oid)) {
                    expectedParents.add((ObjectId)oid);
                } else {
                    newRefs.add((ObjectId)oid);
                }
            });
            if (!newRefs.isEmpty()) {
                expectedParents.addAll(IterativeConnectivityChecker.extractAdvertisedParentCommits(newRefs, advertisedHaves, connectivityCheckInfo.getWalk()));
            }
            expectedParents.addAll(this.forcedHaves);
            if (!expectedParents.isEmpty()) {
                this.delegate.checkConnectivity(connectivityCheckInfo, expectedParents, pm);
                return;
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
        this.delegate.checkConnectivity(connectivityCheckInfo, advertisedHaves, pm);
    }

    private static Stream<ObjectId> getAllObjectIds(List<ReceiveCommand> commands) {
        return commands.stream().flatMap(cmd -> {
            if (cmd.getType() == ReceiveCommand.Type.UPDATE || cmd.getType() == ReceiveCommand.Type.UPDATE_NONFASTFORWARD) {
                return Stream.of(cmd.getOldId(), cmd.getNewId());
            }
            if (cmd.getType() == ReceiveCommand.Type.CREATE) {
                return Stream.of(cmd.getNewId());
            }
            return Stream.of(new ObjectId[0]);
        });
    }

    public void setForcedHaves(Set<ObjectId> forcedHaves) {
        this.forcedHaves = Collections.unmodifiableSet(forcedHaves);
    }

    private static Set<ObjectId> extractAdvertisedParentCommits(Set<ObjectId> newRefs, Set<ObjectId> advertisedHaves, RevWalk rw) throws MissingObjectException, IOException {
        HashSet<ObjectId> advertisedParents = new HashSet<ObjectId>();
        for (ObjectId newRef : newRefs) {
            RevObject object = rw.parseAny(newRef);
            if (!(object instanceof RevCommit)) continue;
            int numberOfParentsToCheck = 0;
            ArrayDeque<RevCommit> parents = new ArrayDeque<RevCommit>(128);
            parents.addAll(IterativeConnectivityChecker.parseParents(((RevCommit)object).getParents(), rw));
            while (!parents.isEmpty()) {
                RevCommit parentCommit = (RevCommit)parents.poll();
                if (advertisedHaves.contains(parentCommit.getId())) {
                    advertisedParents.add(parentCommit.getId());
                    continue;
                }
                if (numberOfParentsToCheck >= 128) continue;
                RevCommit[] grandParents = parentCommit.getParents();
                numberOfParentsToCheck += grandParents.length;
                parents.addAll(IterativeConnectivityChecker.parseParents(grandParents, rw));
            }
        }
        return advertisedParents;
    }

    private static List<RevCommit> parseParents(RevCommit[] parents, RevWalk rw) {
        return Arrays.stream(parents).map(commit -> {
            try {
                return rw.parseCommit((AnyObjectId)commit);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

