/*
 * Decompiled with CFR 0.152.
 */
package com.gorylenko.writer;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class NormalizeEOLOutputStream
extends FilterOutputStream {
    private int eolCount = 0;
    private int prevChar = 0;
    private static final int CR = 13;
    private static final int LF = 10;

    public NormalizeEOLOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13 || b == 10) {
            if (this.prevChar != 13 && this.prevChar != 10) {
                ++this.eolCount;
                this.prevChar = b;
            } else if (this.prevChar == b) {
                ++this.eolCount;
                this.prevChar = b;
            } else {
                this.prevChar = 0;
            }
        } else {
            this.writeEOLs();
            this.prevChar = b;
            super.write(b);
        }
    }

    private void writeEOLs() throws IOException {
        while (this.eolCount > 0) {
            this.out.write(10);
            --this.eolCount;
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeEOLs();
        this.prevChar = 0;
        super.flush();
    }
}

