/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.plugins.wysiwyg;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.plugins.wysiwyg.WysiwygBehavior;
import com.googlecode.wicket.jquery.ui.plugins.wysiwyg.toolbar.IWysiwygToolbar;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;

public class WysiwygEditor
extends FormComponentPanel<String>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private TextArea<String> textarea;
    private final WebMarkupContainer container = this.newMarkupContainer();

    public WysiwygEditor(String id) {
        this(id, null, null);
    }

    public WysiwygEditor(String id, IWysiwygToolbar toolbar) {
        this(id, null, toolbar);
    }

    public WysiwygEditor(String id, IModel<String> model) {
        this(id, model, null);
    }

    public WysiwygEditor(String id, IModel<String> model, IWysiwygToolbar toolbar) {
        super(id, model);
        this.add(new Component[]{this.container});
        if (toolbar != null) {
            toolbar.attachToEditor((Component)this.container);
        }
        this.setEscapeModelStrings(false);
    }

    public String getEditorMarkupId() {
        return this.container.getMarkupId();
    }

    public void convertInput() {
        this.setConvertedInput(this.textarea.getConvertedInput());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("addTextAreaMapper('%s', '%s'); initToolbarBootstrapBindings();", this.container.getMarkupId(), this.textarea.getMarkupId())));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.textarea = new TextArea("textarea", this.getModel());
        this.textarea.setEscapeModelStrings(false);
        this.add(new Component[]{this.textarea.setOutputMarkupId(true)});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)this.container)});
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new WysiwygBehavior(selector);
    }

    private WebMarkupContainer newMarkupContainer() {
        return new WebMarkupContainer("container"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (!WysiwygEditor.this.getForm().isEnabled()) {
                    tag.put("contenteditable", (CharSequence)"false");
                }
            }
        };
    }
}

