/*
 * Decompiled with CFR 0.152.
 */
package com.google.phonenumbers;

import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;

public class PhoneNumberParserServlet
extends HttpServlet {
    private PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StringBuilder output;
        String phoneNumber = null;
        String defaultCountry = null;
        String languageCode = "en";
        String regionCode = "";
        String fileContents = null;
        ServletFileUpload upload = new ServletFileUpload();
        upload.setSizeMax(50000L);
        try {
            FileItemIterator iterator = upload.getItemIterator(req);
            while (iterator.hasNext()) {
                FileItemStream item = iterator.next();
                InputStream in = item.openStream();
                if (item.isFormField()) {
                    String fieldName = item.getFieldName();
                    if (fieldName.equals("phoneNumber")) {
                        phoneNumber = Streams.asString((InputStream)in, (String)"UTF-8");
                        continue;
                    }
                    if (fieldName.equals("defaultCountry")) {
                        defaultCountry = Streams.asString((InputStream)in).toUpperCase();
                        continue;
                    }
                    if (fieldName.equals("languageCode")) {
                        String languageEntered = Streams.asString((InputStream)in).toLowerCase();
                        if (languageEntered.length() <= 0) continue;
                        languageCode = languageEntered;
                        continue;
                    }
                    if (!fieldName.equals("regionCode")) continue;
                    regionCode = Streams.asString((InputStream)in).toUpperCase();
                    continue;
                }
                try {
                    fileContents = IOUtils.toString((InputStream)in);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        catch (FileUploadException e1) {
            e1.printStackTrace();
        }
        if (fileContents.length() == 0) {
            output = this.getOutputForSingleNumber(phoneNumber, defaultCountry, languageCode, regionCode);
            resp.setContentType("text/html");
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().println("<html><head>");
            resp.getWriter().println("<link type=\"text/css\" rel=\"stylesheet\" href=\"/stylesheets/main.css\" />");
            resp.getWriter().println("</head>");
            resp.getWriter().println("<body>");
            resp.getWriter().println("Phone Number entered: " + phoneNumber + "<br>");
            resp.getWriter().println("defaultCountry entered: " + defaultCountry + "<br>");
            resp.getWriter().println("Language entered: " + languageCode + (regionCode.length() == 0 ? "" : " (" + regionCode + ")" + "<br>"));
        } else {
            output = this.getOutputForFile(defaultCountry, fileContents);
            resp.setContentType("text/html");
        }
        resp.getWriter().println(output);
        resp.getWriter().println("</body></html>");
    }

    private StringBuilder getOutputForFile(String defaultCountry, String fileContents) {
        StringBuilder output = new StringBuilder();
        output.append("<HTML><HEAD><TITLE>Results generated from phone numbers in the file provided:</TITLE></HEAD><BODY>");
        output.append("<TABLE align=center border=1>");
        output.append("<TH align=center>ID</TH>");
        output.append("<TH align=center>Raw phone number</TH>");
        output.append("<TH align=center>Pretty formatting</TH>");
        output.append("<TH align=center>International format</TH>");
        int phoneNumberId = 0;
        StringTokenizer tokenizer = new StringTokenizer(fileContents, ",");
        while (tokenizer.hasMoreTokens()) {
            String numberStr = tokenizer.nextToken();
            output.append("<TR>");
            output.append("<TD align=center>").append(++phoneNumberId).append(" </TD> \n");
            output.append("<TD align=center>").append(numberStr).append(" </TD> \n");
            try {
                Phonenumber.PhoneNumber number = this.phoneUtil.parseAndKeepRawInput(numberStr, defaultCountry);
                boolean isNumberValid = this.phoneUtil.isValidNumber(number);
                String prettyFormat = isNumberValid ? this.phoneUtil.formatInOriginalFormat(number, defaultCountry) : "invalid";
                String internationalFormat = isNumberValid ? this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL) : "invalid";
                output.append("<TD align=center>").append(prettyFormat).append(" </TD> \n");
                output.append("<TD align=center>").append(internationalFormat).append(" </TD> \n");
            }
            catch (NumberParseException e) {
                output.append("<TD align=center colspan=2>").append(e.toString()).append(" </TD> \n");
            }
            output.append("</TR>");
        }
        output.append("</BODY></HTML>");
        return output;
    }

    private void appendLine(String title, String data, StringBuilder output) {
        output.append("<TR>");
        output.append("<TH>").append(title).append("</TH>");
        output.append("<TD>").append(data.length() > 0 ? data : "&nbsp;").append("</TD>");
        output.append("</TR>");
    }

    private StringBuilder getOutputForSingleNumber(String phoneNumber, String defaultCountry, String languageCode, String regionCode) {
        StringBuilder output = new StringBuilder();
        try {
            Phonenumber.PhoneNumber number = this.phoneUtil.parseAndKeepRawInput(phoneNumber, defaultCountry);
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>Parsing Result</TD></TR>");
            this.appendLine("country_code", Integer.toString(number.getCountryCode()), output);
            this.appendLine("national_number", Long.toString(number.getNationalNumber()), output);
            this.appendLine("extension", number.getExtension(), output);
            this.appendLine("country_code_source", number.getCountryCodeSource().toString(), output);
            this.appendLine("italian_leading_zero", Boolean.toString(number.isItalianLeadingZero()), output);
            this.appendLine("raw_input", number.getRawInput(), output);
            output.append("</TABLE>");
            output.append("</DIV>");
            boolean isPossible = this.phoneUtil.isPossibleNumber(number);
            boolean isNumberValid = this.phoneUtil.isValidNumber(number);
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>Validation Results</TD></TR>");
            this.appendLine("Result from isPossibleNumber()", Boolean.toString(isPossible), output);
            if (!isPossible) {
                this.appendLine("Result from isPossibleNumberWithReason()", this.phoneUtil.isPossibleNumberWithReason(number).toString(), output);
                output.append("<TR><TD colspan=2>Note: numbers that are not possible have type UNKNOWN, an unknown region, and are considered invalid.</TD></TR>");
            } else {
                String region;
                this.appendLine("Result from isValidNumber()", Boolean.toString(isNumberValid), output);
                if (isNumberValid && !defaultCountry.isEmpty() && defaultCountry != "ZZ") {
                    this.appendLine("Result from isValidNumberForRegion()", Boolean.toString(this.phoneUtil.isValidNumberForRegion(number, defaultCountry)), output);
                }
                this.appendLine("Phone Number region", (region = this.phoneUtil.getRegionCodeForNumber(number)) == null ? "" : region, output);
                this.appendLine("Result from getNumberType()", this.phoneUtil.getNumberType(number).toString(), output);
            }
            output.append("</TABLE>");
            output.append("</DIV>");
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>Formatting Results</TD></TR>");
            this.appendLine("E164 format", isNumberValid ? this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.E164) : "invalid", output);
            this.appendLine("Original format", this.phoneUtil.formatInOriginalFormat(number, defaultCountry), output);
            this.appendLine("National format", this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.NATIONAL), output);
            this.appendLine("International format", isNumberValid ? this.phoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL) : "invalid", output);
            this.appendLine("Out-of-country format from US", isNumberValid ? this.phoneUtil.formatOutOfCountryCallingNumber(number, "US") : "invalid", output);
            this.appendLine("Out-of-country format from CH", isNumberValid ? this.phoneUtil.formatOutOfCountryCallingNumber(number, "CH") : "invalid", output);
            output.append("</TABLE>");
            output.append("</DIV>");
            AsYouTypeFormatter formatter = this.phoneUtil.getAsYouTypeFormatter(defaultCountry);
            int rawNumberLength = phoneNumber.length();
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>AsYouTypeFormatter Results</TD></TR>");
            for (int i = 0; i < rawNumberLength; ++i) {
                char inputChar = phoneNumber.charAt(i);
                this.appendLine("Char entered: '" + inputChar + "' Output: ", formatter.inputDigit(inputChar), output);
            }
            output.append("</TABLE>");
            output.append("</DIV>");
            output.append("<DIV>");
            output.append("<TABLE border=1>");
            output.append("<TR><TD colspan=2>PhoneNumberOfflineGeocoder Results</TD></TR>");
            this.appendLine("Location", PhoneNumberOfflineGeocoder.getInstance().getDescriptionForNumber(number, new Locale(languageCode, regionCode)), output);
            output.append("</TABLE>");
            output.append("</DIV>");
        }
        catch (NumberParseException e) {
            output.append(e.toString());
        }
        return output;
    }
}

