/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import org.ejml.alg.dense.decomposition.DecompositionFactory;
import org.ejml.alg.dense.decomposition.EigenDecomposition;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.simple.SimpleMatrix;

public class SimpleEVD<T extends SimpleMatrix> {
    private EigenDecomposition<DenseMatrix64F> eig;
    DenseMatrix64F mat;

    public SimpleEVD(DenseMatrix64F mat) {
        this.mat = mat;
        this.eig = DecompositionFactory.eig(mat.numCols);
        if (!this.eig.decompose(mat)) {
            throw new RuntimeException("Eigenvalue Decomposition failed");
        }
    }

    public int getNumberOfEigenvalues() {
        return this.eig.getNumberOfEigenvalues();
    }

    public Complex64F getEigenvalue(int index) {
        return this.eig.getEigenvalue(index);
    }

    public T getEigenVector(int index) {
        return (T)SimpleMatrix.wrap(this.eig.getEigenVector(index));
    }

    public double quality() {
        return DecompositionFactory.quality(this.mat, this.eig);
    }

    public EigenDecomposition getEVD() {
        return this.eig;
    }
}

