/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Subject;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public final class OptionalIntSubject
extends Subject<OptionalIntSubject, OptionalInt> {
    OptionalIntSubject(FailureMetadata failureMetadata, @Nullable OptionalInt subject) {
        super(failureMetadata, (Object)subject);
    }

    public void isPresent() {
        if (this.actual() == null || !((OptionalInt)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isEmpty() {
        if (this.actual() == null || ((OptionalInt)this.actual()).isPresent()) {
            this.fail("is empty");
        }
    }

    public void hasValue(int expected) {
        if (this.actual() == null || !((OptionalInt)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            int actual = ((OptionalInt)this.actual()).getAsInt();
            if (actual != expected) {
                this.fail("has value", expected);
            }
        }
    }

    public IntegerSubject hasValueThat() {
        if (this.actual() == null || !((OptionalInt)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
            return this.ignoreCheck().that(Integer.valueOf(0));
        }
        return this.check().that(Integer.valueOf(((OptionalInt)this.actual()).getAsInt()));
    }

    public static Subject.Factory<OptionalIntSubject, OptionalInt> optionalInts() {
        return OptionalIntSubject::new;
    }
}

