/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.Lists;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class ExprUnion {
    @Nullable
    private final ExprRootNode expr;
    @Nullable
    private final String exprText;

    public static List<ExprUnion> createList(List<? extends ExprRootNode> exprs) {
        ArrayList exprUnions = Lists.newArrayListWithCapacity((int)exprs.size());
        for (ExprRootNode exprRootNode : exprs) {
            exprUnions.add(new ExprUnion(exprRootNode));
        }
        return exprUnions;
    }

    public ExprUnion(ExprNode expr) {
        this(new ExprRootNode(expr));
    }

    public ExprUnion(ExprRootNode expr) {
        this.expr = expr;
        this.exprText = null;
    }

    public ExprUnion(String exprTextV1) {
        this.expr = null;
        this.exprText = exprTextV1;
    }

    private ExprUnion(ExprUnion orig, CopyState copyState) {
        this.expr = orig.expr != null ? orig.expr.copy(copyState) : null;
        this.exprText = orig.exprText;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    public String getExprText() {
        return this.expr != null ? this.expr.toSourceString() : this.exprText;
    }

    public ExprUnion copy(CopyState copyState) {
        return new ExprUnion(this, copyState);
    }
}

