/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import java.util.ArrayList;
import java.util.List;

public final class FormattingErrorReporter
implements ErrorReporter {
    private final List<String> errorMessages = new ArrayList<String>();

    @Override
    public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        this.errorMessages.add(error.format(args));
    }

    @Override
    public ErrorReporter.Checkpoint checkpoint() {
        return new CheckpointImpl(this.errorMessages.size());
    }

    @Override
    public boolean errorsSince(ErrorReporter.Checkpoint checkpoint) {
        return this.errorMessages.size() > ((CheckpointImpl)checkpoint).numErrors;
    }

    public ImmutableList<String> getErrorMessages() {
        return ImmutableList.copyOf(this.errorMessages);
    }

    private static final class CheckpointImpl
    implements ErrorReporter.Checkpoint {
        private final int numErrors;

        private CheckpointImpl(int numErrors) {
            this.numErrors = numErrors;
        }
    }
}

