/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.inject.Injector;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class SoyToJbcSrcCompiler {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.SoyToJbcSrcCompiler  \\\n     [<flag1> <flag2> ...] --jar <jarName>  \\\n     --srcs <soyFilePath>,... [--deps <soyFilePath>,...]\n";
    @Option(name="--srcs", usage="The list of source Soy files. Extra arguments are treated as srcs. Sources are required from either this flag or as extra arguments.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> srcs = new ArrayList<String>();
    @Option(name="--deps", usage="The list of dependency Soy files (if applicable). The compiler needs deps for analysis/checking, but will not generate code for dep files.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> deps = new ArrayList<String>();
    @Option(name="--indirectDeps", usage="Soy files required by deps, but which may not be used by srcs.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> indirectDeps = new ArrayList<String>();
    @Option(name="--output", required=true, usage="[Required] The file name of the JAR file to be written.  Each compiler invocation will produce exactly one file")
    private String output = "";
    @Option(name="--outputSrcJar", required=false, usage="[Optional] The file name of the JAR containing sources to be written.  Each compiler invocation will produce exactly one such file.  This may be useful for enablingIDE debugging scenarios")
    private String outputSrcJar = "";
    @Option(name="--globals_file", usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().")
    private String globalsFile = "";
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).")
    private String pluginModules = "";

    public static void main(final String[] args) throws IOException, SoySyntaxException {
        MainClassUtils.run(new MainClassUtils.Main(){

            @Override
            public void main() throws IOException {
                new SoyToJbcSrcCompiler().execMain(args);
            }
        });
    }

    private SoyToJbcSrcCompiler() {
    }

    private void execMain(String[] args) throws IOException {
        final CmdLineParser cmdLineParser = MainClassUtils.parseFlags(this, args, USAGE_PREFIX);
        Function<String, Void> exitWithErrorFn = new Function<String, Void>(){

            public Void apply(String errorMsg) {
                MainClassUtils.exitWithError(errorMsg, cmdLineParser, SoyToJbcSrcCompiler.USAGE_PREFIX);
                return null;
            }
        };
        if (this.output.length() == 0) {
            MainClassUtils.exitWithError("Must provide a JAR file name (--jar <file name>).", cmdLineParser, USAGE_PREFIX);
        }
        Injector injector = MainClassUtils.createInjectorForPlugins(this.pluginModules);
        SoyFileSet.Builder sfsBuilder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        MainClassUtils.addSoyFilesToBuilder(sfsBuilder, "", this.srcs, (Collection<String>)ImmutableSet.of(), this.deps, this.indirectDeps, exitWithErrorFn);
        sfsBuilder.setAllowExternalCalls(false);
        if (this.globalsFile.length() > 0) {
            sfsBuilder.setCompileTimeGlobals(new File(this.globalsFile));
        }
        SoyFileSet sfs = sfsBuilder.build();
        Optional srcJarSink = Optional.absent();
        if (!this.outputSrcJar.isEmpty()) {
            srcJarSink = Optional.of((Object)Files.asByteSink((File)new File(this.outputSrcJar), (FileWriteMode[])new FileWriteMode[0]));
        }
        sfs.compileToJar(Files.asByteSink((File)new File(this.output), (FileWriteMode[])new FileWriteMode[0]), (Optional<ByteSink>)srcJarSink);
    }
}

