/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeProvider;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.DescriptorTreeWalker;
import com.google.template.soy.types.proto.ProtoUtils;
import com.google.template.soy.types.proto.SafeStringTypes;
import com.google.template.soy.types.proto.SoyProtoEnumType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;

public final class SoyProtoTypeProvider
implements SoyTypeProvider {
    private static final ExtensionRegistry REGISTRY = SoyProtoTypeProvider.createRegistry();
    private final Object lock = new Object();
    private final ConcurrentMap<String, Descriptors.GenericDescriptor> descriptors = new ConcurrentHashMap<String, Descriptors.GenericDescriptor>();
    @GuardedBy(value="lock")
    private final SetMultimap<String, Descriptors.FieldDescriptor> extensions = MultimapBuilder.hashKeys().treeSetValues((Comparator)new Comparator<Descriptors.FieldDescriptor>(){

        @Override
        public int compare(Descriptors.FieldDescriptor left, Descriptors.FieldDescriptor right) {
            return ComparisonChain.start().compare(left.getNumber(), right.getNumber()).compare((Comparable)((Object)left.getContainingType().getFullName()), (Comparable)((Object)right.getContainingType().getFullName())).result();
        }
    }).build();
    @GuardedBy(value="lock")
    private final Map<String, SoyType> typeCache = new HashMap<String, SoyType>();

    private static final ExtensionRegistry createRegistry() {
        ExtensionRegistry instance = ExtensionRegistry.newInstance();
        return instance;
    }

    private SoyProtoTypeProvider() {
        this.typeCache.putAll((Map<String, SoyType>)SafeStringTypes.SAFE_PROTO_TO_SANITIZED_TYPE);
    }

    public static SoyProtoTypeProvider empty() {
        return new Builder().buildNoFiles();
    }

    @Override
    public SoyType getType(String name, SoyTypeRegistry typeRegistry) {
        Descriptors.GenericDescriptor descriptor = (Descriptors.GenericDescriptor)this.descriptors.get(name);
        if (descriptor == null) {
            return null;
        }
        return this.doGetType(name, typeRegistry, descriptor);
    }

    SoyProtoType getType(Descriptors.Descriptor descriptor, SoyTypeRegistry registry) {
        String fullName = descriptor.getFullName();
        if (!this.descriptors.containsKey(fullName)) {
            DescriptorAddingDescriptorTreeWalker walker = new DescriptorAddingDescriptorTreeWalker();
            walker.walkDescriptor((Descriptors.GenericDescriptor)descriptor);
            walker.commitInto(this);
        }
        return (SoyProtoType)this.doGetType(fullName, registry, (Descriptors.GenericDescriptor)descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoyType doGetType(String name, SoyTypeRegistry typeRegistry, Descriptors.GenericDescriptor descriptor) {
        SoyType type;
        Object object = this.lock;
        synchronized (object) {
            type = this.typeCache.get(name);
            if (type == null) {
                type = descriptor instanceof Descriptors.EnumDescriptor ? new SoyProtoEnumType((Descriptors.EnumDescriptor)descriptor) : new SoyProtoType(typeRegistry, (Descriptors.Descriptor)descriptor, this.extensions.get((Object)name));
                this.typeCache.put(name, type);
            }
        }
        return type;
    }

    static final class DescriptorAddingDescriptorTreeWalker
    extends DescriptorTreeWalker {
        private final Map<String, Descriptors.GenericDescriptor> descriptors = new LinkedHashMap<String, Descriptors.GenericDescriptor>();
        private final Multimap<String, Descriptors.FieldDescriptor> extensions = LinkedListMultimap.create();

        DescriptorAddingDescriptorTreeWalker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commitInto(SoyProtoTypeProvider provider) {
            Object object = provider.lock;
            synchronized (object) {
                provider.descriptors.putAll(this.descriptors);
                provider.extensions.putAll(this.extensions);
            }
        }

        @Override
        void visitMessageDescriptor(Descriptors.Descriptor descriptor) {
            this.descriptors.put(descriptor.getFullName(), (Descriptors.GenericDescriptor)descriptor);
        }

        @Override
        void visitFieldDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
            if (ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) {
                return;
            }
            this.maybeWalkFieldType(fieldDescriptor);
        }

        @Override
        void visitEnumDescriptor(Descriptors.EnumDescriptor enumDescriptor) {
            this.descriptors.put(enumDescriptor.getFullName(), (Descriptors.GenericDescriptor)enumDescriptor);
        }

        @Override
        void visitExtensionDescriptor(Descriptors.FieldDescriptor extension) {
            if (ProtoUtils.shouldJsIgnoreField(extension)) {
                return;
            }
            String containingType = extension.getContainingType().getFullName();
            if (this.extensions.put((Object)containingType, (Object)extension)) {
                this.maybeWalkFieldType(extension);
            }
        }

        private void maybeWalkFieldType(Descriptors.FieldDescriptor fieldDescriptor) {
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                this.walkDescriptor((Descriptors.GenericDescriptor)fieldDescriptor.getMessageType());
            } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                this.walkDescriptor((Descriptors.GenericDescriptor)fieldDescriptor.getEnumType());
            }
        }
    }

    public static final class Builder {
        private final List<ByteSource> descriptorSources = new ArrayList<ByteSource>();
        private final List<DescriptorProtos.FileDescriptorSet> descriptorSets = new ArrayList<DescriptorProtos.FileDescriptorSet>();
        private final List<Descriptors.GenericDescriptor> descriptors = new ArrayList<Descriptors.GenericDescriptor>();

        public Builder addFileDescriptorSetFromFile(File descriptorFile) {
            return this.addFileDescriptorSetFromByteSource(Files.asByteSource((File)descriptorFile));
        }

        public Builder addFileDescriptorSetFromByteSource(ByteSource descriptorSource) {
            this.descriptorSources.add(descriptorSource);
            return this;
        }

        public Builder addFileDescriptorSet(DescriptorProtos.FileDescriptorSet descriptorSet) {
            this.descriptorSets.add(descriptorSet);
            return this;
        }

        public Builder addDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptorsToAdd) {
            for (Descriptors.GenericDescriptor genericDescriptor : descriptorsToAdd) {
                this.descriptors.add(genericDescriptor);
            }
            return this;
        }

        public Builder addDescriptors(Descriptors.GenericDescriptor ... descriptorsToAdd) {
            Collections.addAll(this.descriptors, descriptorsToAdd);
            return this;
        }

        public boolean isEmpty() {
            return this.descriptorSources.isEmpty() && this.descriptorSets.isEmpty() && this.descriptors.isEmpty();
        }

        private void walkAll(DescriptorTreeWalker walker) throws FileNotFoundException, IOException, Descriptors.DescriptorValidationException {
            LinkedHashMap<String, DescriptorProtos.FileDescriptorProto> nameToProtos = new LinkedHashMap<String, DescriptorProtos.FileDescriptorProto>();
            for (ByteSource source : this.descriptorSources) {
                InputStream inputStream = source.openStream();
                Throwable throwable = null;
                try {
                    for (DescriptorProtos.FileDescriptorProto file : DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream, (ExtensionRegistryLite)REGISTRY).getFileList()) {
                        nameToProtos.put(file.getName(), file);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            for (DescriptorProtos.FileDescriptorSet descriptorSet : this.descriptorSets) {
                for (DescriptorProtos.FileDescriptorProto file : descriptorSet.getFileList()) {
                    nameToProtos.put(file.getName(), file);
                }
            }
            HashMap<String, Descriptors.FileDescriptor> parsedDescriptors = new HashMap<String, Descriptors.FileDescriptor>();
            for (String name : nameToProtos.keySet()) {
                walker.walkDescriptor((Descriptors.GenericDescriptor)Builder.buildDescriptor(name, parsedDescriptors, nameToProtos));
            }
            walker.walkDescriptors(this.descriptors);
        }

        private static Descriptors.FileDescriptor buildDescriptor(String name, Map<String, Descriptors.FileDescriptor> descriptors, Map<String, DescriptorProtos.FileDescriptorProto> protos) throws Descriptors.DescriptorValidationException {
            Descriptors.FileDescriptor file = descriptors.get(name);
            if (file != null) {
                return file;
            }
            DescriptorProtos.FileDescriptorProto proto = protos.get(name);
            Descriptors.FileDescriptor[] deps = new Descriptors.FileDescriptor[proto.getDependencyCount()];
            for (int i = 0; i < proto.getDependencyCount(); ++i) {
                deps[i] = Builder.buildDescriptor(proto.getDependency(i), descriptors, protos);
            }
            file = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)proto, (Descriptors.FileDescriptor[])deps);
            descriptors.put(name, file);
            return file;
        }

        public SoyProtoTypeProvider build() throws FileNotFoundException, IOException, Descriptors.DescriptorValidationException {
            SoyProtoTypeProvider provider = new SoyProtoTypeProvider();
            DescriptorAddingDescriptorTreeWalker walker = new DescriptorAddingDescriptorTreeWalker();
            this.walkAll(walker);
            walker.commitInto(provider);
            return provider;
        }

        public SoyProtoTypeProvider buildNoFiles() {
            Preconditions.checkState((boolean)this.descriptorSources.isEmpty(), (Object)"use build(), not buildNoFiles() to load descriptors from files");
            try {
                return this.build();
            }
            catch (Descriptors.DescriptorValidationException | IOException ex) {
                throw new AssertionError("File system should not have been touched", ex);
            }
        }
    }
}

