/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.ProtoUtils;

public final class SoyProtoEnumType
implements SoyType {
    private final Descriptors.EnumDescriptor descriptor;

    public SoyProtoEnumType(Descriptors.EnumDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO_ENUM;
    }

    @Override
    public boolean isAssignableFrom(SoyType fromType) {
        return fromType == this || fromType.getClass() == this.getClass() && ((SoyProtoEnumType)fromType).descriptor == this.descriptor;
    }

    @Override
    public boolean isInstance(SoyValue value) {
        return value instanceof IntegerData;
    }

    public String getName() {
        return this.descriptor.getFullName();
    }

    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return ProtoUtils.calculateJsEnumName(this.descriptor);
            }
            case TOFU: {
                return JavaQualifiedNames.getQualifiedName(this.descriptor) + ".getDescriptor()";
            }
        }
        throw new UnsupportedOperationException();
    }

    public Integer getValue(String memberName) {
        Descriptors.EnumValueDescriptor value = this.descriptor.findValueByName(memberName);
        if (value != null) {
            return value.getNumber();
        }
        return null;
    }

    public String getDescriptorExpression() {
        return this.getNameForBackend(SoyBackendKind.TOFU);
    }

    public String toString() {
        return this.getName();
    }
}

