/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class PrintDirectiveNode
extends AbstractSoyNode
implements SoyNode.ExprHolderNode {
    private final String name;
    private final ImmutableList<ExprRootNode> args;

    public PrintDirectiveNode(int id, SourceLocation location, String name, ImmutableList<ExprNode> args) {
        super(id, location);
        Preconditions.checkArgument((name.charAt(0) == '|' ? 1 : 0) != 0);
        this.name = name;
        this.args = ExprRootNode.wrap(args);
    }

    private PrintDirectiveNode(PrintDirectiveNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        ArrayList tempArgs = Lists.newArrayListWithCapacity((int)orig.args.size());
        for (ExprRootNode origArg : orig.args) {
            tempArgs.add(origArg.copy(copyState));
        }
        this.args = ImmutableList.copyOf((Collection)tempArgs);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_DIRECTIVE_NODE;
    }

    public String getName() {
        return this.name;
    }

    public List<ExprRootNode> getArgs() {
        return this.args;
    }

    @Override
    public String toSourceString() {
        return this.args.isEmpty() ? this.name : this.name + ":" + SoyTreeUtils.toSourceString(this.args);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return this.args;
    }

    @Override
    public PrintDirectiveNode copy(CopyState copyState) {
        return new PrintDirectiveNode(this, copyState);
    }
}

