/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.SoyNode;

public final class CallParamValueNode
extends CallParamNode
implements SoyNode.ExprHolderNode {
    private final ExprRootNode valueExpr;

    public CallParamValueNode(int id, SourceLocation location, Identifier key, ExprNode valueExpr) {
        super(id, location, key);
        this.valueExpr = new ExprRootNode(valueExpr);
    }

    private CallParamValueNode(CallParamValueNode orig, CopyState copyState) {
        super(orig, copyState);
        this.valueExpr = orig.valueExpr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_PARAM_VALUE_NODE;
    }

    public ExprRootNode getExpr() {
        return this.valueExpr;
    }

    @Override
    public String getCommandText() {
        return this.getKey().identifier() + " : " + this.valueExpr.toSourceString();
    }

    @Override
    public String getTagString() {
        return this.getTagString(true);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.valueExpr);
    }

    @Override
    public CallParamValueNode copy(CopyState copyState) {
        return new CallParamValueNode(this, copyState);
    }
}

