/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CallNode
extends AbstractParentCommandNode<CallParamNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CallParamNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode {
    private static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private boolean isPassingAllData;
    @Nullable
    private ExprRootNode dataExpr;
    @Nullable
    private final String userSuppliedPlaceholderName;
    private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();
    private boolean isPcData = false;

    protected CallNode(int id, SourceLocation location, String commandName, List<CommandTagAttribute> attributes) {
        super(id, location, commandName);
        String phname = null;
        for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": {
                    ExprNode dataExpr = attr.valueAsExpr();
                    if (dataExpr instanceof GlobalNode && ((GlobalNode)dataExpr).getName().equals("all")) {
                        this.isPassingAllData = true;
                        this.dataExpr = null;
                        break;
                    }
                    this.isPassingAllData = false;
                    this.dataExpr = new ExprRootNode(dataExpr);
                    break;
                }
                case "phname": {
                    phname = attr.getValue();
                    break;
                }
            }
        }
        this.userSuppliedPlaceholderName = phname;
    }

    protected CallNode(CallNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isPassingAllData = orig.isPassingAllData;
        this.dataExpr = orig.dataExpr != null ? orig.dataExpr.copy(copyState) : null;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
        this.escapingDirectiveNames = orig.escapingDirectiveNames;
        this.isPcData = orig.getIsPcData();
    }

    public boolean isPassingData() {
        return this.isPassingAllData || this.dataExpr != null;
    }

    public boolean isPassingAllData() {
        return this.isPassingAllData;
    }

    @Nullable
    public ExprRootNode getDataExpr() {
        return this.dataExpr;
    }

    public void setDataAll() {
        this.isPassingAllData = true;
        this.dataExpr = null;
    }

    public boolean getIsPcData() {
        return this.isPcData;
    }

    public void setIsPcData(boolean isPcData) {
        this.isPcData = isPcData;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePhName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        return FALLBACK_BASE_PLACEHOLDER_NAME;
    }

    @Override
    public Object genSamenessKey() {
        return this;
    }

    @Override
    public String getTagString() {
        return this.getTagString(this.numChildren() == 0);
    }

    @Override
    public String toSourceString() {
        return this.numChildren() == 0 ? this.getTagString() : super.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return this.dataExpr != null ? ImmutableList.of((Object)this.dataExpr) : ImmutableList.of();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    public abstract ImmutableList<TemplateParam> getParamsToRuntimeCheck(TemplateNode var1);

    public ImmutableList<String> getEscapingDirectiveNames() {
        return this.escapingDirectiveNames;
    }

    public void setEscapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
        this.escapingDirectiveNames = escapingDirectiveNames;
    }
}

