/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.RawTextBuilder;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.SoyParseUtils;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.XidNode;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.NullType;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final SoyErrorKind INVALID_ALIAS_NAME = SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_CALLEE_NAME = SoyErrorKind.of("Invalid callee name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_DELTEMPLATE_NAME = SoyErrorKind.of("Deltemplate ''{0}'' must have a fully qualified name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PRINT_COMMAND_TEXT = SoyErrorKind.of("Invalid ''print'' command text \"{0}\" (check the directives).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_RANGE_SPECIFICATION = SoyErrorKind.of("Invalid range specification.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TEMPLATE_NAME = SoyErrorKind.of("Template name ''{0}'' must be relative to the file namespace, i.e. a dot followed by an identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND = SoyErrorKind.of("Found multiple ''phname'' attributes in command text \"{0}\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK = SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS = SoyErrorKind.of("Plural case ''{0}'' must be a nonnegative integer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_MALFORMED = SoyErrorKind.of("Invalid number in ''plural case'' command text.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_OFFSET_OUT_OF_BOUNDS = SoyErrorKind.of("The ''offset'' for plural must be a positive integer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PRINT_COMMAND_WITH_EMPTY_TEXT = SoyErrorKind.of("Found ''print'' command with empty command text.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SELECT_CASE_INVALID_VALUE = SoyErrorKind.of("Invalid value for select ''case'', expected ''female'', ''male'', or ''other''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER = SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE = SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_PARAM_NAME = SoyErrorKind.of("Duplicate param name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INTEGER_OUT_OF_RANGE = SoyErrorKind.of("Soy integers are constrained to the range of JavaScript integers: https://www.ecma-international.org/ecma-262/5.1/#sec-8.5", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_FUNCTION_NAME = SoyErrorKind.of("Invalid function name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_PARAM_NAME = SoyErrorKind.of("Invalid param name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VAR_NAME_IJ = SoyErrorKind.of("Invalid var name ''ij'' (''ij'' is for injected data ref).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Disallowed single-identifier key \"{0}\" in map literal (please surround with single quotes for string or parentheses for global).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARSER_ERROR = SoyErrorKind.of("parse error at ''{0}'': expected {1}", SoyErrorKind.StyleAllowance.NO_CAPS, SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private SoyTypeRegistry typeRegistry;
    private IdGenerator nodeIdGen;
    private SoyFileKind soyFileKind;
    private String filePath;
    private ErrorReporter errorReporter;
    private TemplateNode.SoyFileHeaderInfo headerInfo;
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[93];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static ExprNode parseExprOrDie(String exprText) {
        return SoyFileParser.parseExpression(exprText, ExplodingErrorReporter.get());
    }

    @Nullable
    public static ExprNode parseExpression(String exprText, ErrorReporter errorReporter) {
        SoyFileParser parser = new SoyFileParser(exprText, errorReporter);
        try {
            return parser.ExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(errorReporter, "expression parser", e, parser.token_source.curLexState);
            return null;
        }
    }

    public SoyFileParser(SoyTypeRegistry typeRegistry, IdGenerator nodeIdGen, Reader input, SoyFileKind soyFileKind, String filePath, ErrorReporter errorReporter) {
        this(input);
        this.typeRegistry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)typeRegistry);
        this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
        this.soyFileKind = (SoyFileKind)((Object)Preconditions.checkNotNull((Object)((Object)soyFileKind)));
        this.filePath = (String)Preconditions.checkNotNull((Object)filePath);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
    }

    private SoyFileParser(String input, ErrorReporter errorReporter) {
        this(new SoyFileParserTokenManager(new SimpleCharStream(new StringReader(input), 1, 1), 2));
        this.filePath = "expression parser";
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
    }

    @Nullable
    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.typeRegistry);
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e, this.token_source.curLexState);
        }
        catch (LegacyInternalSyntaxException e) {
            ParseErrors.reportLegacyInternalSyntaxException(this.errorReporter, this.filePath, e);
        }
        catch (TokenMgrError e) {
            ParseErrors.reportTokenMgrError(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        return soyFileNode;
    }

    String getFilePath() {
        return this.filePath;
    }

    private Token reportFileErrorAndSkipTo(ParseException error, int skipTo) {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        do {
            t = this.getNextToken();
        } while (t.kind != skipTo && t.kind != 0);
        return t;
    }

    private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int ... kinds) {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        ImmutableSet skipTo = ImmutableSet.copyOf((Collection)Ints.asList((int[])kinds));
        do {
            t = this.getNextToken();
            if (t.kind != 24 && t.kind != 25) continue;
            throw new AbortParsingError();
        } while (!skipTo.contains((Object)t.kind) && t.kind != 0);
        return t;
    }

    private SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private VarRefNode errorExpr(Token tok1, Token ... rest) {
        return VarRefNode.error(this.createSrcLoc(tok1, rest));
    }

    private VarRefNode errorExpr(SourceLocation location) {
        return VarRefNode.error(location);
    }

    private final SoyFileNode SoyFile() throws ParseException {
        Identifier delpackageName = null;
        Object aliases = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                delpackageName = this.DelPackage();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        NamespaceDeclaration namespace = this.Namespace();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            AliasDeclaration alias = this.Alias();
            if (aliases.isEmpty()) {
                aliases = new ArrayList();
            }
            if (alias == null) continue;
            aliases.add(alias);
        }
        this.headerInfo = new TemplateNode.SoyFileHeaderInfo(this.errorReporter, delpackageName, namespace, (Collection<AliasDeclaration>)aliases);
        SoyFileNode sfn = new SoyFileNode(this.nodeIdGen.genId(), this.filePath, this.soyFileKind, namespace, this.headerInfo);
        block10: while (true) {
            TemplateNode template;
            if ((template = this.Template(this.headerInfo)) != null) {
                sfn.addChild(template);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: 
                case 23: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(0);
        if ("" != null) {
            return sfn;
        }
        throw new Error("Missing return statement in function");
    }

    private final AliasDeclaration Alias() throws ParseException {
        String aliasString;
        Identifier alias = null;
        Token as = null;
        Token open = this.jj_consume_token(10);
        Identifier namespace = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: {
                as = this.Keyword("as");
                alias = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(74);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        if (alias != null && !BaseUtils.isIdentifier(alias.identifier())) {
            this.errorReporter.report(srcLoc, INVALID_ALIAS_NAME, alias.identifier());
            if ("" != null) {
                return null;
            }
        }
        String string = aliasString = alias == null ? BaseUtils.extractPartAfterLastDot(namespace.identifier()) : alias.identifier();
        if ("" != null) {
            return new AliasDeclaration(namespace.identifier(), aliasString, srcLoc);
        }
        throw new Error("Missing return statement in function");
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        Token open = this.jj_consume_token(11);
        Identifier name = this.DottedIdent();
        List<CommandTagAttribute> attributes = this.Attributes();
        Token close = this.jj_consume_token(74);
        if ("" != null) {
            return new NamespaceDeclaration(name, attributes, this.errorReporter);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<CommandTagAttribute> Attributes() throws ParseException {
        Object attributes = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 16: 
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            CommandTagAttribute attr = this.Attribute();
            if (attributes.isEmpty()) {
                attributes = new ArrayList();
            }
            attributes.add(attr);
        }
        CommandTagAttribute.removeDuplicatesAndReportErrors((Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        if ("" != null) {
            return attributes;
        }
        throw new Error("Missing return statement in function");
    }

    private final CommandTagAttribute Attribute() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                Token name = this.jj_consume_token(76);
                this.jj_consume_token(78);
                this.jj_consume_token(13);
                Token value = this.jj_consume_token(19);
                if ("" == null) break;
                return new CommandTagAttribute(Identifier.create(name.image, this.createSrcLoc(name, new Token[0])), value.image, this.createSrcLoc(value, new Token[0]));
            }
            case 14: 
            case 15: 
            case 16: {
                ImmutableList exprList;
                String attrName;
                Token attrTag;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        attrTag = this.jj_consume_token(14);
                        attrName = "data";
                        break;
                    }
                    case 15: {
                        attrTag = this.jj_consume_token(15);
                        attrName = "variant";
                        break;
                    }
                    case 16: {
                        attrTag = this.jj_consume_token(16);
                        attrName = "genders";
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                try {
                    exprList = this.ExprList();
                    this.jj_consume_token(18);
                }
                catch (ParseException e) {
                    exprList = ImmutableList.of((Object)this.errorExpr(e.currentToken, new Token[0]));
                    this.reportTemplateBodyErrorAndSkipTo(e, 18);
                }
                this.token_source.SwitchTo(1);
                if ("" == null) break;
                return new CommandTagAttribute(Identifier.create(attrName, this.createSrcLoc(attrTag, new Token[0])), (ImmutableList<ExprNode>)exprList);
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final CommandTagAttribute ExprAttribute() throws ParseException {
        Token name = this.jj_consume_token(133);
        this.jj_consume_token(17);
        Token value = this.jj_consume_token(19);
        if ("" != null) {
            return new CommandTagAttribute(Identifier.create(name.image, this.createSrcLoc(name, new Token[0])), value.image, this.createSrcLoc(value, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DelPackage() throws ParseException {
        this.jj_consume_token(12);
        Identifier name = this.DottedIdent();
        this.jj_consume_token(74);
        if ("" != null) {
            return name;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        TemplateNode templateNode = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                Token open = this.jj_consume_token(23);
                TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open, false);
                    this.jj_consume_token(24);
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 24);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            case 22: {
                Token open = this.jj_consume_token(22);
                TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    templateNode = this.TemplateHelper(builder, open, true);
                    this.jj_consume_token(25);
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 25);
                    break;
                }
                catch (AbortParsingError e) {
                    if ("" == null) break;
                    return null;
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final TemplateNode TemplateHelper(TemplateNodeBuilder builder, Token open, boolean isDeltemplate) throws ParseException {
        builder.setId(this.nodeIdGen.genId());
        Identifier templateName = this.TemplateName();
        if (!isDeltemplate && templateName.type() != Identifier.Type.DOT_IDENT) {
            this.errorReporter.report(templateName.location(), INVALID_TEMPLATE_NAME, templateName.identifier());
        }
        if (isDeltemplate && templateName.type() == Identifier.Type.DOT_IDENT) {
            this.errorReporter.report(templateName.location(), INVALID_DELTEMPLATE_NAME, templateName.identifier());
        }
        List<CommandTagAttribute> attributes = this.Attributes();
        builder.setCommandValues(templateName, attributes);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 9) {
            builder.setSoyDoc(soyDoc.image, this.createSrcLoc(soyDoc, new Token[0]));
        }
        Token close = this.jj_consume_token(74);
        builder.setSourceLocation(this.createSrcLoc(open, close));
        RawTextNode initialWhitespace = this.TemplateHeader(builder);
        List<SoyNode.StandaloneNode> templateBodyNodes = this.TemplateBlock();
        TemplateNode templateNode = builder.build();
        if (initialWhitespace != null) {
            templateNode.addChild(initialWhitespace);
        }
        templateNode.addChildren(templateBodyNodes);
        if ("" != null) {
            return templateNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier TemplateName() throws ParseException {
        Identifier ident;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                Token dot = this.jj_consume_token(79);
                Token name = this.jj_consume_token(76);
                ident = Identifier.create("." + name.image, this.createSrcLoc(dot, name));
                break;
            }
            case 76: {
                ident = this.DottedIdent();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return ident;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier DottedIdent() throws ParseException {
        StringBuilder sb = null;
        Token next = null;
        Token name = this.jj_consume_token(76);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 79: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            Token dot = this.jj_consume_token(79);
            next = this.jj_consume_token(76);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(name.image);
            }
            sb.append('.').append(next.image);
        }
        if ("" != null) {
            return sb == null ? Identifier.create(name.image, this.createSrcLoc(name, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(name, next));
        }
        throw new Error("Missing return statement in function");
    }

    private final void SkipWhitespace() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 94: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(94);
        }
    }

    private final RawTextNode RawText() throws ParseException {
        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 94: 
                case 95: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 95: {
                            token = this.jj_consume_token(95);
                            break;
                        }
                        case 94: {
                            token = this.jj_consume_token(94);
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addBasic(token);
                    break;
                }
                case 38: {
                    this.jj_consume_token(38);
                    Token token = this.jj_consume_token(93);
                    builder.addLiteral(token);
                    break;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 31: {
                            token = this.jj_consume_token(31);
                            break;
                        }
                        case 32: {
                            token = this.jj_consume_token(32);
                            break;
                        }
                        case 34: {
                            token = this.jj_consume_token(34);
                            break;
                        }
                        case 33: {
                            token = this.jj_consume_token(33);
                            break;
                        }
                        case 35: {
                            token = this.jj_consume_token(35);
                            break;
                        }
                        case 36: {
                            token = this.jj_consume_token(36);
                            break;
                        }
                        case 37: {
                            token = this.jj_consume_token(37);
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addTextualCommand(token);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 94: 
                case 95: {
                    continue block21;
                }
            }
            break;
        }
        this.jj_la1[14] = this.jj_gen;
        if ("" != null) {
            return builder.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final RawTextNode TemplateHeader(TemplateNodeBuilder templateBuilder) throws ParseException {
        RawTextNode whitespace;
        Object params;
        block15: {
            params = ImmutableList.of();
            whitespace = null;
            String soyDoc = null;
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 94: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 94: {
                        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                        block11: while (true) {
                            Token tok = this.jj_consume_token(94);
                            if (tok.specialToken != null) {
                                soyDoc = tok.specialToken.image;
                            }
                            builder.addBasic(tok);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 94: {
                                    continue block11;
                                }
                            }
                            break;
                        }
                        this.jj_la1[16] = this.jj_gen;
                        whitespace = builder.build();
                        continue block10;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        HeaderParam param = this.ParamDecl(soyDoc);
                        whitespace = null;
                        soyDoc = null;
                        if (params.isEmpty()) {
                            params = new ArrayList();
                        }
                        params.add(param);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[17] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        templateBuilder.addParams((Iterable<? extends TemplateParam>)params);
        if ("" != null) {
            return whitespace;
        }
        throw new Error("Missing return statement in function");
    }

    private final HeaderParam ParamDecl(@Nullable String desc) throws ParseException {
        Token tagBegin;
        TypeNode paramTypeNode = null;
        SoyType paramType = ErrorType.getInstance();
        boolean optional = false;
        boolean inject = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: {
                tagBegin = this.jj_consume_token(26);
                break;
            }
            case 27: {
                tagBegin = this.jj_consume_token(27);
                optional = true;
                break;
            }
            case 28: {
                tagBegin = this.jj_consume_token(28);
                inject = true;
                break;
            }
            case 29: {
                tagBegin = this.jj_consume_token(29);
                inject = true;
                optional = true;
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (tagBegin.specialToken != null) {
            desc = tagBegin.specialToken.image;
        }
        Token name = this.jj_consume_token(76);
        this.jj_consume_token(77);
        this.token_source.SwitchTo(3);
        try {
            paramTypeNode = this.TypeExpr();
            paramType = this.typeRegistry.getOrCreateType(paramTypeNode, this.errorReporter);
            Token tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException parseException) {
            Token tagEnd = this.reportTemplateBodyErrorAndSkipTo(parseException, 74);
        }
        if (desc != null) {
            desc = desc.substring(3, desc.length() - 2).trim();
        }
        if ("" != null) {
            return new HeaderParam(name.image, this.createSrcLoc(name, new Token[0]), optional ? this.typeRegistry.getOrCreateUnionType(paramType, NullType.getInstance()) : paramType, paramTypeNode, !optional && !SoyTypes.isNullable(paramType), inject, desc);
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException {
        Object templateBlock = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 54: 
                case 56: 
                case 62: 
                case 66: 
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 94: 
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            SoyNode.StandaloneNode node = this.TemplateBlockItem();
            if (templateBlock.isEmpty()) {
                templateBlock = new ArrayList();
            }
            templateBlock.add(node);
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StandaloneNode TemplateBlockItem() throws ParseException {
        SoyNode.StandaloneNode node;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 94: 
            case 95: {
                node = this.RawText();
                break;
            }
            case 39: 
            case 40: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 62: 
            case 66: 
            case 69: 
            case 71: 
            case 72: 
            case 73: {
                node = this.Stmt();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return node;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode Stmt() throws ParseException {
        SoyNode.StatementNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: 
            case 69: 
            case 71: {
                stmt = this.NonPrintableStmt();
                break;
            }
            case 39: 
            case 40: 
            case 45: 
            case 48: 
            case 49: 
            case 72: 
            case 73: {
                stmt = this.PrintableStmt();
                break;
            }
            case 50: 
            case 56: 
            case 62: 
            case 66: {
                stmt = this.ControlFlowStmt();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode NonPrintableStmt() throws ParseException {
        AbstractCommandNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                stmt = this.LetStmt();
                break;
            }
            case 69: {
                stmt = this.LogStmt();
                break;
            }
            case 71: {
                stmt = this.DebuggerStmt();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode PrintableStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: {
                stmt = this.MsgStmt();
                break;
            }
            case 48: {
                stmt = this.XidStmt();
                break;
            }
            case 49: {
                stmt = this.CssStmt();
                break;
            }
            case 39: 
            case 40: {
                stmt = this.CallStmt();
                break;
            }
            case 72: 
            case 73: {
                stmt = this.PrintStmt();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final SoyNode.StatementNode ControlFlowStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                stmt = this.IfStmt();
                break;
            }
            case 62: {
                stmt = this.SwitchStmt();
                break;
            }
            case 66: {
                stmt = this.ForeachStmt();
                break;
            }
            case 56: {
                stmt = this.ForStmt();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return stmt;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgFallbackGroupNode MsgStmt() throws ParseException {
        Token tagEnd;
        Object attributes = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(45);
        try {
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        SourceLocation loc = this.createSrcLoc(tagBegin, tagEnd);
        MsgFallbackGroupNode msgGroup = new MsgFallbackGroupNode(this.nodeIdGen.genId(), loc);
        MsgNode msg = new MsgNode(this.nodeIdGen.genId(), loc, "msg", (List<CommandTagAttribute>)attributes, this.errorReporter);
        msgGroup.addChild(msg);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlockForMsg();
        msg.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: {
                tagBegin = this.jj_consume_token(46);
                try {
                    attributes = this.Attributes();
                    tagEnd = this.jj_consume_token(74);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
                }
                loc = this.createSrcLoc(tagBegin, tagEnd);
                MsgNode fallback = new MsgNode(this.nodeIdGen.genId(), loc, "fallbackmsg", (List<CommandTagAttribute>)attributes, this.errorReporter);
                msgGroup.addChild(fallback);
                templateBlock = this.TemplateBlockForMsg();
                fallback.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.jj_consume_token(47);
        if ("" != null) {
            return msgGroup;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException {
        ArrayList<SoyNode.StandaloneNode> templateBlock;
        int pluralOrSelectIndex;
        block25: {
            pluralOrSelectIndex = -1;
            boolean firstNodeIsWhitespace = false;
            templateBlock = new ArrayList<SoyNode.StandaloneNode>();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 94: {
                    RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen);
                    block17: while (true) {
                        Token tok = this.jj_consume_token(94);
                        builder.addBasic(tok);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 94: {
                                continue block17;
                            }
                        }
                        break;
                    }
                    this.jj_la1[26] = this.jj_gen;
                    RawTextNode rawText = builder.build();
                    if (rawText == null) break;
                    firstNodeIsWhitespace = true;
                    templateBlock.add(rawText);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                }
            }
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 54: 
                    case 56: 
                    case 58: 
                    case 60: 
                    case 62: 
                    case 66: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 94: 
                    case 95: {
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        break block25;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 58: 
                    case 60: {
                        AbstractParentCommandNode msgPluralOrSelectNode;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 58: {
                                msgPluralOrSelectNode = this.MsgPlural();
                                break;
                            }
                            case 60: {
                                msgPluralOrSelectNode = this.MsgSelect();
                                break;
                            }
                            default: {
                                this.jj_la1[29] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.SkipWhitespace();
                        if (firstNodeIsWhitespace) {
                            templateBlock.remove(0);
                            firstNodeIsWhitespace = false;
                        }
                        if (pluralOrSelectIndex == -1) {
                            pluralOrSelectIndex = templateBlock.size();
                        }
                        templateBlock.add((SoyNode.StandaloneNode)((Object)msgPluralOrSelectNode));
                        continue block18;
                    }
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 54: 
                    case 56: 
                    case 62: 
                    case 66: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 94: 
                    case 95: {
                        SoyNode.StandaloneNode stmt = this.TemplateBlockItem();
                        if (stmt == null) continue block18;
                        templateBlock.add(stmt);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[30] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (pluralOrSelectIndex != -1) {
            SoyNode.StandaloneNode pluralOrSelect = (SoyNode.StandaloneNode)templateBlock.get(pluralOrSelectIndex);
            for (int i = 0; i < templateBlock.size(); ++i) {
                if (i == pluralOrSelectIndex) continue;
                this.errorReporter.report(((SoyNode.StandaloneNode)templateBlock.get(i)).getSourceLocation(), i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER, pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
            }
            if ("" != null) {
                return ImmutableList.of((Object)pluralOrSelect);
            }
        }
        if ("" != null) {
            return templateBlock;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgPluralNode MsgPlural() throws ParseException {
        Token tagEnd;
        ExprNode pluralExpr;
        CommandTagAttribute offsetAttr = null;
        Token tagBegin = this.jj_consume_token(58);
        try {
            pluralExpr = this.Expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 133: {
                    offsetAttr = this.ExprAttribute();
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                }
            }
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            pluralExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        int offset = 0;
        if (offsetAttr != null) {
            if (pluralExpr.getSourceLocation().isJustBefore(offsetAttr.getName().location())) {
                this.errorReporter.report(offsetAttr.getName().location(), PARSER_ERROR, offsetAttr.getName().identifier(), "whitespace");
            }
            if (!offsetAttr.getName().identifier().equals("offset")) {
                this.errorReporter.report(offsetAttr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE, offsetAttr.getName().identifier(), "plural", "offset");
                offsetAttr = null;
            }
        }
        if (offsetAttr != null && (offset = offsetAttr.valueAsInteger(this.errorReporter, 0)) <= 0) {
            this.errorReporter.report(offsetAttr.getValueLocation(), PLURAL_OFFSET_OUT_OF_BOUNDS, new Object[0]);
            offset = 0;
        }
        MsgPluralNode pluralNode = new MsgPluralNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), pluralExpr, offset);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                int value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block10;
                    }
                }
                tagBegin = this.jj_consume_token(64);
                ExprNode caseExpr = this.Expr();
                tagEnd = this.jj_consume_token(74);
                if (!(caseExpr instanceof IntegerNode)) {
                    this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_MALFORMED, new Object[0]);
                    value = 0;
                } else {
                    value = (int)((IntegerNode)caseExpr).getValue();
                    if (value < 0) {
                        this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_OUT_OF_BOUNDS, value);
                        value = 0;
                    }
                }
                MsgPluralCaseNode caseNode = new MsgPluralCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), value);
                pluralNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                    this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
                }
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(65);
            MsgPluralDefaultNode defaultNode = new MsgPluralDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            pluralNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
            }
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(59);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 59);
        }
        if ("" != null) {
            return pluralNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final MsgSelectNode MsgSelect() throws ParseException {
        Token tagEnd;
        ExprNode selectExpr;
        Token tagBegin = this.jj_consume_token(60);
        try {
            selectExpr = this.Expr();
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            selectExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        MsgSelectNode selectNode = new MsgSelectNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), selectExpr);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block7: while (true) {
                String value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 64: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block7;
                    }
                }
                tagBegin = this.jj_consume_token(64);
                ExprNode caseExpr = this.Expr();
                tagEnd = this.jj_consume_token(74);
                if (!(caseExpr instanceof StringNode)) {
                    this.errorReporter.report(caseExpr.getSourceLocation(), SELECT_CASE_INVALID_VALUE, new Object[0]);
                    value = "";
                } else {
                    value = ((StringNode)caseExpr).getValue();
                }
                MsgSelectCaseNode caseNode = new MsgSelectCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), value);
                selectNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(65);
            MsgSelectDefaultNode defaultNode = new MsgSelectDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            selectNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(61);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 61);
        }
        if ("" != null) {
            return selectNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final PrintNode PrintStmt() throws ParseException {
        Token tagEnd;
        boolean isImplicit;
        Token tagBegin;
        ExprNode expr = null;
        Object directives = ImmutableList.of();
        CommandTagAttribute phname = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 72: {
                tagBegin = this.jj_consume_token(72);
                isImplicit = false;
                break;
            }
            case 73: {
                tagBegin = this.jj_consume_token(73);
                isImplicit = true;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            expr = this.Expr();
            directives = this.PrintDirectives();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 133: {
                    phname = this.ExprAttribute();
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                }
            }
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            if (expr == null) {
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        PrintNode node = new PrintNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), isImplicit, expr, phname, this.errorReporter);
        node.addChildren((List)directives);
        if ("" != null) {
            return node;
        }
        throw new Error("Missing return statement in function");
    }

    private final List<PrintDirectiveNode> PrintDirectives() throws ParseException {
        Object directives = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block3;
                }
            }
            PrintDirectiveNode node = this.PrintDirective();
            if (directives.isEmpty()) {
                directives = new ArrayList();
            }
            directives.add(node);
        }
        if ("" != null) {
            return directives;
        }
        throw new Error("Missing return statement in function");
    }

    private final PrintDirectiveNode PrintDirective() throws ParseException {
        ImmutableList<ExprNode> args = ImmutableList.of();
        Token directive = this.jj_consume_token(81);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                args = this.ExprList();
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        SourceLocation loc = this.createSrcLoc(directive, new Token[0]);
        if (!args.isEmpty()) {
            loc.extend(((ExprNode)args.get(args.size() - 1)).getSourceLocation());
        }
        if ("" != null) {
            return new PrintDirectiveNode(this.nodeIdGen.genId(), loc, directive.image, args);
        }
        throw new Error("Missing return statement in function");
    }

    private final XidNode XidStmt() throws ParseException {
        String xid;
        Token tagEnd;
        Token tok = null;
        Identifier ident = null;
        Token tagBegin = this.jj_consume_token(48);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 76: {
                    ident = this.DottedIdent();
                    break;
                }
                case 80: {
                    tok = this.jj_consume_token(80);
                    if (tok.image.charAt(0) != '-' && tok.image.charAt(0) != '%') break;
                    throw this.generateParseException();
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            tok = new Token(76, "error");
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        String string = xid = ident != null ? ident.identifier() : tok.image;
        if ("" != null) {
            return new XidNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), xid);
        }
        throw new Error("Missing return statement in function");
    }

    private final CssNode CssStmt() throws ParseException {
        Token tagEnd;
        Token selector;
        Token tagBegin = this.jj_consume_token(49);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 76: {
                    selector = this.jj_consume_token(76);
                    break;
                }
                case 80: {
                    selector = this.jj_consume_token(80);
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            selector = new Token(76, "error");
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        if ("" != null) {
            return new CssNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), null, selector.image);
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final LetNode LetStmt() throws ParseException {
        Token tagEnd;
        VarRefNode letVar = null;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(54);
        try {
            letVar = this.VarRef();
        }
        catch (ParseException e) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 75, 74);
            return new LetValueNode(-1, this.createSrcLoc(tagBegin, tagEnd), "error", this.errorExpr(tagBegin, new Token[0]));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                try {
                    this.jj_consume_token(109);
                    valueExpr = this.Expr();
                    tagEnd = this.jj_consume_token(75);
                    return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), valueExpr);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 75, 74);
                    if (valueExpr != null) return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), valueExpr);
                    valueExpr = this.errorExpr(tagEnd, new Token[0]);
                }
                return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), valueExpr);
            }
            case 74: 
            case 133: {
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 133: {
                            attr = this.ExprAttribute();
                            break;
                        }
                        default: {
                            this.jj_la1[40] = this.jj_gen;
                        }
                    }
                    tagEnd = this.jj_consume_token(74);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74, 75);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                this.jj_consume_token(55);
                LetContentNode node = new LetContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), letVar.getName(), attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[41] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final IfNode IfStmt() throws ParseException {
        Token tagEnd;
        ExprNode ifExpr;
        Token tagBegin = this.jj_consume_token(50);
        try {
            ifExpr = this.Expr();
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            ifExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        IfNode ifNode = new IfNode(this.nodeIdGen.genId(), location);
        IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "if", ifExpr);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ifCondNode.addChildren(templateBlock);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 51: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block10;
                }
            }
            tagBegin = this.jj_consume_token(51);
            try {
                ifExpr = this.Expr();
                tagEnd = this.jj_consume_token(74);
            }
            catch (ParseException e) {
                ifExpr = this.errorExpr(tagBegin, new Token[0]);
                tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
            }
            location = this.createSrcLoc(tagBegin, tagEnd);
            ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "elseif", ifExpr);
            ifNode.addChild(ifCondNode);
            templateBlock = this.TemplateBlock();
            ifCondNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 52: {
                Token elseTag = this.jj_consume_token(52);
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId(), this.createSrcLoc(elseTag, new Token[0]));
                ifNode.addChild(ifElseNode);
                templateBlock = this.TemplateBlock();
                ifElseNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.jj_consume_token(53);
        if ("" != null) {
            return ifNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final SwitchNode SwitchStmt() throws ParseException {
        Token tagEnd;
        ExprNode switchExpr;
        Token tagBegin = this.jj_consume_token(62);
        try {
            switchExpr = this.Expr();
            tagEnd = this.jj_consume_token(74);
        }
        catch (ParseException e) {
            switchExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
        }
        SwitchNode switchNode = new SwitchNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), switchExpr);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                tagBegin = this.jj_consume_token(64);
                ImmutableList<ExprNode> caseExprs = this.ExprList();
                tagEnd = this.jj_consume_token(74);
                SwitchCaseNode caseNode = new SwitchCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), caseExprs);
                switchNode.addChild(caseNode);
                templateBlock = this.TemplateBlock();
                caseNode.addChildren(templateBlock);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 64: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[44] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 65: {
                    Token defaultTag = this.jj_consume_token(65);
                    SwitchDefaultNode defaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
                    switchNode.addChild(defaultNode);
                    templateBlock = this.TemplateBlock();
                    defaultNode.addChildren(templateBlock);
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                }
            }
            this.jj_consume_token(63);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 63);
        }
        if ("" != null) {
            return switchNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final ForeachNode ForeachStmt() throws ParseException {
        Token tagEnd;
        Token tagBegin;
        ExprNode expr;
        VarRefNode var;
        block7: {
            var = null;
            expr = null;
            tagBegin = this.jj_consume_token(66);
            try {
                var = this.VarRef();
                Token in = this.Keyword("in");
                expr = this.Expr();
                tagEnd = this.jj_consume_token(74);
            }
            catch (ParseException e) {
                tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
                if (var == null) {
                    var = this.errorExpr(tagBegin, new Token[0]);
                }
                if (expr != null) break block7;
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
        }
        ForeachNode foreachNode = new ForeachNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), expr);
        ForeachNonemptyNode nonEmpty = new ForeachNonemptyNode(this.nodeIdGen.genId(), var.getSourceLocation(), var.getName());
        foreachNode.addChild(nonEmpty);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        nonEmpty.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: {
                Token ifemptyTag = this.jj_consume_token(67);
                templateBlock = this.TemplateBlock();
                ForeachIfemptyNode ifempty = new ForeachIfemptyNode(this.nodeIdGen.genId(), this.createSrcLoc(ifemptyTag, new Token[0]));
                ifempty.addChildren(templateBlock);
                foreachNode.addChild(ifempty);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        this.jj_consume_token(68);
        if ("" != null) {
            return foreachNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final ForNode ForStmt() throws ParseException {
        Token tagEnd;
        Token tagBegin;
        Object rangeArgs;
        VarRefNode forVar;
        block6: {
            forVar = null;
            rangeArgs = ImmutableList.of();
            tagBegin = this.jj_consume_token(56);
            try {
                forVar = this.VarRef();
                Token in = this.Keyword("in");
                ExprNode rangeExpr = this.Expr();
                if (!(rangeExpr instanceof FunctionNode) || !((FunctionNode)rangeExpr).getFunctionName().equals("range")) {
                    this.errorReporter.report(rangeExpr.getSourceLocation(), PARSER_ERROR, rangeExpr.toSourceString(), "range()");
                } else {
                    rangeArgs = ((FunctionNode)rangeExpr).getChildren();
                    if (rangeArgs.size() == 0 || rangeArgs.size() > 3) {
                        this.errorReporter.report(rangeExpr.getSourceLocation(), INVALID_RANGE_SPECIFICATION, new Object[0]);
                    }
                }
                tagEnd = this.jj_consume_token(74);
            }
            catch (ParseException e) {
                tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74);
                if (forVar != null) break block6;
                forVar = this.errorExpr(tagBegin, new Token[0]);
            }
        }
        ForNode forNode = new ForNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), this.errorReporter, forVar, (List<ExprNode>)rangeArgs);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        forNode.addChildren(templateBlock);
        this.jj_consume_token(57);
        if ("" != null) {
            return forNode;
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final CallNode CallStmt() throws ParseException {
        calleeName = null;
        attributes /* !! */  = ImmutableList.of();
        params /* !! */  = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 39: {
                tagBegin = this.jj_consume_token(39);
                try {
                    calleeName = this.TemplateName();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 75: {
                            tagEnd = this.jj_consume_token(75);
                            break;
                        }
                        case 74: {
                            tagEnd = this.jj_consume_token(74);
                            params /* !! */  = this.CallParams();
                            this.jj_consume_token(41);
                            break;
                        }
                        default: {
                            this.jj_la1[47] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{75, 41});
                    if (calleeName != null) ** GOTO lbl30
                    calleeName = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
                }
lbl30:
                // 3 sources

                fullName = SoyParseUtils.calculateFullCalleeName(calleeName, this.headerInfo, this.errorReporter);
                node = new CallBasicNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[]{tagEnd}), calleeName.identifier(), fullName, (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                node.addChildren((List)params /* !! */ );
                if ("" == null) break;
                return node;
            }
            case 40: {
                tagBegin = this.jj_consume_token(40);
                try {
                    calleeName = this.TemplateName();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 75: {
                            tagEnd = this.jj_consume_token(75);
                            break;
                        }
                        case 74: {
                            tagEnd = this.jj_consume_token(74);
                            params /* !! */  = this.CallParams();
                            this.jj_consume_token(42);
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{75, 42});
                    if (calleeName != null) ** GOTO lbl60
                    calleeName = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
                }
lbl60:
                // 3 sources

                if (calleeName.type() == Identifier.Type.DOT_IDENT) {
                    this.errorReporter.report(calleeName.location(), SoyFileParser.INVALID_CALLEE_NAME, new Object[]{calleeName.identifier()});
                }
                node = new CallDelegateNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[]{tagEnd}), calleeName.identifier(), (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                node.addChildren((List)params /* !! */ );
                if ("" == null) break;
                return node;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final List<CallParamNode> CallParams() throws ParseException {
        Object params = ImmutableList.of();
        this.SkipWhitespace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 43: {
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    break block3;
                }
            }
            CallParamNode paramNode = this.CallParam();
            if (params.isEmpty()) {
                params = new ArrayList();
            }
            params.add(paramNode);
            this.SkipWhitespace();
        }
        if ("" != null) {
            return params;
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final CallParamNode CallParam() throws ParseException {
        Token tagEnd;
        Identifier key;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(43);
        try {
            key = this.Identifier();
        }
        catch (ParseException e) {
            key = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 75, 74);
            return new CallParamValueNode(-1, this.createSrcLoc(tagBegin, tagEnd), key, this.errorExpr(tagBegin, new Token[0]));
        }
        if (key.type() != Identifier.Type.SINGLE_IDENT) {
            this.errorReporter.report(key.location(), INVALID_PARAM_NAME, key.identifier());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                try {
                    this.jj_consume_token(109);
                    valueExpr = this.Expr();
                    tagEnd = this.jj_consume_token(75);
                    return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 75, 74);
                    if (valueExpr != null) return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
                    valueExpr = this.errorExpr(tagEnd, new Token[0]);
                }
                return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
            }
            case 74: 
            case 133: {
                try {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 133: {
                            attr = this.ExprAttribute();
                            break;
                        }
                        default: {
                            this.jj_la1[51] = this.jj_gen;
                        }
                    }
                    tagEnd = this.jj_consume_token(74);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 74, 75);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                this.jj_consume_token(44);
                CallParamContentNode node = new CallParamContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[52] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final LogNode LogStmt() throws ParseException {
        Token open = this.jj_consume_token(69);
        LogNode logNode = new LogNode(this.nodeIdGen.genId(), this.createSrcLoc(open, new Token[0]));
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        logNode.addChildren(templateBlock);
        this.jj_consume_token(70);
        if ("" != null) {
            return logNode;
        }
        throw new Error("Missing return statement in function");
    }

    private final DebuggerNode DebuggerStmt() throws ParseException {
        Token token = this.jj_consume_token(71);
        if ("" != null) {
            return new DebuggerNode(this.nodeIdGen.genId(), this.createSrcLoc(token, new Token[0]));
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode ExprInput() throws ParseException {
        ExprNode expr = this.Expr();
        this.jj_consume_token(0);
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ImmutableList<ExprNode> ExprList() throws ParseException {
        ImmutableList.Builder exprList = ImmutableList.builder();
        ExprNode expr = this.Expr();
        exprList.add((Object)expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(130);
            expr = this.Expr();
            exprList.add((Object)expr);
        }
        if ("" != null) {
            return exprList.build();
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode expr = this.PrecExpr1();
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode expr = this.PrecExpr2();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 108: 
            case 110: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 110: {
                        this.jj_consume_token(110);
                        ExprNode expr1 = this.PrecExpr1();
                        expr = Operator.NULL_COALESCING.createNode(expr, expr1);
                        break block0;
                    }
                    case 108: {
                        this.jj_consume_token(108);
                        ExprNode expr1 = this.PrecExpr1();
                        this.jj_consume_token(109);
                        ExprNode expr2 = this.PrecExpr1();
                        expr = Operator.CONDITIONAL.createNode(expr, expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr2() throws ParseException {
        ExprNode expr = this.PrecExpr3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(111);
            ExprNode rightHand = this.PrecExpr3();
            expr = Operator.createOperatorNode(op.image, 2, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr3() throws ParseException {
        ExprNode expr = this.PrecExpr4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 112: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(112);
            ExprNode rightHand = this.PrecExpr4();
            expr = Operator.createOperatorNode(op.image, 3, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr4() throws ParseException {
        ExprNode expr = this.PrecExpr5();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 113: 
                case 114: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 113: {
                    op = this.jj_consume_token(113);
                    break;
                }
                case 114: {
                    op = this.jj_consume_token(114);
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr5();
            expr = Operator.createOperatorNode(op.image, 4, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr5() throws ParseException {
        ExprNode expr = this.PrecExpr6();
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 115: 
                case 116: 
                case 117: 
                case 118: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 115: {
                    op = this.jj_consume_token(115);
                    break;
                }
                case 116: {
                    op = this.jj_consume_token(116);
                    break;
                }
                case 117: {
                    op = this.jj_consume_token(117);
                    break;
                }
                case 118: {
                    op = this.jj_consume_token(118);
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr6();
            expr = Operator.createOperatorNode(op.image, 5, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr6() throws ParseException {
        ExprNode expr = this.PrecExpr7();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 119: 
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 119: {
                    op = this.jj_consume_token(119);
                    break;
                }
                case 120: {
                    op = this.jj_consume_token(120);
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr7();
            expr = Operator.createOperatorNode(op.image, 6, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr7() throws ParseException {
        ExprNode expr = this.PrecExpr8();
        block8: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 121: 
                case 122: 
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 121: {
                    op = this.jj_consume_token(121);
                    break;
                }
                case 122: {
                    op = this.jj_consume_token(122);
                    break;
                }
                case 123: {
                    op = this.jj_consume_token(123);
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr8();
            expr = Operator.createOperatorNode(op.image, 7, expr, rightHand);
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr8() throws ParseException {
        ExprNode expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 127: 
            case 131: 
            case 133: 
            case 134: 
            case 135: {
                expr = this.PrecExpr9();
                break;
            }
            case 120: 
            case 124: {
                Token unaryOp;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 124: {
                        unaryOp = this.jj_consume_token(124);
                        break;
                    }
                    case 120: {
                        unaryOp = this.jj_consume_token(120);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.PrecExpr8();
                if (unaryOp.kind == 120 && expr instanceof IntegerNode) {
                    SourceLocation newLoc = this.createSrcLoc(unaryOp, new Token[0]).extend(expr.getSourceLocation());
                    long value = -1L * ((IntegerNode)expr).getValue();
                    expr = new IntegerNode(value, newLoc);
                    break;
                }
                if (unaryOp.kind == 120 && expr instanceof FloatNode) {
                    SourceLocation newLoc = this.createSrcLoc(unaryOp, new Token[0]).extend(expr.getSourceLocation());
                    double value = -1.0 * ((FloatNode)expr).getValue();
                    expr = new FloatNode(value, newLoc);
                    break;
                }
                expr = Operator.createOperatorNode(unaryOp.image, 8, expr);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode PrecExpr9() throws ParseException {
        ExprNode expr;
        block17: {
            expr = this.Primary();
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 125: 
                    case 126: 
                    case 127: 
                    case 129: {
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 125: 
                    case 126: {
                        Token op;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 125: {
                                op = this.jj_consume_token(125);
                                break;
                            }
                            case 126: {
                                op = this.jj_consume_token(126);
                                break;
                            }
                            default: {
                                this.jj_la1[69] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token ident = this.jj_consume_token(133);
                        expr = new FieldAccessNode(expr, ident.image, this.createSrcLoc(op, ident), op.kind == 126);
                        continue block15;
                    }
                    case 127: 
                    case 129: {
                        Token open;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 127: {
                                open = this.jj_consume_token(127);
                                break;
                            }
                            case 129: {
                                open = this.jj_consume_token(129);
                                break;
                            }
                            default: {
                                this.jj_la1[70] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        ExprNode keyExpr = this.Expr();
                        Token close = this.jj_consume_token(128);
                        expr = new ItemAccessNode(expr, keyExpr, this.createSrcLoc(open, close), open.kind == 129);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[71] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return expr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode primary;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                this.jj_consume_token(131);
                primary = this.Expr();
                this.jj_consume_token(132);
                break;
            }
            case 134: {
                primary = this.IjRef();
                break;
            }
            case 135: {
                primary = this.VarRef();
                break;
            }
            case 133: {
                primary = this.GlobalOrFunction();
                break;
            }
            case 127: {
                primary = this.CollectionLiteral();
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                primary = this.Primitive();
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primary;
        }
        throw new Error("Missing return statement in function");
    }

    private final VarRefNode IjRef() throws ParseException {
        block3: {
            Token ij = this.jj_consume_token(134);
            try {
                this.jj_consume_token(125);
                Token ident = this.jj_consume_token(133);
                if ("" != null) {
                    return new VarRefNode(ident.image, this.createSrcLoc(ij, ident), true, null);
                }
            }
            catch (ParseException e) {
                SourceLocation loc = this.createSrcLoc(ij, new Token[0]);
                this.errorReporter.report(loc, INVALID_VAR_NAME_IJ, new Object[0]);
                if ("" == null) break block3;
                return new VarRefNode("ij", loc, false, null);
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final VarRefNode VarRef() throws ParseException {
        Token ident = this.jj_consume_token(135);
        if ("" != null) {
            return new VarRefNode(ident.image.substring(1), this.createSrcLoc(ident, new Token[0]), false, null);
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode GlobalOrFunction() throws ParseException {
        SoyType type;
        Token openParen = null;
        Token closeParen = null;
        ArrayList<ExprNode> params = new ArrayList<ExprNode>();
        Identifier ident = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 131: {
                openParen = this.jj_consume_token(131);
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 120: 
                    case 124: 
                    case 127: 
                    case 131: 
                    case 133: 
                    case 134: 
                    case 135: {
                        ExprNode first = this.Expr();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 109: {
                                this.jj_consume_token(109);
                                ExprNode expr = this.Expr();
                                if (!(first instanceof GlobalNode) || !BaseUtils.isIdentifier(((GlobalNode)first).getName())) {
                                    this.errorReporter.report(first.getSourceLocation(), INVALID_PARAM_NAME, first.toSourceString());
                                    first = GlobalNode.error(first.getSourceLocation());
                                }
                                LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
                                paramNames.add(((GlobalNode)first).getName());
                                params.add(expr);
                                block16: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 130: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[73] = this.jj_gen;
                                            break block16;
                                        }
                                    }
                                    this.jj_consume_token(130);
                                    Token paramName = this.jj_consume_token(133);
                                    if (!paramNames.add(paramName.image)) {
                                        this.errorReporter.report(this.createSrcLoc(paramName, new Token[0]), DUPLICATE_PARAM_NAME, paramName.image);
                                    }
                                    this.jj_consume_token(109);
                                    expr = this.Expr();
                                    params.add(expr);
                                }
                                closeParen = this.jj_consume_token(132);
                                ProtoInitNode pNode = new ProtoInitNode(ident.identifier(), paramNames, ident.location().extend(this.createSrcLoc(closeParen, new Token[0])));
                                pNode.addChildren((List<? extends ExprNode>)params);
                                if ("" == null) break block3;
                                return pNode;
                            }
                            case 130: 
                            case 132: {
                                params.add(first);
                                block17: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 130: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[74] = this.jj_gen;
                                            break block17;
                                        }
                                    }
                                    this.jj_consume_token(130);
                                    ExprNode expr = this.Expr();
                                    params.add(expr);
                                }
                                closeParen = this.jj_consume_token(132);
                                FunctionNode fnNode = new FunctionNode(ident.identifier(), ident.location().extend(this.createSrcLoc(closeParen, new Token[0])));
                                fnNode.addChildren((List<? extends ExprNode>)params);
                                if ("" == null) break block3;
                                return fnNode;
                            }
                            default: {
                                this.jj_la1[75] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                    }
                }
                closeParen = this.jj_consume_token(132);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        if (openParen == null && "" != null) {
            return new GlobalNode(ident.identifier(), ident.location());
        }
        String name = ident.identifier();
        SourceLocation loc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
        SoyType soyType = type = this.typeRegistry == null ? null : this.typeRegistry.getType(ident.identifier());
        if (type != null && type.getKind() == SoyType.Kind.PROTO) {
            if ("" != null) {
                return new ProtoInitNode(name, (Iterable<String>)ImmutableList.of(), loc);
            }
        } else if ("" != null) {
            return new FunctionNode(name, loc);
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode CollectionLiteral() throws ParseException {
        Object items = ImmutableList.of();
        Token begin = this.jj_consume_token(127);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                Token end = this.jj_consume_token(128);
                if ("" == null) break;
                return new MapLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
            case 128: {
                Token end = this.jj_consume_token(128);
                if ("" == null) break;
                return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 120: 
            case 124: 
            case 127: 
            case 131: 
            case 133: 
            case 134: 
            case 135: {
                ExprNode itemExpr = this.MapKeyOrExpr();
                items = new ArrayList();
                items.add(itemExpr);
                if (this.jj_2_1(1)) {
                    while (this.getToken((int)1).kind == 130 && this.getToken((int)2).kind != 128) {
                        this.jj_consume_token(130);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            this.jj_consume_token(130);
                            break;
                        }
                        default: {
                            this.jj_la1[78] = this.jj_gen;
                        }
                    }
                    Token end = this.jj_consume_token(128);
                    if ("" == null) break;
                    return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 109: {
                        this.jj_consume_token(109);
                        itemExpr = this.Expr();
                        items.add(itemExpr);
                        while (this.getToken((int)1).kind == 130 && this.getToken((int)2).kind != 128) {
                            this.jj_consume_token(130);
                            itemExpr = this.MapKeyOrExpr();
                            items.add(itemExpr);
                            this.jj_consume_token(109);
                            itemExpr = this.Expr();
                            items.add(itemExpr);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 130: {
                                this.jj_consume_token(130);
                                break;
                            }
                            default: {
                                this.jj_la1[79] = this.jj_gen;
                            }
                        }
                        Token end = this.jj_consume_token(128);
                        if ("" == null) break block0;
                        return new MapLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
                    }
                    default: {
                        this.jj_la1[80] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode MapKeyOrExpr() throws ParseException {
        ExprNode itemExpr;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            Token ident = this.jj_consume_token(133);
            itemExpr = new GlobalNode(ident.image, this.createSrcLoc(ident, new Token[0]));
            this.errorReporter.report(this.createSrcLoc(ident, new Token[0]), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 120: 
                case 124: 
                case 127: 
                case 131: 
                case 133: 
                case 134: 
                case 135: {
                    itemExpr = this.Expr();
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return itemExpr;
        }
        throw new Error("Missing return statement in function");
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode primitive;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 96: {
                Token tok = this.jj_consume_token(96);
                primitive = new NullNode(this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 97: {
                Token tok = this.jj_consume_token(97);
                primitive = new BooleanNode(true, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 98: {
                Token tok = this.jj_consume_token(98);
                primitive = new BooleanNode(false, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 99: {
                Token tok = this.jj_consume_token(99);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image, (int)10);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 100: {
                Token tok = this.jj_consume_token(100);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image.substring(2), (int)16);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 101: {
                Token tok = this.jj_consume_token(101);
                primitive = new FloatNode(Double.parseDouble(tok.image), this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 102: {
                Token quote = this.jj_consume_token(102);
                Token tok = this.jj_consume_token(103);
                SourceLocation loc = this.createSrcLoc(quote, tok);
                String unescaped = SoyParseUtils.unescapeString(tok.image, this.errorReporter, loc);
                primitive = new StringNode(unescaped, loc);
                break;
            }
            default: {
                this.jj_la1[83] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return primitive;
        }
        throw new Error("Missing return statement in function");
    }

    private final Identifier Identifier() throws ParseException {
        Token next = null;
        StringBuilder sb = null;
        Token first = this.jj_consume_token(133);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(125);
            next = this.jj_consume_token(133);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(first.image);
            }
            sb.append('.').append(next.image);
        }
        if ("" != null) {
            return sb == null ? Identifier.create(first.image, this.createSrcLoc(first, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(first, next));
        }
        throw new Error("Missing return statement in function");
    }

    private final Token Keyword(String keyword) throws ParseException {
        Token ident = this.jj_consume_token(133);
        if (!ident.image.equals(keyword)) {
            throw this.generateParseException();
        }
        if ("" != null) {
            return ident;
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode TypeExpr() throws ParseException {
        TypeNode first = null;
        TypeNode next = null;
        ArrayList<TypeNode> members = null;
        first = this.PrimaryType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(90);
            next = this.PrimaryType();
            if (members == null) {
                members = new ArrayList<TypeNode>();
                members.add(first);
            }
            members.add(next);
        }
        if ("" != null) {
            return members == null ? first : UnionTypeNode.create((Iterable<TypeNode>)members);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode PrimaryType() throws ParseException {
        TypeNode type;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 82: {
                type = this.NamedType();
                break;
            }
            case 91: {
                type = this.UnknownType();
                break;
            }
            case 86: {
                type = this.RecordType();
                break;
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return type;
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode RecordType() throws ParseException {
        Object properties = ImmutableList.of();
        Token open = this.jj_consume_token(86);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 82: {
                RecordTypeNode.Property prop = this.RecordField();
                properties = new ArrayList();
                properties.add(prop);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 88: {
                            break;
                        }
                        default: {
                            this.jj_la1[87] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(88);
                    prop = this.RecordField();
                    properties.add(prop);
                }
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(87);
        if ("" != null) {
            return RecordTypeNode.create(this.createSrcLoc(open, close), (Iterable<RecordTypeNode.Property>)properties);
        }
        throw new Error("Missing return statement in function");
    }

    private final RecordTypeNode.Property RecordField() throws ParseException {
        Token fieldName = this.jj_consume_token(82);
        this.jj_consume_token(89);
        TypeNode fieldType = this.TypeExpr();
        if ("" != null) {
            return RecordTypeNode.Property.create(this.createSrcLoc(fieldName, new Token[0]), fieldName.image, fieldType);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode NamedType() throws ParseException {
        Token next = null;
        Object genericArgs = ImmutableList.of();
        StringBuilder sb = null;
        Token first = this.jj_consume_token(82);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 83: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(83);
            next = this.jj_consume_token(82);
            if (sb == null) {
                sb = new StringBuilder(first.image);
            }
            sb.append('.');
            sb.append(next.image);
        }
        String ident = sb == null ? first.image : sb.toString();
        SourceLocation fullLocation = next == null ? this.createSrcLoc(first, new Token[0]) : this.createSrcLoc(first, next);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 84: {
                Token open = this.jj_consume_token(84);
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 82: 
                    case 86: 
                    case 91: {
                        TypeNode arg = this.TypeExpr();
                        genericArgs = new ArrayList();
                        genericArgs.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 88: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[90] = this.jj_gen;
                                    break block6;
                                }
                            }
                            this.jj_consume_token(88);
                            arg = this.TypeExpr();
                            genericArgs.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[91] = this.jj_gen;
                    }
                }
                Token close = this.jj_consume_token(85);
                if ("" == null) break;
                return GenericTypeNode.create(fullLocation.extend(this.createSrcLoc(close, new Token[0])), ident, (Iterable<? extends TypeNode>)genericArgs);
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
            }
        }
        if ("" != null) {
            return NamedTypeNode.create(fullLocation, ident);
        }
        throw new Error("Missing return statement in function");
    }

    private final TypeNode UnknownType() throws ParseException {
        Token tok = this.jj_consume_token(91);
        if ("" != null) {
            return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), "?");
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(130);
    }

    private boolean jj_3_1() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_35());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(130)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(128);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4096, 1024, 0xC00000, 0, 114688, 114688, 114688, 0xC00000, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x3C000000, 0, 0x3C000000, 0x3C000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 127, 127, 0, 0, 0, 0, 1095180799, 1095180799, 1095180672, 0x400000, 205184, 0x41040000, 16384, 0, 0, 1430725119, 0x14000000, 1430725119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0x100000, 0, 0, 0, 0, 0, 384, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 4096, 0, 4096, 0, 36864, 32768, 0x40000000, -1073741824, 0, -1073741824, -1073741824, 0x40000000, 0x40000000, 0x40000000, 0, -1073740892, -1073740892, 932, 160, 768, 4, 0, 0x40000000, 0x40000000, -1073740892, 0, -1073740892, 0, 1, 1, 768, 0, 131072, 0, 69632, 69632, 0, 1024, 0, 0, 1, 2, 8, 3072, 3072, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x8440000, 0x1000000, 262144, 524288, 0x1000000, 0x8440000, 0x100000};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 20480, 20480, 32768, 65536, 393216, 393216, 0x780000, 0x780000, 0x1800000, 0x1800000, 0xE000000, 0xE000000, 0x11000000, -1862270849, -536870912, 0x60000000, Integer.MIN_VALUE, -536870912, -2147483521, 0, 0, 8192, -1862270849, 0, 0, 0, 8192, -1862262657, -1862270849, 127, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 32, 0, 0, 0, 0, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 2, 0, 2, 2, 232, 4, 4, 20, 232, 8, 4, 4, 0, 233, 232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 93; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[158];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 93; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 158; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SoyFileParser.jj_la1_init_0();
        SoyFileParser.jj_la1_init_1();
        SoyFileParser.jj_la1_init_2();
        SoyFileParser.jj_la1_init_3();
        SoyFileParser.jj_la1_init_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class AbortParsingError
    extends Error {
        AbortParsingError() {
        }
    }
}

