/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.RawTextNode;
import javax.annotation.Nullable;

final class RawTextBuilder {
    private final RawTextNode.SourceOffsets.Builder offsets = new RawTextNode.SourceOffsets.Builder();
    private final StringBuilder buffer = new StringBuilder();
    private final String fileName;
    private final IdGenerator nodeIdGen;
    private int basicStart = -1;
    private int basicStartOfWhitespace = -1;
    private int endLineAtStartOfWhitespace;
    private int endColumnAtStartOfWhitespace;
    private boolean basicHasNewline = false;
    private RawTextNode.SourceOffsets.Reason discontinuityReason = RawTextNode.SourceOffsets.Reason.NONE;

    RawTextBuilder(String fileName, IdGenerator nodeIdGen) {
        this.fileName = (String)Preconditions.checkNotNull((Object)fileName);
        this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
    }

    void addBasic(Token token) {
        if (this.basicStart == -1) {
            this.basicStart = this.buffer.length();
            this.basicStartOfWhitespace = -1;
            this.basicHasNewline = false;
        }
        switch (token.kind) {
            case 94: {
                if (token.image.equals("\r\n") || token.image.equals("\r") || token.image.equals("\n")) {
                    this.basicHasNewline = true;
                }
                if (this.basicStartOfWhitespace != -1) break;
                this.basicStartOfWhitespace = this.buffer.length();
                this.endLineAtStartOfWhitespace = this.offsets.endLine();
                this.endColumnAtStartOfWhitespace = this.offsets.endColumn();
                break;
            }
            case 95: {
                this.maybeCollapseWhitespace(token.image);
                break;
            }
            default: {
                throw new AssertionError((Object)(SoyFileParserConstants.tokenImage[token.kind] + " is not a basic text token"));
            }
        }
        this.append(token, token.image);
    }

    void addLiteral(Token literalContent) {
        Preconditions.checkArgument((literalContent.kind == 93 ? 1 : 0) != 0);
        this.maybeFinishBasic();
        if (!literalContent.image.isEmpty()) {
            this.append(literalContent, literalContent.image);
        }
        this.discontinuityReason = RawTextNode.SourceOffsets.Reason.LITERAL;
    }

    void addTextualCommand(Token token) {
        this.maybeFinishBasic();
        if (token.kind != 32) {
            this.append(token, RawTextBuilder.rawTextCmdToString(token));
        }
        this.discontinuityReason = RawTextNode.SourceOffsets.Reason.COMMAND;
    }

    private static String rawTextCmdToString(Token token) {
        switch (token.kind) {
            case 31: {
                return " ";
            }
            case 34: {
                return "\r";
            }
            case 33: {
                return "\n";
            }
            case 35: {
                return "\t";
            }
            case 36: {
                return "{";
            }
            case 37: {
                return "}";
            }
        }
        throw new IllegalArgumentException("unexpected token: " + SoyFileParserConstants.tokenImage[token.kind]);
    }

    RawTextNode build() {
        this.maybeFinishBasic();
        String text = this.buffer.toString();
        RawTextNode.SourceOffsets sourceOffsets = this.offsets.build(text.length(), this.discontinuityReason);
        return new RawTextNode(this.nodeIdGen.genId(), text, sourceOffsets.getSourceLocation(this.fileName), sourceOffsets);
    }

    private void append(Token token, String content) {
        if (content.isEmpty()) {
            throw new IllegalStateException(String.format("shouldn't append empty content: %s @ %s", SoyFileParserConstants.tokenImage[token.kind], Tokens.createSrcLoc(this.fileName, token, new Token[0])));
        }
        boolean addOffset = false;
        if (this.offsets.isEmpty()) {
            addOffset = true;
        } else if (this.discontinuityReason != RawTextNode.SourceOffsets.Reason.NONE) {
            addOffset = true;
        } else if (this.offsets.endLine() == token.beginLine) {
            if (this.offsets.endColumn() + 1 != token.beginColumn) {
                addOffset = true;
                this.discontinuityReason = RawTextNode.SourceOffsets.Reason.COMMENT;
            }
        } else if (this.offsets.endLine() + 1 == token.beginLine && token.beginColumn != 1) {
            addOffset = true;
            this.discontinuityReason = RawTextNode.SourceOffsets.Reason.COMMENT;
        }
        if (addOffset) {
            this.offsets.add(this.buffer.length(), token.beginLine, token.beginColumn, this.discontinuityReason);
            this.discontinuityReason = RawTextNode.SourceOffsets.Reason.NONE;
        }
        this.offsets.setEndLocation(token.endLine, token.endColumn);
        this.buffer.append(content);
    }

    private void maybeFinishBasic() {
        if (this.basicStart != -1) {
            this.maybeCollapseWhitespace(null);
            this.basicStart = -1;
        }
    }

    private void maybeCollapseWhitespace(@Nullable String next) {
        if (this.basicStartOfWhitespace != -1) {
            if (this.basicHasNewline) {
                if (this.basicStart == this.basicStartOfWhitespace || next == null) {
                    this.buffer.delete(this.basicStartOfWhitespace, this.buffer.length());
                    this.offsets.delete(this.basicStartOfWhitespace);
                    if (next == null && this.endColumnAtStartOfWhitespace != -1) {
                        this.offsets.setEndLocation(this.endLineAtStartOfWhitespace, this.endColumnAtStartOfWhitespace);
                    }
                } else if (next.charAt(0) == '<' || this.buffer.charAt(this.basicStartOfWhitespace - 1) == '>') {
                    this.buffer.delete(this.basicStartOfWhitespace, this.buffer.length());
                    this.offsets.delete(this.basicStartOfWhitespace);
                } else {
                    this.buffer.replace(this.basicStartOfWhitespace, this.buffer.length(), " ");
                    this.offsets.delete(this.basicStartOfWhitespace);
                }
                this.discontinuityReason = RawTextNode.SourceOffsets.Reason.WHITESPACE;
                this.basicHasNewline = false;
            }
            this.basicStartOfWhitespace = -1;
        }
    }
}

