/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.StringData;
import java.util.Objects;

public final class SharedRuntime {
    public static boolean equal(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof StringData) {
            return SharedRuntime.compareString(operand0.stringValue(), operand1);
        }
        if (operand1 instanceof StringData) {
            return SharedRuntime.compareString(operand1.stringValue(), operand0);
        }
        return Objects.equals(operand0, operand1);
    }

    public static SoyValue plus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() + operand1.longValue());
        }
        if (operand0 instanceof NumberData && operand1 instanceof NumberData) {
            return FloatData.forValue(operand0.numberValue() + operand1.numberValue());
        }
        return StringData.forValue(operand0.coerceToString() + operand1.coerceToString());
    }

    public static SoyValue minus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() - operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() - operand1.numberValue());
    }

    public static NumberData times(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() * operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() * operand1.numberValue());
    }

    public static double dividedBy(SoyValue operand0, SoyValue operand1) {
        return operand0.numberValue() / operand1.numberValue();
    }

    public static boolean lessThan(SoyValue left, SoyValue right) {
        if (left instanceof SoyString && right instanceof SoyString) {
            return left.stringValue().compareTo(right.stringValue()) < 0;
        }
        if (left instanceof IntegerData && right instanceof IntegerData) {
            return left.longValue() < right.longValue();
        }
        return left.numberValue() < right.numberValue();
    }

    public static boolean lessThanOrEqual(SoyValue left, SoyValue right) {
        if (left instanceof SoyString && right instanceof SoyString) {
            return left.stringValue().compareTo(right.stringValue()) <= 0;
        }
        if (left instanceof IntegerData && right instanceof IntegerData) {
            return left.longValue() <= right.longValue();
        }
        return left.numberValue() <= right.numberValue();
    }

    public static NumberData negative(SoyValue node) {
        if (node instanceof IntegerData) {
            return IntegerData.forValue(-node.longValue());
        }
        return FloatData.forValue(-node.floatValue());
    }

    public static boolean compareString(String string, SoyValue other) {
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return string.equals(other.toString());
        }
        if (other instanceof NumberData) {
            try {
                return Double.parseDouble(string) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    private SharedRuntime() {
    }
}

