/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.FindTransitiveDepTemplatesVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FindIjParamsVisitor {
    private final FindTransitiveDepTemplatesVisitor findTransitiveDepTemplatesVisitor;
    private final Map<FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo, IjParamsInfo> depsInfoToIjParamsInfoMap;
    private final Map<TemplateNode, Set<String>> templateToLocalIjParamsMap;

    public FindIjParamsVisitor(TemplateRegistry templateRegistry) {
        this.findTransitiveDepTemplatesVisitor = new FindTransitiveDepTemplatesVisitor(templateRegistry);
        this.depsInfoToIjParamsInfoMap = new HashMap<FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo, IjParamsInfo>();
        this.templateToLocalIjParamsMap = new HashMap<TemplateNode, Set<String>>();
    }

    public IjParamsInfo exec(TemplateNode rootTemplate) {
        FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo depsInfo = this.findTransitiveDepTemplatesVisitor.exec(rootTemplate);
        if (!this.depsInfoToIjParamsInfoMap.containsKey(depsInfo)) {
            ImmutableMultimap.Builder ijParamToCalleesMultimapBuilder = ImmutableMultimap.builder();
            for (TemplateNode template : depsInfo.depTemplateSet) {
                if (!this.templateToLocalIjParamsMap.containsKey(template)) {
                    this.templateToLocalIjParamsMap.put(template, FindIjParamsVisitor.getAllIjs(template));
                }
                for (String localIjParam : this.templateToLocalIjParamsMap.get(template)) {
                    ijParamToCalleesMultimapBuilder.put((Object)localIjParam, (Object)template);
                }
                for (TemplateParam injectedParam : template.getInjectedParams()) {
                    ijParamToCalleesMultimapBuilder.put((Object)injectedParam.name(), (Object)template);
                }
            }
            IjParamsInfo ijParamsInfo = new IjParamsInfo((ImmutableMultimap<String, TemplateNode>)ijParamToCalleesMultimapBuilder.build());
            this.depsInfoToIjParamsInfoMap.put(depsInfo, ijParamsInfo);
        }
        return this.depsInfoToIjParamsInfoMap.get(depsInfo);
    }

    public ImmutableMap<TemplateNode, IjParamsInfo> execOnAllTemplates(SoyFileSetNode soyTree) {
        ImmutableMap.Builder resultMapBuilder = ImmutableMap.builder();
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            for (TemplateNode template : soyFile.getChildren()) {
                resultMapBuilder.put((Object)template, (Object)this.exec(template));
            }
        }
        return resultMapBuilder.build();
    }

    private static Set<String> getAllIjs(Node soyTree) {
        final HashSet<String> ijs = new HashSet<String>();
        SoyTreeUtils.visitAllNodes(soyTree, (NodeVisitor<? super Node, Boolean>)new NodeVisitor<Node, Boolean>(){

            @Override
            public Boolean exec(Node node) {
                if (FindIjParamsVisitor.isIj(node)) {
                    ijs.add(((VarRefNode)node).getName());
                }
                return true;
            }
        });
        return ijs;
    }

    private static boolean isIj(Node node) {
        VarRefNode varRef;
        return node instanceof VarRefNode && (varRef = (VarRefNode)node).isInjected();
    }

    public static class IjParamsInfo {
        public final ImmutableSortedSet<String> ijParamSet;
        public final ImmutableMultimap<String, TemplateNode> ijParamToCalleesMultimap;

        public IjParamsInfo(ImmutableMultimap<String, TemplateNode> ijParamToCalleesMultimap) {
            this.ijParamToCalleesMultimap = ijParamToCalleesMultimap;
            this.ijParamSet = ImmutableSortedSet.copyOf((Collection)ijParamToCalleesMultimap.keySet());
        }
    }
}

