/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayList;
import java.util.List;

final class DesugarHtmlNodesPass
extends CompilerFileSetPass {
    DesugarHtmlNodesPass() {
    }

    @Override
    public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
        IdGenerator idGenerator = fileSet.getNodeIdGenerator();
        this.run((SoyNode)fileSet, idGenerator);
    }

    @VisibleForTesting
    void run(SoyNode node, IdGenerator idGenerator) {
        new RewritingVisitor(idGenerator).exec(node);
    }

    private static final class RewritingVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private final IdGenerator idGenerator;
        boolean needsSpaceForAttribute;
        boolean needsSpaceSelfClosingTag;
        final List<SoyNode.StandaloneNode> replacements = new ArrayList<SoyNode.StandaloneNode>();

        RewritingVisitor(IdGenerator idGenerator) {
            this.idGenerator = idGenerator;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.needsSpaceForAttribute = false;
            this.visitChildren(node);
        }

        private void visitHtmlTagNode(HtmlTagNode tag) {
            this.needsSpaceForAttribute = true;
            this.visitChildren(tag);
            this.needsSpaceForAttribute = false;
            this.replacements.add(this.createPrefix(tag instanceof HtmlOpenTagNode ? "<" : "</", tag));
            this.replacements.addAll(tag.getChildren());
            this.replacements.add(this.createSuffix(tag instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)tag).isSelfClosing() ? (this.needsSpaceSelfClosingTag ? " />" : "/>") : ">", tag));
            this.needsSpaceSelfClosingTag = false;
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            this.visitChildren(node);
            HtmlAttributeValueNode.Quotes quotes = node.getQuotes();
            if (quotes == HtmlAttributeValueNode.Quotes.NONE) {
                this.replacements.addAll(node.getChildren());
                this.needsSpaceSelfClosingTag = true;
            } else {
                this.replacements.add(this.createPrefix(quotes.getQuotationCharacter(), node));
                this.replacements.addAll(node.getChildren());
                this.replacements.add(this.createSuffix(quotes.getQuotationCharacter(), node));
                this.needsSpaceSelfClosingTag = false;
            }
        }

        private RawTextNode createPrefix(String prefix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getBeginLocation();
            if (prefix.length() > 1) {
                location = location.offsetEndCol(prefix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), prefix, location);
        }

        private RawTextNode createSuffix(String suffix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getEndLocation();
            if (suffix.length() > 1) {
                location = location.offsetStartCol(suffix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), suffix, location);
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            this.visitChildren(node);
            if (this.needsSpaceForAttribute) {
                this.replacements.add(new RawTextNode(this.idGenerator.genId(), " ", node.getSourceLocation().getBeginLocation()));
            } else {
                this.needsSpaceForAttribute = true;
            }
            this.replacements.add((SoyNode.StandaloneNode)node.getChild(0));
            if (node.hasValue()) {
                this.replacements.add(new RawTextNode(this.idGenerator.genId(), "=", node.getEqualsLocation()));
                this.replacements.addAll(node.getChildren().subList(1, node.numChildren()));
            }
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            boolean prevNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            this.needsSpaceForAttribute = false;
            boolean prevNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            this.needsSpaceSelfClosingTag = false;
            this.visitChildren(node);
            this.needsSpaceForAttribute = prevNeedsSpaceForAttribute;
            this.needsSpaceSelfClosingTag = prevNeedsSpaceForSelfClosingTag;
        }

        @Override
        protected void visitIfNode(IfNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.visitControlFlowBranches((List<? extends SoyNode.ParentSoyNode<?>>)ImmutableList.of((Object)node));
        }

        @Override
        protected void visitForeachNode(ForeachNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgPluralNode(MsgPluralNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgSelectNode(MsgSelectNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        private void visitControlFlowBranches(List<? extends SoyNode.ParentSoyNode<?>> branches) {
            boolean startNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            boolean endNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            boolean startNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            boolean endNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            for (SoyNode.ParentSoyNode<?> branch : branches) {
                this.visitChildren(branch);
                endNeedsSpaceForAttribute |= this.needsSpaceForAttribute;
                this.needsSpaceForAttribute = startNeedsSpaceForAttribute;
                endNeedsSpaceForSelfClosingTag |= this.needsSpaceSelfClosingTag;
                this.needsSpaceSelfClosingTag = startNeedsSpaceForSelfClosingTag;
            }
            this.needsSpaceForAttribute = endNeedsSpaceForAttribute;
            this.needsSpaceSelfClosingTag = endNeedsSpaceForSelfClosingTag;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            this.doVisitChildren(node);
        }

        private <C extends SoyNode> void doVisitChildren(SoyNode.ParentSoyNode<C> parent) {
            for (int i = 0; i < parent.numChildren(); ++i) {
                SoyNode child = (SoyNode)parent.getChild(i);
                this.visit(child);
                if (this.replacements.isEmpty()) continue;
                parent.removeChild(i);
                List<SoyNode.StandaloneNode> typedReplacements = this.replacements;
                parent.addChildren(i, typedReplacements);
                i += this.replacements.size() - 1;
                this.replacements.clear();
            }
            Preconditions.checkState((boolean)this.replacements.isEmpty());
        }
    }
}

