/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.UnknownType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.HashSet;

final class CheckProtoInitCallsPass
extends CompilerFilePass {
    private static final SoyErrorKind FIELD_DOES_NOT_EXIST = SoyErrorKind.of("Proto field ''{0}'' does not exist.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MISSING_REQUIRED_FIELD = SoyErrorKind.of("Missing required proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NULL_ARG_TYPE = SoyErrorKind.of("Cannot assign static type ''null'' to proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckProtoInitCallsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (ProtoInitNode node : SoyTreeUtils.getAllNodesOfType(file, ProtoInitNode.class)) {
            this.checkProtoInitNode(node);
        }
    }

    private void checkProtoInitNode(ProtoInitNode node) {
        SoyType soyType = node.getType();
        Preconditions.checkNotNull((Object)soyType);
        if (soyType.getKind() == SoyType.Kind.PROTO) {
            this.checkProto(node, (SoyProtoType)soyType);
        }
    }

    private void checkProto(ProtoInitNode node, SoyProtoType soyType) {
        HashSet givenParams = Sets.newHashSet(node.getParamNames());
        for (Descriptors.FieldDescriptor field : soyType.getDescriptor().getFields()) {
            if (!field.isRequired() || givenParams.contains(field.getName())) continue;
            this.errorReporter.report(node.getSourceLocation(), MISSING_REQUIRED_FIELD, field.getName());
        }
        ImmutableSet<String> fields = soyType.getFieldNames();
        for (int i = 0; i < node.numChildren(); ++i) {
            SoyType argElementType;
            String fieldName = (String)node.getParamNames().get(i);
            ExprNode expr = node.getChild(i);
            if (!fields.contains((Object)fieldName)) {
                String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(fields, fieldName);
                this.errorReporter.report(expr.getSourceLocation(), FIELD_DOES_NOT_EXIST, fieldName, extraErrorMessage);
                continue;
            }
            SoyType argType = expr.getType();
            if (argType.equals(NullType.getInstance())) {
                this.errorReporter.report(expr.getSourceLocation(), NULL_ARG_TYPE, fieldName);
            }
            SoyType fieldType = soyType.getFieldType(fieldName);
            if (argType.equals(UnknownType.getInstance()) || argType.equals(ErrorType.getInstance())) {
                return;
            }
            if (fieldType.getKind() == SoyType.Kind.LIST && argType.getKind() == SoyType.Kind.LIST && ((argElementType = ((ListType)argType).getElementType()) == null || argElementType.equals(UnknownType.getInstance()))) {
                return;
            }
            SoyType expectedType = SoyTypes.makeNullable(fieldType);
            if (expectedType.isAssignableFrom(argType)) continue;
            this.errorReporter.report(expr.getSourceLocation(), CheckTemplateCallsPass.ARGUMENT_TYPE_MISMATCH, fieldName, expectedType, argType);
        }
    }
}

