/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class CheckNonEmptyMsgNodesPass
extends CompilerFilePass {
    private static final SoyErrorKind EMPTY_MSG_ERROR = SoyErrorKind.of("Empty messages are forbidden.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckNonEmptyMsgNodesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (MsgNode msg : SoyTreeUtils.getAllNodesOfType(file, MsgNode.class)) {
            if (msg.numChildren() == 0) {
                this.errorReporter.report(msg.getSourceLocation(), EMPTY_MSG_ERROR, new Object[0]);
                continue;
            }
            if (msg.numChildren() != 1 || !(msg.getChild(0) instanceof RawTextNode) || !((RawTextNode)msg.getChild(0)).getRawText().isEmpty()) continue;
            this.errorReporter.report(msg.getSourceLocation(), EMPTY_MSG_ERROR, new Object[0]);
        }
    }
}

