/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.DoNotMock;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.msgs.restricted.AutoValue_SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import javax.annotation.Nullable;

@DoNotMock(value="use the builder() instead to construct a real instance")
public abstract class SoyMsg {
    private ImmutableSet<SourceLocation> sourceLocations = ImmutableSet.of();

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public abstract String getLocaleString();

    public abstract long getId();

    public abstract long getAltId();

    @Nullable
    public abstract String getMeaning();

    @Nullable
    public abstract String getDesc();

    public abstract boolean isHidden();

    @Nullable
    public abstract String getContentType();

    public void addSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocations = ImmutableSet.builder().addAll(this.sourceLocations).add((Object)sourceLocation).build();
    }

    public ImmutableSet<SourceLocation> getSourceLocations() {
        return this.sourceLocations;
    }

    public abstract boolean isPlrselMsg();

    public abstract ImmutableList<SoyMsgPart> getParts();

    public static final class Builder {
        private long id;
        private long altId = -1L;
        @Nullable
        private String localeString;
        @Nullable
        private String meaning;
        @Nullable
        private String desc;
        private boolean isHidden;
        @Nullable
        private String contentType;
        @Nullable
        private SourceLocation sourceLocation;
        private boolean isPlrselMsg;
        private ImmutableList<SoyMsgPart> parts;

        private Builder() {
        }

        public Builder setId(long id) {
            Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0);
            this.id = id;
            return this;
        }

        public Builder setAltId(long altId) {
            Preconditions.checkArgument((altId >= 0L ? 1 : 0) != 0);
            this.altId = altId;
            return this;
        }

        public Builder setLocaleString(String localeString) {
            this.localeString = (String)Preconditions.checkNotNull((Object)localeString);
            return this;
        }

        public Builder setMeaning(String meaning) {
            this.meaning = (String)Preconditions.checkNotNull((Object)meaning);
            return this;
        }

        public Builder setDesc(String desc) {
            this.desc = (String)Preconditions.checkNotNull((Object)desc);
            return this;
        }

        public Builder setIsHidden(boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            return this;
        }

        public Builder setSourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = (SourceLocation)Preconditions.checkNotNull((Object)sourceLocation);
            return this;
        }

        public Builder setIsPlrselMsg(boolean isPlrselMsg) {
            this.isPlrselMsg = isPlrselMsg;
            return this;
        }

        public Builder setParts(Iterable<? extends SoyMsgPart> parts) {
            this.parts = ImmutableList.copyOf(parts);
            Preconditions.checkArgument((!this.parts.isEmpty() ? 1 : 0) != 0, (Object)"Parts should never be empty");
            return this;
        }

        public SoyMsg build() {
            AutoValue_SoyMsg msg = new AutoValue_SoyMsg(this.localeString, this.id, this.altId, this.meaning, this.desc, this.isHidden, this.contentType, this.isPlrselMsg, this.parts);
            if (this.sourceLocation != null) {
                msg.addSourceLocation(this.sourceLocation);
            }
            return msg;
        }
    }
}

