/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.RecordType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.proto.SoyProtoEnumType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class JsType {
    private static final JsType ANY_TYPE = JsType.builder().addType("*").setPredicate(TypePredicate.NO_OP).build();
    private static final JsType UNKNOWN_TYPE = JsType.builder().addType("?").setPredicate(TypePredicate.NO_OP).build();
    private static final JsType BOOLEAN_TYPE = JsType.builder().addType("boolean").setPredicate(new TypePredicate(){

        @Override
        public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of((Object)JsRuntime.GOOG_IS_BOOLEAN.call(value).or(value.tripleEquals(CodeChunk.number(1L)), codeGenerator).or(value.tripleEquals(CodeChunk.number(0L)), codeGenerator));
        }
    }).build();
    private static final JsType NUMBER_TYPE = JsType.builder().addType("number").setPredicate(JsRuntime.GOOG_IS_NUMBER).build();
    private static final JsType STRING_OR_SANITIZED_CONTENT_TYPE = JsType.builder().addType("string").addType("!goog.soy.data.SanitizedContent").addRequire(GoogRequire.create("goog.soy.data.SanitizedContent")).setPredicate(new TypePredicate(){

        @Override
        public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of((Object)JsRuntime.GOOG_IS_STRING.call(value).or(value.instanceof_(JsRuntime.GOOG_SOY_DATA_SANITIZED_CONTENT), codeGenerator));
        }
    }).build();
    private static final JsType RAW_ARRAY_TYPE = JsType.builder().addType("!Array").setPredicate(JsRuntime.GOOG_IS_ARRAY).build();
    private static final JsType RAW_OBJECT_TYPE = JsType.builder().addType("!Object").setPredicate(JsRuntime.GOOG_IS_OBJECT).build();
    private static final JsType NULL_OR_UNDEFINED_TYPE = JsType.builder().addType("null").addType("undefined").setPredicate(new TypePredicate(){

        @Override
        public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
            return Optional.of((Object)value.doubleEqualsNull());
        }
    }).build();
    private static final ImmutableMap<SanitizedContent.ContentKind, JsType> STRICT_TYPES;
    private static final JsType IDOM_HTML_AND_ATTRIBUTES;
    private final ImmutableSortedSet<String> typeExpressions;
    private final ImmutableSet<GoogRequire> extraRequires;
    private final ImmutableSet<ValueCoercionStrategy> coercionStrategies;
    private final TypePredicate predicate;

    static JsType forSoyType(SoyType soyType, boolean isIncrementalDom) {
        switch (soyType.getKind()) {
            case NULL: {
                return NULL_OR_UNDEFINED_TYPE;
            }
            case ANY: {
                return ANY_TYPE;
            }
            case UNKNOWN: {
                return UNKNOWN_TYPE;
            }
            case BOOL: {
                return BOOLEAN_TYPE;
            }
            case PROTO_ENUM: {
                SoyProtoEnumType enumType = (SoyProtoEnumType)soyType;
                String enumTypeName = enumType.getNameForBackend(SoyBackendKind.JS_SRC);
                return JsType.builder().addType("number").addType(enumTypeName).addRequire(GoogRequire.create(enumTypeName)).setPredicate(JsRuntime.GOOG_IS_NUMBER).build();
            }
            case FLOAT: 
            case INT: {
                return NUMBER_TYPE;
            }
            case STRING: {
                return STRING_OR_SANITIZED_CONTENT_TYPE;
            }
            case ATTRIBUTES: 
            case HTML: {
                if (isIncrementalDom) {
                    return IDOM_HTML_AND_ATTRIBUTES;
                }
            }
            case CSS: 
            case JS: 
            case URI: 
            case TRUSTED_RESOURCE_URI: {
                return (JsType)STRICT_TYPES.get((Object)((SanitizedType)soyType).getContentKind());
            }
            case LIST: {
                ListType listType = (ListType)soyType;
                if (listType.getElementType().getKind() == SoyType.Kind.ANY) {
                    return RAW_ARRAY_TYPE;
                }
                JsType element = JsType.forSoyType(listType.getElementType(), isIncrementalDom);
                return JsType.builder().addType("!Array<" + element.typeExpr() + ">").addRequires((Iterable<GoogRequire>)element.getGoogRequires()).setPredicate(JsRuntime.GOOG_IS_ARRAY).build();
            }
            case MAP: {
                MapType mapType = (MapType)soyType;
                if (mapType.getKeyType().getKind() == SoyType.Kind.ANY && mapType.getValueType().getKind() == SoyType.Kind.ANY) {
                    return RAW_OBJECT_TYPE;
                }
                JsType keyTypeName = JsType.forSoyType(mapType.getKeyType(), isIncrementalDom);
                JsType valueTypeName = JsType.forSoyType(mapType.getValueType(), isIncrementalDom);
                return JsType.builder().addType("!Object<" + keyTypeName.typeExpr() + "," + valueTypeName.typeExpr() + ">").addRequires((Iterable<GoogRequire>)keyTypeName.getGoogRequires()).addRequires((Iterable<GoogRequire>)valueTypeName.getGoogRequires()).setPredicate(JsRuntime.GOOG_IS_OBJECT).build();
            }
            case PROTO: {
                final SoyProtoType protoType = (SoyProtoType)soyType;
                String protoTypeName = protoType.getNameForBackend(SoyBackendKind.JS_SRC);
                return JsType.builder().addType(protoTypeName).addRequire(GoogRequire.create(protoTypeName)).addCoercionStrategy(ValueCoercionStrategy.PROTO).setPredicate(new TypePredicate(){

                    @Override
                    public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                        return Optional.of((Object)value.instanceof_(JsRuntime.protoConstructor(protoType)));
                    }
                }).build();
            }
            case RECORD: {
                RecordType recordType = (RecordType)soyType;
                if (recordType.getMembers().isEmpty()) {
                    return RAW_OBJECT_TYPE;
                }
                Builder builder = JsType.builder();
                LinkedHashMap members = new LinkedHashMap();
                for (Map.Entry member : recordType.getMembers().entrySet()) {
                    JsType forSoyType = JsType.forSoyType((SoyType)member.getValue(), isIncrementalDom);
                    builder.addRequires((Iterable<GoogRequire>)forSoyType.getGoogRequires());
                    members.put(member.getKey(), forSoyType.typeExprForRecordMember(false));
                }
                return builder.addType("{" + Joiner.on((String)", ").withKeyValueSeparator(": ").join(members) + ",}").setPredicate(JsRuntime.GOOG_IS_OBJECT).build();
            }
            case UNION: {
                UnionType unionType = (UnionType)soyType;
                Builder builder = JsType.builder();
                final LinkedHashSet<JsType> types = new LinkedHashSet<JsType>();
                boolean isNullable = unionType.isNullable();
                if (isNullable) {
                    builder.addTypes((Iterable<String>)JsType.NULL_OR_UNDEFINED_TYPE.typeExpressions);
                    builder.addCoercionStrategy(ValueCoercionStrategy.NULL);
                    types.add(NULL_OR_UNDEFINED_TYPE);
                }
                for (SoyType member : unionType.getMembers()) {
                    if (member.getKind() == SoyType.Kind.NULL) continue;
                    JsType memberType = JsType.forSoyType(member, isIncrementalDom);
                    builder.addRequires((Iterable<GoogRequire>)memberType.extraRequires);
                    builder.addTypes((Iterable<String>)memberType.typeExpressions);
                    builder.addCoercionStrategies((Iterable<ValueCoercionStrategy>)memberType.coercionStrategies);
                    types.add(memberType);
                }
                return builder.setPredicate(new TypePredicate(){

                    @Override
                    public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                        CodeChunk.WithValue result = null;
                        for (JsType memberType : types) {
                            Optional<CodeChunk.WithValue> typeAssertion = memberType.getTypeAssertion(value, codeGenerator);
                            if (!typeAssertion.isPresent()) {
                                return Optional.absent();
                            }
                            if (result == null) {
                                result = (CodeChunk.WithValue)typeAssertion.get();
                                continue;
                            }
                            result = result.or((CodeChunk.WithValue)typeAssertion.get(), codeGenerator);
                        }
                        return Optional.of(result);
                    }
                }).build();
            }
        }
        throw new AssertionError((Object)("unhandled soytype: " + soyType));
    }

    private JsType(Builder builder) {
        this.typeExpressions = builder.typeExpressions.build();
        Preconditions.checkArgument((!this.typeExpressions.isEmpty() ? 1 : 0) != 0);
        this.coercionStrategies = Sets.immutableEnumSet(builder.coercionStrategies);
        this.extraRequires = builder.extraRequires.build();
        this.predicate = (TypePredicate)Preconditions.checkNotNull((Object)builder.predicate);
    }

    String typeExpr() {
        return Joiner.on((char)'|').join(this.typeExpressions);
    }

    String typeExprForRecordMember(boolean isOptional) {
        if (this.typeExpressions.size() > 1 || isOptional) {
            return "(" + this.typeExpr() + (isOptional && !this.typeExpressions.contains((Object)"undefined") ? "|undefined" : "") + ")";
        }
        return this.typeExpr();
    }

    final ImmutableSet<GoogRequire> getGoogRequires() {
        return this.extraRequires;
    }

    final Optional<CodeChunk.WithValue> getTypeAssertion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
        return this.predicate.maybeCheck(value, codeGenerator);
    }

    @Nullable
    final CodeChunk.WithValue getValueCoercion(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
        boolean needsProtoCoercion = this.coercionStrategies.contains((Object)ValueCoercionStrategy.PROTO);
        if (!needsProtoCoercion) {
            return null;
        }
        CodeChunk.WithValue coercion = value.dotAccess("$jspbMessageInstance").or(value, codeGenerator);
        return this.coercionStrategies.contains((Object)ValueCoercionStrategy.NULL) ? value.and(coercion, codeGenerator) : coercion;
    }

    private static JsType createSanitized(final SanitizedContent.ContentKind kind) {
        String type = NodeContentKinds.toJsSanitizedContentCtorName(kind);
        Builder builder = JsType.builder();
        builder.addType("!" + type);
        builder.addRequire(GoogRequire.create(type));
        builder.addType("string");
        builder.addType("!goog.soy.data.UnsanitizedText");
        builder.addRequire(GoogRequire.create("goog.soy.data.UnsanitizedText"));
        switch (kind) {
            case CSS: {
                builder.addType("!goog.html.SafeStyle");
                break;
            }
            case HTML: {
                builder.addType("!goog.html.SafeHtml");
                break;
            }
            case JS: {
                builder.addType("!goog.html.SafeScript");
                break;
            }
            case ATTRIBUTES: 
            case TEXT: {
                break;
            }
            case TRUSTED_RESOURCE_URI: {
                builder.addType("!goog.html.TrustedResourceUrl");
                break;
            }
            case URI: {
                builder.addType("!goog.html.TrustedResourceUrl");
                builder.addType("!goog.html.SafeUrl");
                builder.addType("!goog.Uri");
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled content kind");
            }
        }
        return builder.setPredicate(new TypePredicate(){

            @Override
            public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                return Optional.of((Object)JsRuntime.sanitizedContentType(kind).dotAccess("isCompatibleWith").call(value));
            }
        }).build();
    }

    private static Builder builder() {
        return new Builder();
    }

    static {
        IDOM_HTML_AND_ATTRIBUTES = JsType.builder().addType("function()").setPredicate(JsRuntime.GOOG_IS_FUNCTION).build();
        EnumMap<SanitizedContent.ContentKind, JsType> types = new EnumMap<SanitizedContent.ContentKind, JsType>(SanitizedContent.ContentKind.class);
        for (SanitizedContent.ContentKind kind : SanitizedContent.ContentKind.values()) {
            types.put(kind, JsType.createSanitized(kind));
        }
        STRICT_TYPES = Maps.immutableEnumMap(types);
    }

    private static final class Builder {
        final ImmutableSortedSet.Builder<String> typeExpressions = ImmutableSortedSet.naturalOrder();
        final ImmutableSet.Builder<GoogRequire> extraRequires = ImmutableSet.builder();
        final Set<ValueCoercionStrategy> coercionStrategies = EnumSet.noneOf(ValueCoercionStrategy.class);
        @Nullable
        TypePredicate predicate;

        private Builder() {
        }

        Builder addType(String typeExpr) {
            this.typeExpressions.add((Object)typeExpr);
            return this;
        }

        Builder addTypes(Iterable<String> typeExpressions) {
            this.typeExpressions.addAll(typeExpressions);
            return this;
        }

        Builder addRequire(GoogRequire symbol) {
            this.extraRequires.add((Object)symbol);
            return this;
        }

        Builder addRequires(Iterable<GoogRequire> symbols) {
            this.extraRequires.addAll(symbols);
            return this;
        }

        Builder addCoercionStrategy(ValueCoercionStrategy strategy) {
            this.coercionStrategies.add(strategy);
            return this;
        }

        Builder addCoercionStrategies(Iterable<ValueCoercionStrategy> strategies) {
            Iterables.addAll(this.coercionStrategies, strategies);
            return this;
        }

        Builder setPredicate(TypePredicate predicate) {
            Preconditions.checkState((this.predicate == null ? 1 : 0) != 0);
            this.predicate = (TypePredicate)Preconditions.checkNotNull((Object)predicate);
            return this;
        }

        Builder setPredicate(final CodeChunk.WithValue predicateFunction) {
            return this.setPredicate(new TypePredicate(){

                @Override
                public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                    return Optional.of((Object)((CodeChunk.WithValue)Preconditions.checkNotNull((Object)predicateFunction)).call(value));
                }
            });
        }

        JsType build() {
            return new JsType(this);
        }
    }

    private static interface TypePredicate {
        public static final TypePredicate NO_OP = new TypePredicate(){

            @Override
            public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue value, CodeChunk.Generator codeGenerator) {
                return Optional.absent();
            }
        };

        public Optional<CodeChunk.WithValue> maybeCheck(CodeChunk.WithValue var1, CodeChunk.Generator var2);
    }

    private static enum ValueCoercionStrategy {
        NULL,
        PROTO;

    }
}

