/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.jssrc.dsl.AutoValue_Declaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.VariableReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Declaration
extends CodeChunk {
    abstract String varName();

    abstract CodeChunk.WithValue rhs();

    @Nullable
    abstract String closureCompilerTypeExpression();

    abstract ImmutableSet<GoogRequire> googRequires();

    static Declaration create(String varName, CodeChunk.WithValue rhs) {
        return new AutoValue_Declaration(varName, rhs, null, (ImmutableSet<GoogRequire>)ImmutableSet.of());
    }

    static Declaration create(String varName, CodeChunk.WithValue rhs, @Nullable String closureCompilerTypeExpression, Iterable<GoogRequire> googRequires) {
        return new AutoValue_Declaration(varName, rhs, closureCompilerTypeExpression, (ImmutableSet<GoogRequire>)ImmutableSet.copyOf(googRequires));
    }

    public CodeChunk.WithValue ref() {
        return VariableReference.of(this);
    }

    @Override
    String getCode(int startingIndent) {
        FormattingContext ctx = new FormattingContext(startingIndent);
        ctx.appendInitialStatements(this);
        return ctx.toString();
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        ctx.appendInitialStatements(this.rhs());
        if (this.closureCompilerTypeExpression() != null) {
            ctx.append("/** @type {").append(this.closureCompilerTypeExpression()).append("} */").endLine();
        }
        ctx.append("var ").append(this.varName()).append(" = ").appendOutputExpression(this.rhs()).append(";").endLine();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (GoogRequire require : this.googRequires()) {
            collector.add(require);
        }
        this.rhs().collectRequires(collector);
    }
}

