/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Conditional;
import com.google.template.soy.jssrc.dsl.IfThenPair;
import com.google.template.soy.jssrc.dsl.Ternary;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class ConditionalBuilder {
    private final ImmutableList.Builder<IfThenPair> conditions = ImmutableList.builder();
    @Nullable
    private CodeChunk trailingElse = null;

    ConditionalBuilder(CodeChunk.WithValue predicate, CodeChunk consequent) {
        this.conditions.add((Object)new IfThenPair(predicate, consequent));
    }

    public ConditionalBuilder elseif_(CodeChunk.WithValue predicate, CodeChunk consequent) {
        this.conditions.add((Object)new IfThenPair(predicate, consequent));
        return this;
    }

    public ConditionalBuilder else_(CodeChunk trailingElse) {
        Preconditions.checkState((this.trailingElse == null ? 1 : 0) != 0);
        this.trailingElse = trailingElse;
        return this;
    }

    @CheckReturnValue
    public CodeChunk build() {
        ImmutableList pairs = this.conditions.build();
        if (this.isRepresentableAsTernaryExpression((ImmutableList<IfThenPair>)pairs)) {
            return Ternary.create(((IfThenPair)pairs.get((int)0)).predicate, (CodeChunk.WithValue)((IfThenPair)pairs.get((int)0)).consequent, (CodeChunk.WithValue)this.trailingElse);
        }
        return Conditional.create((ImmutableList<IfThenPair>)pairs, this.trailingElse);
    }

    private boolean isRepresentableAsTernaryExpression(ImmutableList<IfThenPair> pairs) {
        if (pairs.size() != 1 || this.trailingElse == null) {
            return false;
        }
        IfThenPair ifThen = (IfThenPair)Iterables.getOnlyElement(pairs);
        CodeChunk.WithValue predicate = ifThen.predicate;
        CodeChunk consequent = ifThen.consequent;
        return consequent instanceof CodeChunk.WithValue && this.trailingElse instanceof CodeChunk.WithValue && predicate.initialStatements().containsAll(((CodeChunk.WithValue)consequent).initialStatements()) && predicate.initialStatements().containsAll(((CodeChunk.WithValue)this.trailingElse).initialStatements());
    }
}

