/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.ArrayLiteral;
import com.google.template.soy.jssrc.dsl.Assignment;
import com.google.template.soy.jssrc.dsl.BinaryOperation;
import com.google.template.soy.jssrc.dsl.Bracket;
import com.google.template.soy.jssrc.dsl.Call;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Composite;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.ConditionalExpressionBuilder;
import com.google.template.soy.jssrc.dsl.Declaration;
import com.google.template.soy.jssrc.dsl.Dot;
import com.google.template.soy.jssrc.dsl.For;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.Leaf;
import com.google.template.soy.jssrc.dsl.LeafStatement;
import com.google.template.soy.jssrc.dsl.MapLiteral;
import com.google.template.soy.jssrc.dsl.New;
import com.google.template.soy.jssrc.dsl.PrefixUnaryOperation;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.StatementList;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.Ternary;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Arrays;
import java.util.List;

@Immutable
public abstract class CodeChunk {
    public static final WithValue LITERAL_TRUE = CodeChunk.id("true");
    public static final WithValue LITERAL_FALSE = CodeChunk.id("false");
    public static final WithValue LITERAL_NULL = CodeChunk.id("null");
    public static final WithValue LITERAL_EMPTY_STRING = Leaf.create("''");
    public static final WithValue EMPTY_OBJECT_LITERAL = Leaf.create("{}");

    public final CodeChunk concat(CodeChunk other) {
        return StatementList.of((ImmutableList<? extends CodeChunk>)ImmutableList.of((Object)this, (Object)other));
    }

    public static ConditionalBuilder ifStatement(WithValue predicate, CodeChunk consequent) {
        return new ConditionalBuilder(predicate, consequent);
    }

    public static ConditionalExpressionBuilder ifExpression(WithValue predicate, WithValue consequent) {
        return new ConditionalExpressionBuilder(predicate, consequent);
    }

    public static WithValue fromExpr(JsExpr expr, Iterable<GoogRequire> requires) {
        return Leaf.create(expr, requires);
    }

    public static WithValue id(String id) {
        CodeChunkUtils.checkId(id);
        return Leaf.create(id);
    }

    static WithValue id(String id, Iterable<GoogRequire> requires) {
        CodeChunkUtils.checkId(id);
        return Leaf.create(id, requires);
    }

    public static WithValue dottedIdNoRequire(String dotSeparatedIdentifiers) {
        return CodeChunk.dottedIdWithRequires(dotSeparatedIdentifiers, (Iterable<GoogRequire>)ImmutableSet.of());
    }

    static WithValue dottedIdWithRequires(String dotSeparatedIdentifiers, Iterable<GoogRequire> requires) {
        List ids = Splitter.on((char)'.').splitToList((CharSequence)dotSeparatedIdentifiers);
        Preconditions.checkState((!ids.isEmpty() ? 1 : 0) != 0, (String)"not a dot-separated sequence of JavaScript identifiers: %s", (Object)dotSeparatedIdentifiers);
        WithValue tip = CodeChunk.id((String)ids.get(0), requires);
        for (int i = 1; i < ids.size(); ++i) {
            tip = tip.dotAccess((String)ids.get(i));
        }
        return tip;
    }

    public static WithValue stringLiteral(String contents) {
        String escaped = BaseUtils.escapeToSoyString(contents, true);
        escaped = escaped.replace("</script", "<\\/script");
        return Leaf.create(escaped);
    }

    public static WithValue number(long value) {
        Preconditions.checkArgument((boolean)IntegerNode.isInRange(value), (String)"Number is outside JS safe integer range: %s", (long)value);
        return Leaf.create(Long.toString(value));
    }

    public static WithValue number(double value) {
        return Leaf.create(Double.toString(value));
    }

    public static CodeChunk assign(String varName, WithValue rhs) {
        return Assignment.create(varName, rhs);
    }

    public static Declaration declare(String varName, WithValue rhs) {
        return Declaration.create(varName, rhs);
    }

    public static Declaration declare(String varName, WithValue value, String typeExpr, Iterable<GoogRequire> requires) {
        return Declaration.create(varName, value, typeExpr, requires);
    }

    public static WithValue not(WithValue arg) {
        return PrefixUnaryOperation.create(Operator.NOT, arg);
    }

    public static SwitchBuilder switch_(WithValue switchOn) {
        return new SwitchBuilder(switchOn);
    }

    public static WithValue new_(WithValue ctor) {
        return New.create(ctor);
    }

    public static WithValue operation(Operator op, List<WithValue> operands) {
        Preconditions.checkArgument((operands.size() == op.getNumOperands() ? 1 : 0) != 0);
        Preconditions.checkArgument((op != Operator.AND && op != Operator.OR && op != Operator.CONDITIONAL ? 1 : 0) != 0);
        switch (op.getNumOperands()) {
            case 1: {
                return PrefixUnaryOperation.create(op, operands.get(0));
            }
            case 2: {
                return BinaryOperation.create(op, operands.get(0), operands.get(1));
            }
        }
        throw new AssertionError();
    }

    public static WithValue arrayLiteral(Iterable<? extends WithValue> elements) {
        return ArrayLiteral.create((ImmutableList<? extends WithValue>)ImmutableList.copyOf(elements));
    }

    public static WithValue mapLiteral(Iterable<? extends WithValue> keys, Iterable<? extends WithValue> values) {
        return MapLiteral.create((ImmutableList<? extends WithValue>)ImmutableList.copyOf(keys), (ImmutableList<? extends WithValue>)ImmutableList.copyOf(values));
    }

    public static CodeChunk forLoop(String localVar, WithValue initial, WithValue limit, WithValue increment, CodeChunk body) {
        return For.create(localVar, initial, limit, increment, body);
    }

    public static CodeChunk forLoop(String localVar, WithValue limit, CodeChunk body) {
        return For.create(localVar, CodeChunk.number(0L), limit, CodeChunk.number(1L), body);
    }

    public static CodeChunk return_(WithValue returnValue) {
        return Return.create(returnValue);
    }

    public static WithValue dontTrustPrecedenceOf(JsExpr couldHaveWrongPrecedence, Iterable<GoogRequire> requires) {
        return Group.create(CodeChunk.fromExpr(couldHaveWrongPrecedence, requires));
    }

    public static CodeChunk treatRawStringAsStatementLegacyOnly(String rawString, Iterable<GoogRequire> requires) {
        return LeafStatement.create(rawString.trim(), requires);
    }

    public abstract void collectRequires(RequiresCollector var1);

    public final String getCode() {
        return this.getCode(0);
    }

    public final String getStatementsForInsertingIntoForeignCodeAtIndent(int startingIndent) {
        String code = this.getCode(startingIndent);
        return code.endsWith("\n") ? code : code + "\n";
    }

    public final JsExpr assertExpr() {
        RequiresCollector.IntoImmutableSet collector = new RequiresCollector.IntoImmutableSet();
        JsExpr expr = this.assertExprAndCollectRequires(collector);
        ImmutableSet<GoogRequire> requires = collector.get();
        if (!requires.isEmpty()) {
            throw new IllegalStateException("calling assertExpr() would drop requires!: " + requires);
        }
        return expr;
    }

    public final JsExpr assertExprAndCollectRequires(RequiresCollector collector) {
        WithValue withValue = (WithValue)this;
        if (!withValue.isRepresentableAsSingleExpression()) {
            throw new IllegalStateException(String.format("Not an expr:\n%s", this.getCode()));
        }
        this.collectRequires(collector);
        return withValue.singleExprOrName();
    }

    @ForOverride
    String getCode(int startingIndent) {
        FormattingContext initialStatements = new FormattingContext(startingIndent);
        initialStatements.appendInitialStatements(this);
        FormattingContext outputExprs = new FormattingContext(startingIndent);
        if (this instanceof WithValue) {
            outputExprs.appendOutputExpression((WithValue)this);
            outputExprs.append(';').endLine();
        }
        return initialStatements.concat(outputExprs).toString();
    }

    abstract void doFormatInitialStatements(FormattingContext var1);

    CodeChunk() {
    }

    public static final class Generator {
        private final UniqueNameGenerator nameGenerator;

        private Generator(UniqueNameGenerator nameGenerator) {
            this.nameGenerator = nameGenerator;
        }

        public static Generator create(UniqueNameGenerator nameGenerator) {
            return new Generator(nameGenerator);
        }

        private String newVarName() {
            return this.nameGenerator.generateName("$tmp");
        }

        public Declaration declare(WithValue rhs) {
            return CodeChunk.declare(this.newVarName(), rhs);
        }

        public WithValue conditionalExpression(WithValue predicate, WithValue consequent, WithValue alternate) {
            if (predicate.initialStatements().containsAll(consequent.initialStatements()) && predicate.initialStatements().containsAll(alternate.initialStatements())) {
                return Ternary.create(predicate, consequent, alternate);
            }
            return CodeChunk.ifExpression(predicate, consequent).else_(alternate).build(this);
        }
    }

    public static interface RequiresCollector {
        public static final RequiresCollector NULL = new RequiresCollector(){

            @Override
            public void add(GoogRequire require) {
            }
        };

        public void add(GoogRequire var1);

        public static final class IntoImmutableSet
        implements RequiresCollector {
            private final ImmutableSet.Builder<GoogRequire> builder = ImmutableSet.builder();

            @Override
            public void add(GoogRequire require) {
                this.builder.add((Object)require);
            }

            public ImmutableSet<GoogRequire> get() {
                return this.builder.build();
            }
        }
    }

    @Immutable
    public static abstract class WithValue
    extends CodeChunk {
        WithValue() {
        }

        public final WithValue plus(WithValue rhs) {
            return BinaryOperation.create(Operator.PLUS, this, rhs);
        }

        public final WithValue minus(WithValue rhs) {
            return BinaryOperation.create(Operator.MINUS, this, rhs);
        }

        public final WithValue plusEquals(WithValue rhs) {
            return BinaryOperation.create("+=", 0, Operator.Associativity.RIGHT, this, rhs);
        }

        public final WithValue doubleEquals(WithValue rhs) {
            return BinaryOperation.create(Operator.EQUAL, this, rhs);
        }

        public final WithValue doubleNotEquals(WithValue rhs) {
            return BinaryOperation.create(Operator.NOT_EQUAL, this, rhs);
        }

        public final WithValue tripleEquals(WithValue rhs) {
            return BinaryOperation.create("===", Operator.EQUAL.getPrecedence(), Operator.EQUAL.getAssociativity(), this, rhs);
        }

        public final WithValue doubleEqualsNull() {
            return this.doubleEquals(LITERAL_NULL);
        }

        public final WithValue times(WithValue rhs) {
            return BinaryOperation.create(Operator.TIMES, this, rhs);
        }

        public final WithValue divideBy(WithValue rhs) {
            return BinaryOperation.create(Operator.DIVIDE_BY, this, rhs);
        }

        public final WithValue and(WithValue rhs, Generator codeGenerator) {
            return BinaryOperation.and(this, rhs, codeGenerator);
        }

        public final WithValue or(WithValue rhs, Generator codeGenerator) {
            return BinaryOperation.or(this, rhs, codeGenerator);
        }

        public final WithValue op(Operator op, WithValue rhs) {
            return BinaryOperation.operation(op, (List<WithValue>)ImmutableList.of((Object)this, (Object)rhs));
        }

        public final WithValue dotAccess(String identifier) {
            return Dot.create(this, WithValue.id(identifier));
        }

        public final WithValue bracketAccess(WithValue arg) {
            return Bracket.create(this, arg);
        }

        public final WithValue call(WithValue ... args) {
            return this.call(Arrays.asList(args));
        }

        public final WithValue call(Iterable<? extends WithValue> args) {
            return Call.create(this, (ImmutableList<WithValue>)ImmutableList.copyOf(args));
        }

        public final WithValue instanceof_(WithValue identifier) {
            return BinaryOperation.create("instanceof", Operator.LESS_THAN.getPrecedence(), Operator.Associativity.LEFT, this, identifier);
        }

        public final WithValue assign(WithValue rhs) {
            return BinaryOperation.create("=", 0, Operator.Associativity.RIGHT, this, rhs);
        }

        public final WithValue withInitialStatements(Iterable<? extends CodeChunk> initialStatements) {
            if (Iterables.isEmpty(initialStatements)) {
                return this;
            }
            return Composite.create((ImmutableList<CodeChunk>)ImmutableList.copyOf(initialStatements), this);
        }

        public final WithValue withInitialStatement(CodeChunk initialStatement) {
            return this.withInitialStatements((Iterable<? extends CodeChunk>)ImmutableList.of((Object)initialStatement));
        }

        final boolean isRepresentableAsSingleExpression() {
            return Iterables.isEmpty(this.initialStatements());
        }

        public abstract JsExpr singleExprOrName();

        abstract void doFormatOutputExpr(FormattingContext var1);

        public abstract ImmutableSet<CodeChunk> initialStatements();
    }
}

