/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;

final class UnescapingVisitor
extends AbstractSoyNodeVisitor<Void> {
    UnescapingVisitor() {
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        MsgPlaceholderNode containingPlaceholder;
        if (node.getHtmlContext() != HtmlContext.HTML_PCDATA && node.getHtmlContext() != HtmlContext.HTML_NORMAL_ATTR_VALUE) {
            return;
        }
        MsgFallbackGroupNode containingMsg = node.getNearestAncestor(MsgFallbackGroupNode.class);
        if (!(containingMsg == null || (containingPlaceholder = node.getNearestAncestor(MsgPlaceholderNode.class)) != null && SoyTreeUtils.isDescendantOf(containingPlaceholder, containingMsg))) {
            return;
        }
        node.getParent().replaceChild(node, new RawTextNode(node.getId(), UnescapeUtils.unescapeHtml(node.getRawText()), node.getSourceLocation(), node.getHtmlContext()));
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitRenderUnitNode(node);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitRenderUnitNode(node);
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.visitRenderUnitNode(node);
    }

    private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
        if (node.getContentKind() == SanitizedContent.ContentKind.HTML || node.getContentKind() == SanitizedContent.ContentKind.ATTRIBUTES) {
            this.visitSoyNode(node);
        }
    }
}

