/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.primitive.IntType;

public final class IntegerNode
extends AbstractPrimitiveNode {
    private static final long JS_MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFFL;
    private static final long JS_MIN_SAFE_INTEGER = -9007199254740991L;
    private final long value;

    public static boolean isInRange(long value) {
        return -9007199254740991L <= value && value <= 0x1FFFFFFFFFFFFFL;
    }

    public IntegerNode(long value, SourceLocation sourceLocation) {
        super(sourceLocation);
        Preconditions.checkArgument((boolean)IntegerNode.isInRange(value));
        this.value = value;
    }

    private IntegerNode(IntegerNode orig, CopyState copyState) {
        super(orig, copyState);
        this.value = orig.value;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.INTEGER_NODE;
    }

    @Override
    public IntType getType() {
        return IntType.getInstance();
    }

    public long getValue() {
        return this.value;
    }

    public boolean isInt() {
        return Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE;
    }

    @Override
    public String toSourceString() {
        return Long.toString(this.value);
    }

    @Override
    public IntegerNode copy(CopyState copyState) {
        return new IntegerNode(this, copyState);
    }
}

