/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.AbstractErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.util.ArrayList;
import java.util.List;

public final class ErrorReporterImpl
extends AbstractErrorReporter {
    private final List<SoyError> errors = new ArrayList<SoyError>();
    private final SoyError.Factory errorFactory;

    public ErrorReporterImpl(SoyError.Factory defaultFactory) {
        this.errorFactory = defaultFactory;
    }

    @Override
    public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        this.errors.add(this.errorFactory.create(sourceLocation, error, args));
    }

    public Iterable<SoyError> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    protected int getCurrentNumberOfErrors() {
        return this.errors.size();
    }
}

