/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.ordainers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import java.util.regex.Pattern;

public final class JsIdentifierOrdainer {
    private static final Pattern VALID_JS_IDENTIFIER_PATTERN = Pattern.compile("^[$_\\p{IsLetter}][$_\\p{IsLetter}\\p{IsDigit}]*$", 256);
    private static final ImmutableSet<String> INVALID_JS_IDENTIFIERS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"catch", (Object)"continue", (Object)"debugger", (Object)"default", (Object[])new String[]{"delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "NaN", "Infinity", "undefined", "eval", "arguments", "int", "byte", "char", "goto", "long", "final", "float", "short", "double", "native", "throws", "boolean", "abstract", "volatile", "transient", "synchronized", "prototype", "__proto__"});

    private JsIdentifierOrdainer() {
    }

    public static SanitizedContent jsIdentifier(String identifier) {
        Preconditions.checkArgument((boolean)VALID_JS_IDENTIFIER_PATTERN.matcher(identifier).matches(), (String)"JS identifier '%s' should match the pattern '%s'", (Object)identifier, (Object)VALID_JS_IDENTIFIER_PATTERN.pattern());
        Preconditions.checkArgument((!INVALID_JS_IDENTIFIERS.contains((Object)identifier) ? 1 : 0) != 0, (String)"JS identifier '%s' should not be a reserved word or match a literal", (Object)identifier);
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(identifier, SanitizedContent.ContentKind.JS);
    }
}

