/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.AutoValue_Identifier;
import com.google.template.soy.base.internal.BaseUtils;

public abstract class Identifier {
    public static Identifier create(String identifier, SourceLocation location) {
        Type type;
        Preconditions.checkArgument((!identifier.isEmpty() ? 1 : 0) != 0);
        int dotIndex = identifier.indexOf(46);
        if (dotIndex == 0) {
            type = Type.DOT_IDENT;
            Preconditions.checkArgument((boolean)BaseUtils.isIdentifierWithLeadingDot(identifier));
        } else {
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(identifier));
            type = dotIndex == -1 ? Type.SINGLE_IDENT : Type.DOTTED_IDENT;
        }
        return new AutoValue_Identifier(identifier, location, type);
    }

    public abstract String identifier();

    public abstract SourceLocation location();

    public abstract Type type();

    public static enum Type {
        SINGLE_IDENT,
        DOT_IDENT,
        DOTTED_IDENT;

    }
}

