/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soyparse.SoyFileParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SoyUtils {
    private static final SoyErrorKind INVALID_FORMAT = SoyErrorKind.of("Invalid globals line format ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VALUE = SoyErrorKind.of("Invalid global value ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NON_PRIMITIVE_VALUE = SoyErrorKind.of("Non-primitive global value ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final Pattern COMPILE_TIME_GLOBAL_LINE = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9.]*) \\s* = \\s* (.+)", 4);

    private SoyUtils() {
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> compileTimeGlobalsMap, Appendable output) throws IOException {
        ImmutableMap<String, PrimitiveData> compileTimeGlobals = InternalValueUtils.convertCompileTimeGlobalsMap(compileTimeGlobalsMap);
        for (Map.Entry entry : compileTimeGlobals.entrySet()) {
            String valueSrcStr = InternalValueUtils.convertPrimitiveDataToExpr((PrimitiveData)entry.getValue(), SourceLocation.UNKNOWN).toSourceString();
            output.append((CharSequence)entry.getKey()).append(" = ").append(valueSrcStr).append("\n");
        }
    }

    public static ImmutableMap<String, PrimitiveData> parseCompileTimeGlobals(CharSource inputSource) throws IOException {
        ImmutableMap.Builder compileTimeGlobalsBuilder = ImmutableMap.builder();
        ErrorReporter errorReporter = ExplodingErrorReporter.get();
        try (BufferedReader reader = new BufferedReader(inputSource.openStream());){
            int lineNum = 1;
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("//") && line.trim().length() != 0) {
                    SourceLocation sourceLocation = new SourceLocation("globals", lineNum, 1, lineNum, 1);
                    Matcher matcher = COMPILE_TIME_GLOBAL_LINE.matcher(line);
                    if (!matcher.matches()) {
                        errorReporter.report(sourceLocation, INVALID_FORMAT, line);
                    } else {
                        String name = matcher.group(1);
                        String valueText = matcher.group(2).trim();
                        ExprNode valueExpr = SoyFileParser.parseExprOrDie(valueText);
                        if (!(valueExpr instanceof ExprNode.PrimitiveNode)) {
                            if (valueExpr instanceof GlobalNode || valueExpr instanceof VarRefNode) {
                                errorReporter.report(sourceLocation, INVALID_VALUE, valueExpr.toSourceString());
                            } else {
                                errorReporter.report(sourceLocation, NON_PRIMITIVE_VALUE, valueExpr.toSourceString());
                            }
                        } else {
                            compileTimeGlobalsBuilder.put((Object)name, (Object)InternalValueUtils.convertPrimitiveExprToData((ExprNode.PrimitiveNode)valueExpr));
                        }
                    }
                }
                line = reader.readLine();
                ++lineNum;
            }
        }
        return compileTimeGlobalsBuilder.build();
    }
}

