/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.CaseFormat;
import com.google.protobuf.Descriptors;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.SafeStringTypes;

public final class Protos {
    private Protos() {
    }

    public static boolean isSanitizedContentField(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && SafeStringTypes.SAFE_PROTO_TO_SANITIZED_TYPE.containsKey((Object)fieldDescriptor.getMessageType().getFullName());
    }

    public static String getTofuExtensionImport(Descriptors.FieldDescriptor desc) {
        String extensionFieldName = JavaQualifiedNames.getFieldName(desc, false);
        String extensionFieldHolderClassName = desc.getExtensionScope() != null ? JavaQualifiedNames.getQualifiedName(desc.getExtensionScope()) : JavaQualifiedNames.getPackage(desc.getFile()) + "." + JavaQualifiedNames.getOuterClassname(desc.getFile());
        return extensionFieldHolderClassName + "." + extensionFieldName + ".getDescriptor()";
    }

    public static String getJsExtensionImport(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            while (scope.getContainingType() != null) {
                scope = scope.getContainingType();
            }
            return Protos.calculateQualifiedJsName((Descriptors.GenericDescriptor)scope);
        }
        return Protos.getJsPackage(desc.getFile()) + "." + Protos.computeJsExtensionName(desc);
    }

    public static String getJsExtensionName(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            return Protos.calculateQualifiedJsName((Descriptors.GenericDescriptor)scope) + "." + Protos.computeJsExtensionName(desc);
        }
        return Protos.getJsPackage(desc.getFile()) + "." + Protos.computeJsExtensionName(desc);
    }

    private static String computeJsExtensionName(Descriptors.FieldDescriptor field) {
        String name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName());
        return field.isRepeated() ? name + "List" : name;
    }

    private static String getJsPackage(Descriptors.FileDescriptor file) {
        String protoPackage = file.getPackage();
        if (!protoPackage.isEmpty()) {
            return "proto." + protoPackage;
        }
        return "proto";
    }

    static boolean shouldJsIgnoreField(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    static boolean hasJsMapKey(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    static String getJsMapKeyFieldName(Descriptors.FieldDescriptor fieldDescriptor) {
        return null;
    }

    public static boolean hasJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    public static JsType getJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        return null;
    }

    static String calculateJsEnumName(Descriptors.EnumDescriptor descriptor) {
        return Protos.calculateQualifiedJsName((Descriptors.GenericDescriptor)descriptor);
    }

    static String calculateQualifiedJsName(Descriptors.GenericDescriptor descriptor) {
        String protoPackage = descriptor.getFile().getPackage();
        String name = descriptor.getFullName();
        if (!name.startsWith(protoPackage)) {
            throw new AssertionError((Object)("Expected \"" + name + "\" to start with \"" + protoPackage + "\""));
        }
        String jsPackage = Protos.getJsPackage(descriptor.getFile());
        if (protoPackage.isEmpty()) {
            return jsPackage + "." + name;
        }
        return jsPackage + name.substring(protoPackage.length());
    }

    public static enum JsType {
        INT52,
        NUMBER,
        STRING;

    }
}

