/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.StrictHtmlMode;
import com.google.template.soy.soytree.Visibility;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;

public final class CommandTagAttribute {
    private static final SoyErrorKind DUPLICATE_ATTRIBUTE = SoyErrorKind.of("Attribute was already specified.");
    static final SoyErrorKind UNSUPPORTED_ATTRIBUTE_KEY = SoyErrorKind.of("Unsupported attribute ''{0}'', expected one of {1}.");
    private static final SoyErrorKind INVALID_ATTRIBUTE = SoyErrorKind.of("Invalid attribute value, expected one of {1}.");
    private static final SoyErrorKind INVALID_REQUIRE_CSS_ATTRIBUTE = SoyErrorKind.of("Invalid required CSS namespace name ''{0}'', expected an identifier.");
    private static final SoyErrorKind INVALID_CSS_BASE_NAMESPACE_NAME = SoyErrorKind.of("Invalid CSS base namespace name ''{0}''");
    private final SourceLocation valueLocation;
    private final Identifier key;
    private final String value;

    public static void removeDuplicatesAndReportErrors(Iterable<CommandTagAttribute> attrs, ErrorReporter errorReporter) {
        HashSet<String> seenAttributes = new HashSet<String>();
        Iterator<CommandTagAttribute> iterator = attrs.iterator();
        while (iterator.hasNext()) {
            CommandTagAttribute attr = iterator.next();
            Identifier name = attr.getName();
            if (seenAttributes.add(name.identifier())) continue;
            errorReporter.report(name.location(), DUPLICATE_ATTRIBUTE, new Object[0]);
            iterator.remove();
        }
    }

    public CommandTagAttribute(Identifier key, String value, SourceLocation valueLocation) {
        Preconditions.checkArgument((key.type() == Identifier.Type.SINGLE_IDENT ? 1 : 0) != 0, (String)"expected a single identifier, got: %s", (Object)key);
        this.key = (Identifier)Preconditions.checkNotNull((Object)key);
        this.value = (String)Preconditions.checkNotNull((Object)value);
        this.valueLocation = (SourceLocation)Preconditions.checkNotNull((Object)valueLocation);
    }

    public Identifier getName() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    SourceLocation getValueLocation() {
        return this.valueLocation;
    }

    boolean valueAsBoolean(ErrorReporter errorReporter, boolean defaultValue) {
        if ("true".equals(this.value)) {
            return true;
        }
        if ("false".equals(this.value)) {
            return false;
        }
        errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), ImmutableList.of((Object)"true", (Object)"false"));
        return defaultValue;
    }

    StrictHtmlMode valueAsStrictHtmlMode(ErrorReporter errorReporter) {
        if ("true".equals(this.value)) {
            return StrictHtmlMode.YES;
        }
        if ("false".equals(this.value)) {
            return StrictHtmlMode.NO;
        }
        errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), ImmutableList.of((Object)"true", (Object)"false"));
        return StrictHtmlMode.UNSET;
    }

    ImmutableList<String> valueAsRequireCss(ErrorReporter errorReporter) {
        Object[] namespaces = this.value.trim().split("\\s*,\\s*");
        boolean hasError = false;
        for (String string : namespaces) {
            if (BaseUtils.isDottedIdentifier(string)) continue;
            errorReporter.report(this.valueLocation, INVALID_REQUIRE_CSS_ATTRIBUTE, string);
            hasError = true;
        }
        return hasError ? ImmutableList.of() : ImmutableList.copyOf((Object[])namespaces);
    }

    AutoescapeMode valueAsAutoescapeMode(ErrorReporter errorReporter) {
        AutoescapeMode mode = AutoescapeMode.forAttributeValue(this.value);
        if (mode == null) {
            mode = AutoescapeMode.STRICT;
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), ImmutableList.copyOf(AutoescapeMode.getAttributeValues()));
        }
        return mode;
    }

    @Nullable
    Visibility valueAsVisibility(ErrorReporter errorReporter) {
        Visibility visibility = Visibility.forAttributeValue(this.value);
        if (visibility == null) {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), ImmutableList.copyOf(Visibility.getAttributeValues()));
        }
        return visibility;
    }

    @Nullable
    SanitizedContent.ContentKind valueAsContentKind(ErrorReporter errorReporter) {
        SanitizedContent.ContentKind contentKind = NodeContentKinds.forAttributeValue(this.value);
        if (contentKind == null) {
            errorReporter.report(this.valueLocation, INVALID_ATTRIBUTE, this.key.identifier(), ImmutableList.copyOf(NodeContentKinds.getAttributeValues()));
        }
        return contentKind;
    }

    String valueAsCssBase(ErrorReporter errorReporter) {
        if (!BaseUtils.isDottedIdentifier(this.value)) {
            errorReporter.report(this.valueLocation, INVALID_CSS_BASE_NAMESPACE_NAME, this.value);
        }
        return this.value;
    }

    public String toString() {
        return this.key.identifier() + "=\"" + this.value.replace("\"", "\\\"") + "\"";
    }
}

