/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.GenPyCodeVisitor;
import com.google.template.soy.pysrc.internal.PyApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;

public final class PySrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<GenPyCodeVisitor> genPyCodeVisitorProvider;

    @Inject
    public PySrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, SimplifyVisitor simplifyVisitor, Provider<GenPyCodeVisitor> genPyCodeVisitorProvider) {
        this.apiCallScope = apiCallScope;
        this.simplifyVisitor = simplifyVisitor;
        this.genPyCodeVisitorProvider = genPyCodeVisitorProvider;
    }

    public List<String> genPySrc(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyPySrcOptions pySrcOptions, ImmutableMap<String, String> currentManifest, ErrorReporter errorReporter) throws SoySyntaxException {
        try (GuiceSimpleScope.WithScope withScope = this.apiCallScope.enter();){
            this.apiCallScope.seed(SoyPySrcOptions.class, pySrcOptions);
            this.apiCallScope.seed(new Key<ImmutableMap<String, String>>(PyApiCallScopeBindingAnnotations.PyCurrentManifest.class){}, currentManifest);
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromPyOptions(pySrcOptions.getBidiIsRtlFn());
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, null, bidiGlobalDir);
            this.simplifyVisitor.simplify(soyTree, templateRegistry);
            List<String> list = ((GenPyCodeVisitor)this.genPyCodeVisitorProvider.get()).gen(soyTree, errorReporter);
            return list;
        }
    }

    public void genPyFiles(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyPySrcOptions pySrcOptions, String outputPathFormat, String inputPathsPrefix, ErrorReporter errorReporter) throws SoySyntaxException, IOException {
        Throwable throwable;
        BufferedWriter out;
        ImmutableList srcsToCompile = ImmutableList.copyOf((Iterable)Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        List<String> soyNamespaces = this.getSoyNamespaces(soyTree);
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(null, outputPathFormat, inputPathsPrefix, (ImmutableList<SoyFileNode>)srcsToCompile);
        ImmutableMap<String, String> manifest = PySrcMain.generateManifest(soyNamespaces, outputs);
        List<String> pyFileContents = this.genPySrc(soyTree, templateRegistry, pySrcOptions, manifest, errorReporter);
        if (srcsToCompile.size() != pyFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), pyFileContents.size()));
        }
        for (String outputFilePath : outputs.keySet()) {
            out = Files.newWriter((File)new File(outputFilePath), (Charset)StandardCharsets.UTF_8);
            throwable = null;
            try {
                Iterator i$ = outputs.get((Object)outputFilePath).iterator();
                while (i$.hasNext()) {
                    int inputFileIndex = (Integer)i$.next();
                    out.write(pyFileContents.get(inputFileIndex));
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((Writer)out).close();
            }
        }
        if (pySrcOptions.doesOutputNamespaceManifest()) {
            String manifestFormat = outputPathFormat.replace(".py", ".MF");
            String manifestPath = MainEntryPointUtils.buildFilePath(manifestFormat, null, "manifest", "");
            out = Files.newWriter((File)new File(manifestPath), (Charset)StandardCharsets.UTF_8);
            throwable = null;
            try {
                Properties prop = new Properties();
                for (String namespace : manifest.keySet()) {
                    prop.put(namespace, manifest.get((Object)namespace));
                }
                prop.store(out, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)out).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ((Writer)out).close();
                    }
                }
            }
        }
    }

    private static ImmutableMap<String, String> generateManifest(List<String> soyNamespaces, Multimap<String, Integer> outputs) {
        ImmutableMap.Builder manifest = new ImmutableMap.Builder();
        for (String outputFilePath : outputs.keySet()) {
            Iterator i$ = outputs.get((Object)outputFilePath).iterator();
            while (i$.hasNext()) {
                int inputFileIndex = (Integer)i$.next();
                String pythonPath = outputFilePath.replace(".py", "").replace('/', '.');
                manifest.put((Object)soyNamespaces.get(inputFileIndex), (Object)pythonPath);
            }
        }
        return manifest.build();
    }

    private List<String> getSoyNamespaces(SoyFileSetNode soyTree) {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            namespaces.add(soyFile.getNamespace());
        }
        return namespaces;
    }
}

