/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;

final class RewriteFunctionsPass
extends CompilerFilePass {
    private final SoyTypeRegistry typeRegistry;

    RewriteFunctionsPass(SoyTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (FunctionNode fnNode : SoyTreeUtils.getAllNodesOfType(file, FunctionNode.class)) {
            SoyType type;
            if (fnNode.numChildren() > 0 || (type = this.typeRegistry.getType(fnNode.getFunctionName())) == null || type.getKind() != SoyType.Kind.PROTO) continue;
            ProtoInitNode pNode = new ProtoInitNode(fnNode.getFunctionName(), (Iterable<String>)ImmutableList.of(), fnNode.getSourceLocation());
            fnNode.getParent().replaceChild(fnNode, pNode);
        }
    }
}

