/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@VisibleForTesting
public final class HtmlRewritePass
extends CompilerFilePass {
    private static final boolean DEBUG = false;
    private static final SoyErrorKind BLOCK_CHANGES_CONTEXT = SoyErrorKind.of("{0} changes context from ''{1}'' to ''{2}''.{3}");
    private static final SoyErrorKind BLOCK_ENDS_IN_INVALID_STATE = SoyErrorKind.of("''{0}'' block ends in an invalid state ''{1}''");
    private static final SoyErrorKind CONDITIONAL_BLOCK_ISNT_GUARANTEED_TO_PRODUCE_ONE_ATTRIBUTE_VALUE = SoyErrorKind.of("expected exactly one attribute value, the {0} isn''t guaranteed to produce exactly one");
    private static final SoyErrorKind EXPECTED_ATTRIBUTE_VALUE = SoyErrorKind.of("expected an attribute value");
    private static final SoyErrorKind EXPECTED_WS_EQ_OR_CLOSE_AFTER_ATTRIBUTE_NAME = SoyErrorKind.of("expected whitespace, ''='' or tag close after a attribute name");
    private static final SoyErrorKind EXPECTED_WS_OR_CLOSE_AFTER_TAG_OR_ATTRIBUTE = SoyErrorKind.of("expected whitespace or tag close after a tag name or attribute");
    private static final SoyErrorKind FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK = SoyErrorKind.of("found the end of an html attribute that was started in another block. Html attributes should be opened and closed in the same block");
    private static final SoyErrorKind FOUND_END_TAG_STARTED_IN_ANOTHER_BLOCK = SoyErrorKind.of("found the end of a tag that was started in another block. Html tags should be opened and closed in the same block");
    private static final SoyErrorKind GENERIC_UNEXPECTED_CHAR = SoyErrorKind.of("unexpected character, expected ''{0}'' instead");
    private static final SoyErrorKind ILLEGAL_HTML_ATTRIBUTE_CHARACTER = SoyErrorKind.of("illegal unquoted attribute value character");
    private static final SoyErrorKind INVALID_IDENTIFIER = SoyErrorKind.of("invalid html identifier, ''{0}'' is an illegal character");
    private static final SoyErrorKind INVALID_LOCATION_FOR_CONTROL_FLOW = SoyErrorKind.of("invalid location for a ''{0}'' node, {1}");
    private static final SoyErrorKind INVALID_LOCATION_FOR_NONPRINTABLE = SoyErrorKind.of("invalid location for a non-printable node: {0}");
    private static final SoyErrorKind INVALID_TAG_NAME = SoyErrorKind.of("tag names may only be raw text or print nodes, consider extracting a '''{'let...'' variable");
    private static final SoyErrorKind SELF_CLOSING_CLOSE_TAG = SoyErrorKind.of("close tags should not be self closing");
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG_CONTENT = SoyErrorKind.of("unexpected close tag content, only whitespace is allowed in close tags");
    private static final SoyErrorKind UNEXPECTED_WS_AFTER_LT = SoyErrorKind.of("unexpected whitespace after ''<'', did you mean ''&lt;''?");
    private final ErrorReporter errorReporter;
    private final boolean enabled;

    @VisibleForTesting
    public HtmlRewritePass(ImmutableList<String> experimentalFeatures, ErrorReporter errorReporter) {
        this.enabled = experimentalFeatures.contains((Object)"stricthtml");
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        if (this.enabled) {
            new Visitor(nodeIdGen, file.getFilePath(), this.errorReporter).exec(file);
        }
    }

    private static final class ParsingContext {
        final String filePath;
        final IdGenerator nodeIdGen;
        final ErrorReporter errorReporter;
        final AstEdits edits;
        State state;
        SourceLocation.Point stateTransitionPoint;
        boolean isCloseTag;
        SourceLocation.Point tagStartPoint;
        RawTextNode tagStartNode;
        TagName tagName;
        final List<SoyNode.StandaloneNode> directTagChildren = new ArrayList<SoyNode.StandaloneNode>();
        SoyNode.StandaloneNode attributeName;
        SourceLocation.Point equalsSignLocation;
        SoyNode.StandaloneNode attributeValue;
        SourceLocation.Point quotedAttributeValueStart;
        final List<SoyNode.StandaloneNode> attributeValueChildren = new ArrayList<SoyNode.StandaloneNode>();

        ParsingContext(State startingState, SourceLocation.Point startPoint, String filePath, AstEdits edits, ErrorReporter errorReporter, IdGenerator nodeIdGen) {
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)startingState)));
            this.stateTransitionPoint = (SourceLocation.Point)Preconditions.checkNotNull((Object)startPoint);
            this.filePath = (String)Preconditions.checkNotNull((Object)filePath);
            this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
            this.edits = (AstEdits)Preconditions.checkNotNull((Object)edits);
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        }

        void reparentAttributeValueChildren(SoyNode.BlockNode parent) {
            this.edits.addChildren(parent, this.attributeValueChildren);
            this.attributeValueChildren.clear();
        }

        void reparentDirectTagChildren(SoyNode.BlockNode parent) {
            this.edits.addChildren(parent, this.directTagChildren);
            this.directTagChildren.clear();
        }

        void reparentAttributeParts(SoyNode.BlockNode parent) {
            this.edits.addChild(parent, (SoyNode.StandaloneNode)Preconditions.checkNotNull((Object)this.attributeValue));
            this.attributeValue = null;
        }

        boolean hasUnquotedAttributeValueParts() {
            return this.quotedAttributeValueStart == null && !this.attributeValueChildren.isEmpty();
        }

        boolean hasQuotedAttributeValueParts() {
            return this.quotedAttributeValueStart != null;
        }

        boolean hasAttributePartsForValue() {
            return this.attributeName != null && this.equalsSignLocation != null;
        }

        boolean hasAttributePartsWithValue() {
            return this.attributeName != null && this.attributeValue != null;
        }

        boolean hasTagStart() {
            return this.tagStartNode != null && this.tagStartPoint != null;
        }

        void addTagChild(SoyNode.StandaloneNode node) {
            Preconditions.checkNotNull((Object)node);
            this.directTagChildren.add(node);
            this.edits.remove(node);
        }

        void checkEmpty(String fmt, Object ... args) {
            StringBuilder error = null;
            if (!this.directTagChildren.isEmpty()) {
                error = ParsingContext.format(error, "Expected directTagChildren to be empty, got: %s", this.directTagChildren);
            }
            if (this.attributeName != null) {
                error = ParsingContext.format(error, "Expected attributeName to be null, got: %s", this.attributeName);
            }
            if (this.attributeValue != null) {
                error = ParsingContext.format(error, "Expected attributeValue to be null, got: %s", this.attributeValue);
            }
            if (!this.attributeValueChildren.isEmpty()) {
                error = ParsingContext.format(error, "Expected attributeValueChildren to be empty, got: %s", this.attributeValueChildren);
            }
            if (this.tagStartPoint != null) {
                error = ParsingContext.format(error, "Expected tagStartPoint to be null, got: %s", this.tagStartPoint);
            }
            if (this.tagName != null) {
                error = ParsingContext.format(error, "Expected tagName to be null, got: %s", this.tagName);
            }
            if (this.tagStartNode != null) {
                error = ParsingContext.format(error, "Expected tagStartNode to be null, got: %s", this.tagStartNode);
            }
            if (this.quotedAttributeValueStart != null) {
                error = ParsingContext.format(error, "Expected quotedAttributeValueStart to be null, got: %s", this.quotedAttributeValueStart);
            }
            if (this.tagName != null) {
                error = ParsingContext.format(error, "Expected tagName to be null, got: %s", this.tagName);
            }
            if (error != null) {
                throw new IllegalStateException(String.format(fmt + "\n", args) + error);
            }
        }

        private static StringBuilder format(StringBuilder error, String fmt, Object ... args) {
            if (error == null) {
                error = new StringBuilder();
            }
            error.append(String.format(fmt, args));
            error.append('\n');
            return error;
        }

        void reset() {
            this.tagStartPoint = null;
            this.tagStartNode = null;
            this.tagName = null;
            this.directTagChildren.clear();
            this.resetAttribute();
            this.resetAttributeValue();
        }

        void resetAttribute() {
            this.attributeName = null;
            this.equalsSignLocation = null;
            this.attributeValue = null;
        }

        void resetAttributeValue() {
            this.quotedAttributeValueStart = null;
            this.attributeValueChildren.clear();
        }

        void startTag(RawTextNode tagStartNode, boolean isCloseTag, SourceLocation.Point point) {
            Preconditions.checkState((this.tagStartPoint == null ? 1 : 0) != 0);
            Preconditions.checkState((this.tagStartNode == null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.directTagChildren.isEmpty());
            this.tagStartPoint = (SourceLocation.Point)Preconditions.checkNotNull((Object)point);
            this.tagStartNode = (RawTextNode)Preconditions.checkNotNull((Object)tagStartNode);
            this.isCloseTag = isCloseTag;
        }

        SourceLocation tagStartLocation() {
            return this.tagStartPoint.asLocation(this.filePath);
        }

        void setTagName(TagName tagName) {
            Preconditions.checkState((this.tagStartPoint != null ? 1 : 0) != 0);
            this.tagName = (TagName)Preconditions.checkNotNull((Object)tagName);
        }

        void setAttributeName(SoyNode.StandaloneNode node) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkState((this.attributeName == null ? 1 : 0) != 0);
            this.edits.remove(node);
            this.attributeName = node;
        }

        void setEqualsSignLocation(SourceLocation.Point location) {
            Preconditions.checkNotNull((Object)location);
            Preconditions.checkState((this.equalsSignLocation == null ? 1 : 0) != 0);
            this.equalsSignLocation = location;
        }

        void setAttributeValue(SoyNode.StandaloneNode node) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkState((this.attributeValue == null ? 1 : 0) != 0);
            this.edits.remove(node);
            this.attributeValue = node;
        }

        void startQuotedAttributeValue(RawTextNode node, SourceLocation.Point point) {
            Preconditions.checkState((this.quotedAttributeValueStart == null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.attributeValueChildren.isEmpty());
            this.edits.remove(node);
            this.quotedAttributeValueStart = (SourceLocation.Point)Preconditions.checkNotNull((Object)point);
        }

        void addAttributeValuePart(SoyNode.StandaloneNode node) {
            this.attributeValueChildren.add(node);
            this.edits.remove(node);
        }

        void createUnquotedAttributeValue() {
            HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode(this.nodeIdGen.genId(), ParsingContext.getLocationOf(this.attributeValueChildren), HtmlAttributeValueNode.Quotes.NONE);
            this.edits.addChildren(valueNode, this.attributeValueChildren);
            this.attributeValueChildren.clear();
            this.setAttributeValue(valueNode);
        }

        void createQuotedAttributeValue(RawTextNode end, boolean doubleQuoted, SourceLocation.Point endPoint) {
            HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode(this.nodeIdGen.genId(), new SourceLocation(this.filePath, this.quotedAttributeValueStart, endPoint), doubleQuoted ? HtmlAttributeValueNode.Quotes.DOUBLE : HtmlAttributeValueNode.Quotes.SINGLE);
            this.edits.remove(end);
            this.edits.addChildren(valueNode, this.attributeValueChildren);
            this.attributeValueChildren.clear();
            this.quotedAttributeValueStart = null;
            this.setAttributeValue(valueNode);
        }

        void createAttributeNode() {
            HtmlAttributeNode attribute;
            SourceLocation location = this.attributeName.getSourceLocation();
            if (this.attributeValue != null) {
                attribute = new HtmlAttributeNode(this.nodeIdGen.genId(), location, (SourceLocation.Point)Preconditions.checkNotNull((Object)this.equalsSignLocation));
                location = location.extend(this.attributeValue.getSourceLocation());
                this.edits.addChild(attribute, this.attributeName);
                this.edits.addChild(attribute, this.attributeValue);
            } else {
                attribute = new HtmlAttributeNode(this.nodeIdGen.genId(), location, null);
                this.edits.addChild(attribute, this.attributeName);
            }
            this.attributeName = null;
            this.equalsSignLocation = null;
            this.attributeValue = null;
            this.directTagChildren.add(attribute);
        }

        State createTag(RawTextNode tagEndNode, boolean selfClosing, SourceLocation.Point endPoint) {
            TagName.SpecialTagName specialTag;
            AbstractParentSoyNode replacement;
            SourceLocation sourceLocation = new SourceLocation(this.filePath, this.tagStartPoint, endPoint);
            if (this.isCloseTag) {
                if (!this.directTagChildren.isEmpty()) {
                    this.errorReporter.report(this.directTagChildren.get(0).getSourceLocation(), UNEXPECTED_CLOSE_TAG_CONTENT, new Object[0]);
                }
                if (selfClosing) {
                    this.errorReporter.report(endPoint.asLocation(this.filePath).offsetStartCol(-1), SELF_CLOSING_CLOSE_TAG, new Object[0]);
                }
                replacement = new HtmlCloseTagNode(this.nodeIdGen.genId(), this.tagName, sourceLocation);
            } else {
                replacement = new HtmlOpenTagNode(this.nodeIdGen.genId(), this.tagName, sourceLocation, selfClosing);
            }
            State nextState = State.PCDATA;
            if (!selfClosing && !this.isCloseTag && (specialTag = this.tagName.getSpecialTagName()) != null) {
                switch (specialTag) {
                    case SCRIPT: {
                        nextState = State.RCDATA_SCRIPT;
                        break;
                    }
                    case STYLE: {
                        nextState = State.RCDATA_STYLE;
                        break;
                    }
                    case TEXTAREA: {
                        nextState = State.RCDATA_TEXTAREA;
                        break;
                    }
                    case TITLE: {
                        nextState = State.RCDATA_TITLE;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)specialTag);
                    }
                }
            }
            this.edits.remove(tagEndNode);
            this.edits.addChildren((SoyNode.BlockNode)((Object)replacement), (Iterable<SoyNode.StandaloneNode>)this.directTagChildren);
            this.edits.replace((SoyNode.StandaloneNode)this.tagStartNode, (SoyNode.StandaloneNode)((Object)replacement));
            this.directTagChildren.clear();
            this.tagStartPoint = null;
            this.tagName = null;
            this.tagStartNode = null;
            this.checkEmpty("Expected state to be empty after completing a tag", new Object[0]);
            return nextState;
        }

        State setState(State s, SourceLocation.Point point) {
            State old = this.state;
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)s)));
            this.stateTransitionPoint = (SourceLocation.Point)Preconditions.checkNotNull((Object)point);
            return old;
        }

        State getState() {
            Preconditions.checkState((this.state != null ? 1 : 0) != 0);
            return this.state;
        }

        SourceLocation.Point getStateTransitionPoint() {
            Preconditions.checkState((this.stateTransitionPoint != null ? 1 : 0) != 0);
            return this.stateTransitionPoint;
        }

        static SourceLocation getLocationOf(List<SoyNode.StandaloneNode> nodes) {
            SourceLocation location = nodes.get(0).getSourceLocation();
            if (nodes.size() > 1) {
                location = location.extend(((SoyNode.StandaloneNode)Iterables.getLast(nodes)).getSourceLocation());
            }
            return location;
        }
    }

    private static final class AstEdits {
        final Set<SoyNode.StandaloneNode> toRemove = new LinkedHashSet<SoyNode.StandaloneNode>();
        final ListMultimap<SoyNode.StandaloneNode, SoyNode.StandaloneNode> replacements = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        final ListMultimap<SoyNode.BlockNode, SoyNode.StandaloneNode> newChildren = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        private AstEdits() {
        }

        void apply() {
            for (SoyNode.StandaloneNode standaloneNode : this.toRemove) {
                SoyNode.BlockNode parent = standaloneNode.getParent();
                List children = this.replacements.get((Object)standaloneNode);
                if (!children.isEmpty()) {
                    parent.addChildren(parent.getChildIndex(standaloneNode), children);
                }
                parent.removeChild(standaloneNode);
            }
            for (Map.Entry entry : Multimaps.asMap(this.newChildren).entrySet()) {
                ((SoyNode.BlockNode)entry.getKey()).addChildren((List)entry.getValue());
            }
            this.clear();
        }

        void remove(SoyNode.StandaloneNode node) {
            Preconditions.checkNotNull((Object)node);
            if (node.getParent() != null) {
                this.toRemove.add(node);
            }
        }

        void addChildren(SoyNode.BlockNode parent, Iterable<SoyNode.StandaloneNode> children) {
            Preconditions.checkNotNull((Object)parent);
            this.newChildren.putAll((Object)parent, children);
        }

        void addChild(SoyNode.BlockNode parent, SoyNode.StandaloneNode child) {
            Preconditions.checkNotNull((Object)parent);
            Preconditions.checkNotNull((Object)child);
            this.newChildren.put((Object)parent, (Object)child);
        }

        void replace(SoyNode.StandaloneNode oldNode, Iterable<SoyNode.StandaloneNode> newNodes) {
            Preconditions.checkState((oldNode.getParent() != null ? 1 : 0) != 0, (Object)"oldNode must be in the tree in order to replace it");
            this.remove(oldNode);
            this.replacements.putAll((Object)oldNode, newNodes);
        }

        void replace(SoyNode.StandaloneNode oldNode, SoyNode.StandaloneNode newNode) {
            this.replace(oldNode, (Iterable<SoyNode.StandaloneNode>)ImmutableList.of((Object)newNode));
        }

        void clear() {
            this.toRemove.clear();
            this.replacements.clear();
            this.newChildren.clear();
        }
    }

    private static final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        static final CharMatcher NAME_START_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)":_").or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'\u00c0', (char)'\u00d6')).or(CharMatcher.inRange((char)'\u00d8', (char)'\u00f6')).or(CharMatcher.inRange((char)'\u00f8', (char)'\u02ff')).or(CharMatcher.inRange((char)'\u0370', (char)'\u037d')).or(CharMatcher.inRange((char)'\u037f', (char)'\u1fff')).or(CharMatcher.inRange((char)'\u200c', (char)'\u200d')).or(CharMatcher.inRange((char)'\u2070', (char)'\u218f')).or(CharMatcher.inRange((char)'\u2c00', (char)'\u2fef')).or(CharMatcher.inRange((char)'\u3001', (char)'\ud7ff')).or(CharMatcher.inRange((char)'\uf900', (char)'\ufdcf')).or(CharMatcher.inRange((char)'\ufdf0', (char)'\ufffd')).precomputed();
        static final CharMatcher NAME_PART_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)".-\u00b7").or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.inRange((char)'\u0300', (char)'\u036f')).or(CharMatcher.inRange((char)'\u203f', (char)'\u2040')).or(NAME_START_CHAR_MATCHER).precomputed();
        static final CharMatcher BAD_UNQUOTED_ATTRIBUTE_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"\"'`=<> \t\r\n").precomputed();
        static final CharMatcher TAG_RAW_TEXT_MATCHER = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)">='\"/")).negate().precomputed();
        static final CharMatcher NOT_DOUBLE_QUOTE = CharMatcher.isNot((char)'\"').precomputed();
        static final CharMatcher NOT_SINGLE_QUOTE = CharMatcher.isNot((char)'\'').precomputed();
        static final CharMatcher NOT_LT = CharMatcher.isNot((char)'<').precomputed();
        static final CharMatcher NOT_RSQUARE_BRACE = CharMatcher.isNot((char)']').precomputed();
        static final CharMatcher NOT_HYPHEN = CharMatcher.isNot((char)'-').precomputed();
        static final CharMatcher XML_DECLARATION_NON_DELIMITERS = CharMatcher.noneOf((CharSequence)">\"'").precomputed();
        final IdGenerator nodeIdGen;
        final String filePath;
        final AstEdits edits = new AstEdits();
        final ErrorReporter errorReporter;
        RawTextNode currentRawTextNode;
        String currentRawText;
        int currentRawTextOffset;
        int currentRawTextIndex;
        ParsingContext context;

        static int indexOfInvalidNameCharacter(String name) {
            if (!NAME_START_CHAR_MATCHER.matches(name.charAt(0))) {
                return 0;
            }
            for (int i = 1; i < name.length(); ++i) {
                if (NAME_PART_CHAR_MATCHER.matches(name.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        Visitor(IdGenerator nodeIdGen, String filePath, ErrorReporter errorReporter) {
            this.nodeIdGen = nodeIdGen;
            this.filePath = filePath;
            this.errorReporter = errorReporter;
        }

        @Override
        protected void visitRawTextNode(RawTextNode node) {
            this.currentRawTextNode = node;
            this.currentRawText = node.getRawText();
            this.currentRawTextOffset = 0;
            this.currentRawTextIndex = 0;
            while (this.currentRawTextIndex < this.currentRawText.length()) {
                int startIndex = this.currentRawTextIndex;
                State startState = this.context.getState();
                switch (startState) {
                    case NONE: {
                        this.currentRawTextIndex = this.currentRawTextOffset = this.currentRawText.length();
                        break;
                    }
                    case PCDATA: {
                        this.handlePcData();
                        break;
                    }
                    case DOUBLE_QUOTED_ATTRIBUTE_VALUE: {
                        this.handleQuotedAttributeValue(true);
                        break;
                    }
                    case SINGLE_QUOTED_ATTRIBUTE_VALUE: {
                        this.handleQuotedAttributeValue(false);
                        break;
                    }
                    case AFTER_QUOTED_ATTRIBUTE_VALUE: {
                        this.handleAfterQuotedAttributeValue(this.currentPoint());
                        break;
                    }
                    case BEFORE_ATTRIBUTE_VALUE: {
                        this.handleBeforeAttributeValue();
                        break;
                    }
                    case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                        this.handleAfterTagNameOrAttribute();
                        break;
                    }
                    case BEFORE_ATTRIBUTE_NAME: {
                        this.handleBeforeAttributeName();
                        break;
                    }
                    case UNQUOTED_ATTRIBUTE_VALUE: {
                        this.handleUnquotedAttributeValue();
                        break;
                    }
                    case AFTER_ATTRIBUTE_NAME: {
                        this.handleAfterAttributeName();
                        break;
                    }
                    case HTML_TAG_NAME: {
                        this.handleHtmlTagName();
                        break;
                    }
                    case RCDATA_STYLE: {
                        this.handleRcData(TagName.SpecialTagName.STYLE);
                        break;
                    }
                    case RCDATA_TITLE: {
                        this.handleRcData(TagName.SpecialTagName.TITLE);
                        break;
                    }
                    case RCDATA_SCRIPT: {
                        this.handleRcData(TagName.SpecialTagName.SCRIPT);
                        break;
                    }
                    case RCDATA_TEXTAREA: {
                        this.handleRcData(TagName.SpecialTagName.TEXTAREA);
                        break;
                    }
                    case CDATA: {
                        this.handleCData();
                        break;
                    }
                    case HTML_COMMENT: {
                        this.handleHtmlComment();
                        break;
                    }
                    case XML_DECLARATION: {
                        this.handleXmlDeclaration();
                        break;
                    }
                    case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                        this.handleXmlAttributeQuoted(true);
                        break;
                    }
                    case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                        this.handleXmlAttributeQuoted(false);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("cant yet handle: " + (Object)((Object)startState));
                    }
                }
                if (this.context.getState() == startState && startIndex == this.currentRawTextIndex) {
                    throw new IllegalStateException("failed to make progress in state: " + startState.name() + " at " + this.currentLocation());
                }
                if (this.currentRawTextOffset <= this.currentRawTextIndex) continue;
                throw new IllegalStateException("offset is greater than index! offset: " + this.currentRawTextOffset + " index: " + this.currentRawTextIndex);
            }
            if (this.context.getState().isInvalidForEndOfRawText()) {
                throw new AssertionError((Object)("Shouldn't end a raw text block in state: " + (Object)((Object)this.context.getState())));
            }
            if (this.currentRawTextIndex != this.currentRawText.length()) {
                throw new AssertionError((Object)"failed to visit all of the raw text");
            }
            if (this.currentRawTextOffset < this.currentRawTextIndex && this.currentRawTextOffset != 0) {
                RawTextNode suffix = this.consumeAsRawText();
                this.edits.replace((SoyNode.StandaloneNode)node, suffix);
            }
        }

        void handleRcData(TagName.SpecialTagName tagName) {
            boolean foundLt = this.advanceWhileMatches(NOT_LT);
            if (foundLt) {
                if (this.matchPrefixIgnoreCase("</" + (Object)((Object)tagName), false)) {
                    this.context.setState(State.PCDATA, this.currentPoint());
                } else {
                    this.advance();
                }
            }
        }

        void handleCData() {
            boolean foundBrace = this.advanceWhileMatches(NOT_RSQUARE_BRACE);
            if (foundBrace) {
                if (this.matchPrefix("]]>", true)) {
                    this.context.setState(State.PCDATA, this.currentPointOrEnd());
                } else {
                    this.advance();
                }
            }
        }

        void handleHtmlComment() {
            boolean foundHyphen = this.advanceWhileMatches(NOT_HYPHEN);
            if (foundHyphen) {
                if (this.matchPrefix("-->", true)) {
                    this.context.setState(State.PCDATA, this.currentPointOrEnd());
                } else {
                    this.advance();
                }
            }
        }

        void handleXmlDeclaration() {
            boolean foundDelimiter = this.advanceWhileMatches(XML_DECLARATION_NON_DELIMITERS);
            if (foundDelimiter) {
                int c = this.currentChar();
                this.advance();
                if (c == 34) {
                    this.context.setState(State.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE, this.currentPoint());
                } else if (c == 39) {
                    this.context.setState(State.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE, this.currentPoint());
                } else if (c == 62) {
                    this.context.setState(State.PCDATA, this.currentPoint());
                } else {
                    throw new AssertionError((Object)("unexpected character: " + c));
                }
            }
        }

        void handleXmlAttributeQuoted(boolean doubleQuoted) {
            boolean foundQuote = this.advanceWhileMatches(doubleQuoted ? NOT_DOUBLE_QUOTE : NOT_SINGLE_QUOTE);
            if (foundQuote) {
                this.advance();
                this.context.setState(State.XML_DECLARATION, this.currentPoint());
            }
        }

        void handlePcData() {
            boolean foundLt = this.advanceWhileMatches(NOT_LT);
            RawTextNode node = this.consumeAsRawText();
            if (node != null) {
                this.edits.replace((SoyNode.StandaloneNode)this.currentRawTextNode, node);
            }
            if (foundLt) {
                SourceLocation.Point ltPoint = this.currentPoint();
                if (this.matchPrefix("<!--", true)) {
                    this.context.setState(State.HTML_COMMENT, ltPoint);
                } else if (this.matchPrefixIgnoreCase("<![cdata", true)) {
                    this.context.setState(State.CDATA, ltPoint);
                } else if (this.matchPrefix("<!", true) || this.matchPrefix("<?", true)) {
                    this.context.setState(State.XML_DECLARATION, ltPoint);
                } else {
                    boolean isCloseTag = this.matchPrefix("</", false);
                    this.context.startTag(this.currentRawTextNode, isCloseTag, this.currentPoint());
                    this.advance();
                    if (isCloseTag) {
                        this.advance();
                    }
                    this.consume();
                    this.context.setState(State.HTML_TAG_NAME, ltPoint);
                }
            }
        }

        void handleHtmlTagName() {
            if (this.consumeWhitespace()) {
                this.errorReporter.report(this.context.tagStartLocation(), UNEXPECTED_WS_AFTER_LT, new Object[0]);
                this.context.reset();
                this.context.setState(State.PCDATA, this.currentPointOrEnd());
                return;
            }
            RawTextNode node = this.consumeHtmlIdentifier();
            if (node == null) {
                this.errorReporter.report(this.currentLocation(), GENERIC_UNEXPECTED_CHAR, "an html tag");
                this.context.setTagName(new TagName(new RawTextNode(this.nodeIdGen.genId(), "$parse-error$", this.currentLocation())));
            } else {
                this.context.setTagName(new TagName(node));
            }
            this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, this.currentPointOrEnd());
        }

        void handleAfterTagNameOrAttribute() {
            if (this.consumeWhitespace()) {
                this.context.setState(State.BEFORE_ATTRIBUTE_NAME, this.currentPointOrEnd());
                return;
            }
            if (!this.tryCreateTagEnd()) {
                this.errorReporter.report(this.currentLocation(), EXPECTED_WS_OR_CLOSE_AFTER_TAG_OR_ATTRIBUTE, new Object[0]);
                this.context.setState(State.BEFORE_ATTRIBUTE_NAME, this.currentPoint());
                this.advance();
            }
        }

        void handleBeforeAttributeName() {
            if (this.tryCreateTagEnd()) {
                return;
            }
            if (this.consumeWhitespace()) {
                return;
            }
            RawTextNode identifier = this.consumeHtmlIdentifier();
            if (identifier == null) {
                this.context.resetAttribute();
                return;
            }
            this.context.setAttributeName(identifier);
            int current = this.currentChar();
            if (current == -1) {
                this.context.createAttributeNode();
                this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, this.currentRawTextNode.getSourceLocation().getEndPoint());
            } else {
                this.context.setState(State.AFTER_ATTRIBUTE_NAME, this.currentPoint());
            }
        }

        void handleAfterAttributeName() {
            boolean ws = this.consumeWhitespace();
            int current = this.currentChar();
            if (current == 61) {
                this.context.setEqualsSignLocation(this.currentPoint());
                this.advance();
                this.consume();
                this.consumeWhitespace();
                this.context.setState(State.BEFORE_ATTRIBUTE_VALUE, this.currentPointOrEnd());
            } else {
                this.context.createAttributeNode();
                if (ws) {
                    this.context.setState(State.BEFORE_ATTRIBUTE_NAME, this.currentPointOrEnd());
                } else {
                    this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, this.currentPointOrEnd());
                }
            }
        }

        void handleBeforeAttributeValue() {
            int c = this.currentChar();
            if (c == 39 || c == 34) {
                SourceLocation.Point quotePoint = this.currentPoint();
                this.context.startQuotedAttributeValue(this.currentRawTextNode, quotePoint);
                this.advance();
                this.consume();
                this.context.setState(c == 34 ? State.DOUBLE_QUOTED_ATTRIBUTE_VALUE : State.SINGLE_QUOTED_ATTRIBUTE_VALUE, quotePoint);
            } else {
                this.context.setState(State.UNQUOTED_ATTRIBUTE_VALUE, this.currentPoint());
            }
        }

        void handleUnquotedAttributeValue() {
            boolean foundDelimiter = this.advanceWhileMatches(TAG_RAW_TEXT_MATCHER);
            RawTextNode node = this.consumeAsRawText();
            if (node != null) {
                int badCharIndex = BAD_UNQUOTED_ATTRIBUTE_CHARACTER_MATCHER.indexIn((CharSequence)node.getRawText());
                if (badCharIndex != -1) {
                    this.errorReporter.report(node.substringLocation(badCharIndex, badCharIndex + 1), ILLEGAL_HTML_ATTRIBUTE_CHARACTER, new Object[0]);
                }
                this.context.addAttributeValuePart(node);
            }
            if (foundDelimiter) {
                if (this.context.hasUnquotedAttributeValueParts()) {
                    this.context.createUnquotedAttributeValue();
                    if (this.context.hasAttributePartsWithValue()) {
                        this.context.createAttributeNode();
                    } else {
                        this.context.resetAttribute();
                        this.errorReporter.report(this.currentLocation(), FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                    }
                } else {
                    this.context.resetAttribute();
                    this.errorReporter.report(this.currentLocation(), EXPECTED_ATTRIBUTE_VALUE, new Object[0]);
                }
                this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, this.currentPoint());
            }
        }

        void handleQuotedAttributeValue(boolean doubleQuoted) {
            boolean hasQuote = this.advanceWhileMatches(doubleQuoted ? NOT_DOUBLE_QUOTE : NOT_SINGLE_QUOTE);
            RawTextNode data = this.consumeAsRawText();
            if (data != null) {
                this.context.addAttributeValuePart(data);
            }
            if (hasQuote) {
                if (this.context.hasQuotedAttributeValueParts()) {
                    this.context.createQuotedAttributeValue(this.currentRawTextNode, doubleQuoted, this.currentPoint());
                    this.context.setState(State.AFTER_QUOTED_ATTRIBUTE_VALUE, this.currentPoint());
                } else {
                    this.errorReporter.report(this.currentLocation(), FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                    this.context.resetAttribute();
                    this.context.setState(State.BEFORE_ATTRIBUTE_NAME, this.currentPoint());
                }
                this.advance();
                this.consume();
            }
        }

        void handleAfterQuotedAttributeValue(SourceLocation.Point currentPoint) {
            if (this.context.hasAttributePartsWithValue()) {
                this.context.createAttributeNode();
            } else {
                this.errorReporter.report(currentPoint.asLocation(this.filePath), FOUND_END_OF_ATTRIBUTE_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                this.context.resetAttribute();
            }
            this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, currentPoint);
        }

        boolean tryCreateTagEnd() {
            int c = this.currentChar();
            if (c == 62) {
                if (this.context.hasTagStart()) {
                    SourceLocation.Point point = this.currentPoint();
                    this.context.setState(this.context.createTag(this.currentRawTextNode, false, point), point);
                } else {
                    this.context.reset();
                    this.errorReporter.report(this.currentLocation(), FOUND_END_TAG_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                }
                this.advance();
                this.consume();
                return true;
            }
            if (this.matchPrefix("/>", false)) {
                this.advance();
                if (this.context.hasTagStart()) {
                    SourceLocation.Point point = this.currentPoint();
                    this.context.setState(this.context.createTag(this.currentRawTextNode, true, point), point);
                } else {
                    this.context.reset();
                    this.errorReporter.report(this.currentLocation(), FOUND_END_TAG_STARTED_IN_ANOTHER_BLOCK, new Object[0]);
                }
                this.advance();
                this.consume();
                return true;
            }
            return false;
        }

        boolean advanceWhileMatches(CharMatcher c) {
            int next = this.currentChar();
            while (next != -1 && c.matches((char)next)) {
                this.advance();
                next = this.currentChar();
            }
            return next != -1;
        }

        boolean consumeWhitespace() {
            int startIndex = this.currentRawTextIndex;
            this.advanceWhileMatches(CharMatcher.whitespace());
            this.consume();
            return this.currentRawTextIndex != startIndex;
        }

        @Nullable
        RawTextNode consumeHtmlIdentifier() {
            this.advanceWhileMatches(TAG_RAW_TEXT_MATCHER);
            RawTextNode node = this.consumeAsRawText();
            if (node != null) {
                int invalidChar = Visitor.indexOfInvalidNameCharacter(node.getRawText());
                if (invalidChar != -1) {
                    this.errorReporter.report(node.substringLocation(invalidChar, invalidChar + 1), INVALID_IDENTIFIER, Character.valueOf(node.getRawText().charAt(invalidChar)));
                }
            } else {
                this.errorReporter.report(this.currentLocation(), GENERIC_UNEXPECTED_CHAR, "an html identifier");
                this.advance();
                this.consume();
            }
            return node;
        }

        @Nullable
        RawTextNode consumeAsRawText() {
            if (this.currentRawTextIndex == this.currentRawTextOffset) {
                return null;
            }
            this.edits.remove(this.currentRawTextNode);
            RawTextNode node = this.currentRawTextNode.substring(this.nodeIdGen.genId(), this.currentRawTextOffset, this.currentRawTextIndex);
            this.consume();
            return node;
        }

        SourceLocation currentLocation() {
            return this.currentRawTextNode.substringLocation(this.currentRawTextIndex, this.currentRawTextIndex + 1);
        }

        SourceLocation.Point currentPoint() {
            return this.currentRawTextNode.locationOf(this.currentRawTextIndex);
        }

        SourceLocation.Point currentPointOrEnd() {
            if (this.currentRawText.length() > this.currentRawTextIndex) {
                return this.currentPoint();
            }
            return this.currentRawTextNode.getSourceLocation().getEndPoint();
        }

        int currentChar() {
            if (this.currentRawTextIndex < this.currentRawText.length()) {
                return this.currentRawText.charAt(this.currentRawTextIndex);
            }
            return -1;
        }

        void advance(int n) {
            Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
            for (int i = 0; i < n; ++i) {
                this.advance();
            }
        }

        void advance() {
            if (this.currentRawTextIndex >= this.currentRawText.length()) {
                throw new AssertionError((Object)"already advanced to the end, shouldn't advance any more");
            }
            ++this.currentRawTextIndex;
        }

        void consume() {
            this.currentRawTextOffset = this.currentRawTextIndex;
        }

        boolean matchPrefix(String prefix, boolean advance) {
            if (this.currentRawText.startsWith(prefix, this.currentRawTextIndex)) {
                if (advance) {
                    this.advance(prefix.length());
                }
                return true;
            }
            return false;
        }

        boolean matchPrefixIgnoreCase(String s, boolean advance) {
            if (this.currentRawTextIndex + s.length() <= this.currentRawText.length()) {
                for (int i = 0; i < s.length(); ++i) {
                    char c2;
                    char c1 = s.charAt(i);
                    if (c1 == (c2 = this.currentRawText.charAt(i + this.currentRawTextIndex)) || Ascii.toLowerCase((char)c1) == Ascii.toLowerCase((char)c2)) continue;
                    return false;
                }
                if (advance) {
                    this.advance(s.length());
                }
                return true;
            }
            return false;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.edits.clear();
            this.context = null;
            ErrorReporter.Checkpoint checkPoint = this.errorReporter.checkpoint();
            this.visitScopedBlock(node.getContentKind(), node, "template");
            if (!this.errorReporter.errorsSince(checkPoint)) {
                this.edits.apply();
            }
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitScopedBlock(node.getContentKind(), node, "let");
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitDebuggerNode(DebuggerNode node) {
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitScopedBlock(node.getContentKind(), node, "param");
        }

        @Override
        protected void visitCallParamValueNode(CallParamValueNode node) {
        }

        @Override
        protected void visitCallNode(CallNode node) {
            this.visitChildren(node);
            this.processPrintableNode(node);
            if (this.context.getState() == State.PCDATA) {
                node.setIsPcData(true);
            }
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            this.processPrintableNode(node);
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.visitControlFlowStructure(node, (List<? extends SoyNode.BlockNode>)ImmutableList.of((Object)node), "for loop", (Function<? super SoyNode.BlockNode, String>)Functions.constant((Object)"loop body"), false);
        }

        @Override
        protected void visitForeachNode(ForeachNode node) {
            this.visitControlFlowStructure(node, node.getChildren(), "foreach loop", (Function<? super SoyNode.BlockNode, String>)new Function<SoyNode.BlockNode, String>(){

                public String apply(@Nullable SoyNode.BlockNode input) {
                    if (input instanceof ForeachNonemptyNode) {
                        return "loop body";
                    }
                    return "ifempty block";
                }
            }, false);
        }

        @Override
        protected void visitIfNode(final IfNode node) {
            this.visitControlFlowStructure(node, node.getChildren(), "if", (Function<? super SoyNode.BlockNode, String>)new Function<SoyNode.BlockNode, String>(){

                public String apply(@Nullable SoyNode.BlockNode input) {
                    if (input instanceof IfCondNode) {
                        if (node.getChild(0) == input) {
                            return "if block";
                        }
                        return "elseif block";
                    }
                    return "else block";
                }
            }, Iterables.getLast(node.getChildren()) instanceof IfElseNode);
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.visitControlFlowStructure(node, node.getChildren(), "switch", (Function<? super SoyNode.BlockNode, String>)new Function<SoyNode.BlockNode, String>(){

                public String apply(@Nullable SoyNode.BlockNode input) {
                    if (input instanceof SwitchCaseNode) {
                        return "case block";
                    }
                    return "default block";
                }
            }, Iterables.getLast((Iterable)node.getChildren()) instanceof SwitchDefaultNode);
        }

        @Override
        protected void visitLogNode(LogNode node) {
            State oldState = this.context.setState(State.NONE, node.getSourceLocation().getBeginPoint());
            this.visitChildren(node);
            this.context.setState(oldState, node.getSourceLocation().getEndPoint());
            this.processNonPrintableNode(node);
        }

        @Override
        protected void visitCssNode(CssNode node) {
            this.processPrintableNode(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.processPrintableNode(node);
        }

        @Override
        protected void visitXidNode(XidNode node) {
            this.processPrintableNode(node);
        }

        void processNonPrintableNode(SoyNode.StandaloneNode node) {
            switch (this.context.getState()) {
                case AFTER_QUOTED_ATTRIBUTE_VALUE: {
                    this.handleAfterQuotedAttributeValue(node.getSourceLocation().getBeginPoint());
                }
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    this.context.addTagChild(node);
                    break;
                }
                case AFTER_ATTRIBUTE_NAME: {
                    this.context.createAttributeNode();
                    this.context.addTagChild(node);
                    this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, node.getSourceLocation().getEndPoint());
                    break;
                }
                case BEFORE_ATTRIBUTE_VALUE: {
                    this.errorReporter.report(node.getSourceLocation(), INVALID_LOCATION_FOR_NONPRINTABLE, "move it before the start of the tag or after the tag name");
                    break;
                }
                case HTML_TAG_NAME: {
                    this.errorReporter.report(node.getSourceLocation(), INVALID_LOCATION_FOR_NONPRINTABLE, "it creates ambiguity with an unquoted attribute value");
                    break;
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    this.context.addAttributeValuePart(node);
                    break;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @CheckReturnValue
        boolean processControlFlowNode(SoyNode.StandaloneNode node, String nodeName) {
            switch (this.context.getState()) {
                case AFTER_QUOTED_ATTRIBUTE_VALUE: {
                    this.handleAfterQuotedAttributeValue(node.getSourceLocation().getBeginPoint());
                }
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    this.context.addTagChild(node);
                    return true;
                }
                case AFTER_ATTRIBUTE_NAME: {
                    this.context.createAttributeNode();
                    this.context.addTagChild(node);
                    this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, node.getSourceLocation().getEndPoint());
                    return true;
                }
                case HTML_TAG_NAME: {
                    this.errorReporter.report(node.getSourceLocation(), INVALID_LOCATION_FOR_CONTROL_FLOW, nodeName, "html tag names can only be constants or print nodes");
                    this.context.reset();
                    this.context.setState(State.PCDATA, node.getSourceLocation().getBeginPoint());
                    return false;
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    this.context.addAttributeValuePart(node);
                    return true;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    return true;
                }
            }
            throw new AssertionError((Object)("unexpected control flow exit state: " + (Object)((Object)this.context.getState())));
        }

        void processPrintableNode(SoyNode.StandaloneNode node) {
            Preconditions.checkState((node.getKind() != SoyNode.Kind.RAW_TEXT_NODE ? 1 : 0) != 0);
            switch (this.context.getState()) {
                case AFTER_QUOTED_ATTRIBUTE_VALUE: {
                    this.handleAfterQuotedAttributeValue(node.getSourceLocation().getBeginPoint());
                    this.context.setAttributeName(node);
                    this.context.setState(State.AFTER_ATTRIBUTE_NAME, node.getSourceLocation().getEndPoint());
                    break;
                }
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    this.errorReporter.report(node.getSourceLocation(), EXPECTED_WS_OR_CLOSE_AFTER_TAG_OR_ATTRIBUTE, new Object[0]);
                    break;
                }
                case AFTER_ATTRIBUTE_NAME: {
                    this.errorReporter.report(node.getSourceLocation(), EXPECTED_WS_EQ_OR_CLOSE_AFTER_ATTRIBUTE_NAME, new Object[0]);
                    break;
                }
                case BEFORE_ATTRIBUTE_NAME: {
                    this.context.setAttributeName(node);
                    this.context.setState(State.AFTER_ATTRIBUTE_NAME, node.getSourceLocation().getEndPoint());
                    break;
                }
                case HTML_TAG_NAME: {
                    if (node.getKind() == SoyNode.Kind.PRINT_NODE) {
                        this.context.setTagName(new TagName((PrintNode)node));
                        this.edits.remove(node);
                        this.context.setState(State.AFTER_TAG_NAME_OR_ATTRIBUTE, node.getSourceLocation().getEndPoint());
                        break;
                    }
                    this.errorReporter.report(node.getSourceLocation(), INVALID_TAG_NAME, new Object[0]);
                    break;
                }
                case BEFORE_ATTRIBUTE_VALUE: {
                    this.context.setState(State.UNQUOTED_ATTRIBUTE_VALUE, node.getSourceLocation().getBeginPoint());
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    this.context.addAttributeValuePart(node);
                    break;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected state: " + (Object)((Object)this.context.getState())));
                }
            }
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            throw new UnsupportedOperationException((Object)((Object)node.getKind()) + " isn't supported yet");
        }

        void visitScopedBlock(SanitizedContent.ContentKind blockKind, SoyNode.BlockNode parent, String name) {
            State startState = State.fromKind(blockKind);
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            ParsingContext newCtx = this.newParsingContext(startState, parent.getSourceLocation().getBeginPoint());
            ParsingContext oldCtx = this.setContext(newCtx);
            this.visitBlock(startState, parent, name, checkpoint);
            this.setContext(oldCtx);
        }

        void visitControlFlowStructure(SoyNode.StandaloneNode parent, List<? extends SoyNode.BlockNode> children, String overallName, Function<? super SoyNode.BlockNode, String> blockNamer, boolean willExactlyOneBranchExecuteOnce) {
            if (!this.processControlFlowNode(parent, overallName)) {
                return;
            }
            if (children.isEmpty()) {
                return;
            }
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            State startState = this.context.getState();
            State endingState = null;
            for (SoyNode.BlockNode blockNode : children) {
                ParsingContext newCtx = this.newParsingContext(startState, blockNode.getSourceLocation().getBeginPoint());
                ParsingContext oldCtx = this.setContext(newCtx);
                endingState = this.visitBlock(startState, blockNode, (String)blockNamer.apply((Object)blockNode), checkpoint);
                this.setContext(oldCtx);
            }
            if (!this.errorReporter.errorsSince(checkpoint)) {
                if (startState == State.BEFORE_ATTRIBUTE_VALUE && endingState == State.AFTER_QUOTED_ATTRIBUTE_VALUE) {
                    if (!willExactlyOneBranchExecuteOnce) {
                        this.errorReporter.report(parent.getSourceLocation(), CONDITIONAL_BLOCK_ISNT_GUARANTEED_TO_PRODUCE_ONE_ATTRIBUTE_VALUE, overallName);
                    } else {
                        this.context.setAttributeValue((SoyNode.StandaloneNode)Iterables.getOnlyElement(this.context.attributeValueChildren));
                        this.context.attributeValueChildren.clear();
                        this.context.setState(endingState, parent.getSourceLocation().getEndPoint());
                    }
                } else {
                    this.context.setState(endingState, parent.getSourceLocation().getEndPoint());
                }
            }
        }

        State visitBlock(State startState, SoyNode.BlockNode node, String blockName, ErrorReporter.Checkpoint checkpoint) {
            this.visitChildren(node);
            State finalState = this.context.getState();
            SourceLocation.Point finalStateTransitionPoint = this.context.getStateTransitionPoint();
            if (finalState.isInvalidForEndOfBlock()) {
                this.errorReporter.report(node.getSourceLocation(), BLOCK_ENDS_IN_INVALID_STATE, new Object[]{blockName, finalState});
                finalState = startState;
            }
            if (!this.errorReporter.errorsSince(checkpoint)) {
                State reconciled;
                if (startState != finalState && (finalState == State.AFTER_QUOTED_ATTRIBUTE_VALUE || finalState == State.UNQUOTED_ATTRIBUTE_VALUE)) {
                    if (finalState == State.AFTER_QUOTED_ATTRIBUTE_VALUE) {
                        if (this.context.hasAttributePartsWithValue()) {
                            this.context.createAttributeNode();
                            finalState = State.AFTER_TAG_NAME_OR_ATTRIBUTE;
                        }
                    } else if (this.context.hasAttributePartsForValue()) {
                        this.context.createUnquotedAttributeValue();
                        this.context.createAttributeNode();
                        finalState = State.AFTER_TAG_NAME_OR_ATTRIBUTE;
                    }
                }
                if ((reconciled = startState.reconcile(finalState)) == null) {
                    String suggestion = Visitor.reconciliationFailureHint(startState, finalState);
                    this.errorReporter.report(finalStateTransitionPoint.asLocation(this.filePath), BLOCK_CHANGES_CONTEXT, new Object[]{blockName, startState, finalState, suggestion != null ? " " + suggestion : ""});
                } else {
                    finalState = reconciled;
                    Visitor.reparentNodes(node, this.context, finalState);
                }
            } else {
                finalState = startState;
            }
            this.context.setState(finalState, node.getSourceLocation().getEndPoint());
            return finalState;
        }

        static void reparentNodes(SoyNode.BlockNode parent, ParsingContext blockCtx, State finalState) {
            switch (finalState) {
                case AFTER_ATTRIBUTE_NAME: 
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    blockCtx.reparentDirectTagChildren(parent);
                    break;
                }
                case AFTER_QUOTED_ATTRIBUTE_VALUE: {
                    blockCtx.reparentAttributeParts(parent);
                    break;
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case UNQUOTED_ATTRIBUTE_VALUE: {
                    blockCtx.reparentAttributeValueChildren(parent);
                    break;
                }
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case HTML_COMMENT: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("found non-empty context for unexpected state: " + (Object)((Object)blockCtx.getState())));
                }
            }
            blockCtx.checkEmpty("context not fully reparented after '%s'", new Object[]{finalState});
        }

        static String reconciliationFailureHint(State startState, State finalState) {
            switch (finalState) {
                case PCDATA: {
                    return null;
                }
                case BEFORE_ATTRIBUTE_VALUE: {
                    return "Expected an attribute value before the end of the block";
                }
                case CDATA: {
                    return Visitor.didYouForgetToCloseThe("CDATA section");
                }
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: {
                    return Visitor.didYouForgetToCloseThe("attribute value");
                }
                case HTML_COMMENT: {
                    return Visitor.didYouForgetToCloseThe("html comment");
                }
                case RCDATA_SCRIPT: {
                    return Visitor.didYouForgetToCloseThe("<script> block");
                }
                case RCDATA_STYLE: {
                    return Visitor.didYouForgetToCloseThe("<style> block");
                }
                case RCDATA_TEXTAREA: {
                    return Visitor.didYouForgetToCloseThe("<textare> block");
                }
                case RCDATA_TITLE: {
                    return Visitor.didYouForgetToCloseThe("<title> block");
                }
                case HTML_TAG_NAME: 
                case XML_DECLARATION: 
                case AFTER_ATTRIBUTE_NAME: 
                case UNQUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: 
                case AFTER_QUOTED_ATTRIBUTE_VALUE: {
                    if (startState == State.PCDATA) {
                        return "Did you forget to close the tag?";
                    }
                    return null;
                }
            }
            throw new AssertionError((Object)("unexpected final state: " + (Object)((Object)finalState)));
        }

        static String didYouForgetToCloseThe(String thing) {
            return "Did you forget to close the " + thing + "?";
        }

        ParsingContext setContext(ParsingContext ctx) {
            ParsingContext old = this.context;
            this.context = ctx;
            return old;
        }

        ParsingContext newParsingContext(State state, SourceLocation.Point startPoint) {
            return new ParsingContext(state, startPoint, this.filePath, this.edits, this.errorReporter, this.nodeIdGen);
        }
    }

    private static enum State {
        NONE(new StateFeature[0]),
        PCDATA(new StateFeature[0]),
        RCDATA_SCRIPT(new StateFeature[0]),
        RCDATA_TEXTAREA(new StateFeature[0]),
        RCDATA_TITLE(new StateFeature[0]),
        RCDATA_STYLE(new StateFeature[0]),
        HTML_COMMENT(new StateFeature[0]),
        CDATA(new StateFeature[0]),
        XML_DECLARATION(new StateFeature[0]),
        SINGLE_QUOTED_XML_ATTRIBUTE_VALUE(new StateFeature[0]),
        DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE(new StateFeature[0]),
        HTML_TAG_NAME(new StateFeature[0]),
        AFTER_TAG_NAME_OR_ATTRIBUTE(StateFeature.TAG),
        BEFORE_ATTRIBUTE_NAME(StateFeature.TAG),
        AFTER_ATTRIBUTE_NAME(StateFeature.TAG, StateFeature.INVALID_END_STATE_FOR_RAW_TEXT),
        BEFORE_ATTRIBUTE_VALUE(StateFeature.INVALID_END_STATE_FOR_BLOCK),
        SINGLE_QUOTED_ATTRIBUTE_VALUE(new StateFeature[0]),
        DOUBLE_QUOTED_ATTRIBUTE_VALUE(new StateFeature[0]),
        AFTER_QUOTED_ATTRIBUTE_VALUE(StateFeature.TAG),
        UNQUOTED_ATTRIBUTE_VALUE(StateFeature.TAG);

        private final ImmutableSet<StateFeature> stateTypes;

        static State fromKind(@Nullable SanitizedContent.ContentKind kind) {
            if (kind == null) {
                return NONE;
            }
            switch (kind) {
                case ATTRIBUTES: {
                    return BEFORE_ATTRIBUTE_NAME;
                }
                case HTML: {
                    return PCDATA;
                }
                case CSS: 
                case JS: 
                case TEXT: 
                case TRUSTED_RESOURCE_URI: 
                case URI: {
                    return NONE;
                }
            }
            throw new AssertionError((Object)("unhandled kind: " + (Object)((Object)kind)));
        }

        private State(StateFeature ... stateTypes) {
            EnumSet<StateFeature> set = EnumSet.noneOf(StateFeature.class);
            Collections.addAll(set, stateTypes);
            this.stateTypes = Sets.immutableEnumSet(set);
        }

        @Nullable
        State reconcile(State that) {
            Preconditions.checkNotNull((Object)((Object)that));
            if (that == this) {
                return this;
            }
            if (this.compareTo(that) > 0) {
                return that.reconcile(this);
            }
            if (this == BEFORE_ATTRIBUTE_VALUE && (that == AFTER_QUOTED_ATTRIBUTE_VALUE || that == UNQUOTED_ATTRIBUTE_VALUE)) {
                return that;
            }
            if (this.isTagState() && that.isTagState()) {
                return AFTER_TAG_NAME_OR_ATTRIBUTE;
            }
            switch (this) {
                case NONE: 
                case PCDATA: 
                case RCDATA_STYLE: 
                case RCDATA_TITLE: 
                case RCDATA_SCRIPT: 
                case RCDATA_TEXTAREA: 
                case DOUBLE_QUOTED_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_VALUE: 
                case HTML_COMMENT: 
                case HTML_TAG_NAME: 
                case XML_DECLARATION: 
                case CDATA: 
                case DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case SINGLE_QUOTED_XML_ATTRIBUTE_VALUE: 
                case AFTER_ATTRIBUTE_NAME: 
                case UNQUOTED_ATTRIBUTE_VALUE: 
                case BEFORE_ATTRIBUTE_NAME: 
                case AFTER_TAG_NAME_OR_ATTRIBUTE: {
                    return null;
                }
            }
            throw new AssertionError((Object)("unexpected state: " + (Object)((Object)this)));
        }

        boolean isTagState() {
            return this.stateTypes.contains((Object)StateFeature.TAG);
        }

        boolean isInvalidForEndOfRawText() {
            return this.stateTypes.contains((Object)StateFeature.INVALID_END_STATE_FOR_RAW_TEXT);
        }

        boolean isInvalidForEndOfBlock() {
            return this.stateTypes.contains((Object)StateFeature.INVALID_END_STATE_FOR_BLOCK);
        }

        public String toString() {
            return Ascii.toLowerCase((String)this.name().replace('_', ' '));
        }
    }

    private static enum StateFeature {
        TAG,
        INVALID_END_STATE_FOR_RAW_TEXT,
        INVALID_END_STATE_FOR_BLOCK;

    }
}

