/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;

final class FormattingContext
implements AutoCloseable {
    private final StringBuilder buf;
    private final int initialSize;
    private Scope curScope = new Scope(null);
    private String curIndent;
    private boolean nextAppendShouldStartNewLine = false;

    FormattingContext() {
        this(0);
    }

    FormattingContext(int startingIndent) {
        this.curIndent = Strings.repeat((String)" ", (int)startingIndent);
        this.buf = new StringBuilder(this.curIndent);
        this.initialSize = this.curIndent.length();
    }

    FormattingContext append(String stuff) {
        this.maybeIndent();
        this.buf.append(stuff);
        return this;
    }

    FormattingContext append(char c) {
        this.maybeIndent();
        this.buf.append(c);
        return this;
    }

    boolean shouldFormat(CodeChunk chunk) {
        boolean shouldFormat;
        boolean bl = shouldFormat = !this.curScope.alreadyFormatted(chunk);
        if (shouldFormat) {
            this.curScope.formatted.add(chunk);
        }
        return shouldFormat;
    }

    FormattingContext enterBlock() {
        this.maybeIndent();
        this.buf.append('{');
        this.curIndent = this.curIndent + "  ";
        this.endLine();
        this.curScope = new Scope(this.curScope);
        return this;
    }

    FormattingContext endLine() {
        this.nextAppendShouldStartNewLine = true;
        return this;
    }

    private void maybeIndent() {
        if (this.nextAppendShouldStartNewLine) {
            this.buf.append('\n').append(this.curIndent);
            this.nextAppendShouldStartNewLine = false;
        }
    }

    public String toString() {
        return this.isEmpty() ? "" : this.buf.toString();
    }

    boolean isEmpty() {
        return this.buf.length() == this.initialSize;
    }

    @Override
    public void close() {
        this.curScope = (Scope)Preconditions.checkNotNull((Object)this.curScope.parent);
        Preconditions.checkState((!this.curIndent.isEmpty() ? 1 : 0) != 0);
        this.curIndent = this.curIndent.substring(2);
        this.endLine();
        this.append('}');
    }

    FormattingContext concat(FormattingContext other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return this.append(other.toString());
    }

    private static final class Scope {
        final Set<CodeChunk> formatted = Collections.newSetFromMap(new IdentityHashMap());
        @Nullable
        final Scope parent;

        Scope(@Nullable Scope parent) {
            this.parent = parent;
        }

        boolean alreadyFormatted(CodeChunk chunk) {
            return this.formatted.contains(chunk) || this.parent != null && this.parent.alreadyFormatted(chunk);
        }
    }
}

