/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.TypeInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;

final class InnerClasses {
    private final TypeInfo outer;
    private final Map<TypeInfo, ClassData> innerClasses = new LinkedHashMap<TypeInfo, ClassData>();
    private final Map<TypeInfo, Integer> innerClassesAccessModifiers = new LinkedHashMap<TypeInfo, Integer>();
    private final UniqueNameGenerator classNames = JbcSrcNameGenerators.forClassNames();

    InnerClasses(TypeInfo outer) {
        this.outer = outer;
    }

    ImmutableList<ClassData> getInnerClassData() {
        return ImmutableList.copyOf(this.innerClasses.values());
    }

    TypeInfo registerInnerClass(String simpleName, int accessModifiers) {
        this.classNames.claimName(simpleName);
        TypeInfo innerClass = this.outer.innerClass(simpleName);
        this.innerClassesAccessModifiers.put(innerClass, accessModifiers);
        return innerClass;
    }

    TypeInfo registerInnerClassWithGeneratedName(String simpleName, int accessModifiers) {
        simpleName = this.classNames.generateName(simpleName);
        TypeInfo innerClass = this.outer.innerClass(simpleName);
        this.innerClassesAccessModifiers.put(innerClass, accessModifiers);
        return innerClass;
    }

    void add(ClassData classData) {
        this.checkRegistered(classData.type());
        this.innerClasses.put(classData.type(), classData);
    }

    private void checkRegistered(TypeInfo type) {
        if (!this.classNames.hasName(type.simpleName())) {
            throw new IllegalArgumentException(type + " wasn't registered");
        }
    }

    void registerAsInnerClass(ClassVisitor visitor, TypeInfo innerClass) {
        this.checkRegistered(innerClass);
        this.doRegister(visitor, innerClass);
    }

    void registerAllInnerClasses(ClassVisitor visitor) {
        for (Map.Entry<TypeInfo, Integer> entry : this.innerClassesAccessModifiers.entrySet()) {
            TypeInfo innerClass = entry.getKey();
            this.doRegister(visitor, innerClass);
        }
    }

    private void doRegister(ClassVisitor visitor, TypeInfo innerClass) {
        visitor.visitInnerClass(innerClass.internalName(), this.outer.internalName(), innerClass.simpleName(), this.innerClassesAccessModifiers.get(innerClass).intValue());
    }
}

