/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.EnhancedAbstractExprNodeVisitor;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.PluginFunctionCompiler;
import com.google.template.soy.jbcsrc.ProtoUtils;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.SoyRuntimeType;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.soytree.defn.InjectedParam;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.primitive.UnknownType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class ExpressionCompiler {
    private final TemplateParameterLookup parameters;
    private final TemplateVariableManager varManager;
    private final ExpressionDetacher.Factory detacherFactory;

    static ExpressionCompiler create(ExpressionDetacher.Factory detacherFactory, TemplateParameterLookup parameters, TemplateVariableManager varManager) {
        return new ExpressionCompiler(detacherFactory, parameters, varManager);
    }

    static BasicExpressionCompiler createBasicCompiler(TemplateParameterLookup parameters, TemplateVariableManager varManager) {
        return new BasicExpressionCompiler(parameters, varManager);
    }

    private ExpressionCompiler(ExpressionDetacher.Factory detacherFactory, TemplateParameterLookup parameters, TemplateVariableManager varManager) {
        this.detacherFactory = detacherFactory;
        this.parameters = parameters;
        this.varManager = varManager;
    }

    SoyExpression compile(ExprNode node, Label reattachPoint) {
        return this.asBasicCompiler(reattachPoint).compile(node);
    }

    Optional<SoyExpression> compileWithNoDetaches(ExprNode node) {
        Preconditions.checkNotNull((Object)node);
        if (((Boolean)RequiresDetachVisitor.INSTANCE.exec(node)).booleanValue()) {
            return Optional.absent();
        }
        Supplier<ExpressionDetacher> throwingSupplier = new Supplier<ExpressionDetacher>(){

            public ExpressionDetacher get() {
                throw new AssertionError();
            }
        };
        return Optional.of(new CompilerVisitor(this.parameters, this.varManager, new PluginFunctionCompiler(this.parameters), (Supplier<? extends ExpressionDetacher>)throwingSupplier).exec(node));
    }

    BasicExpressionCompiler asBasicCompiler(final Label reattachPoint) {
        return new BasicExpressionCompiler(new CompilerVisitor(this.parameters, this.varManager, new PluginFunctionCompiler(this.parameters), (Supplier<? extends ExpressionDetacher>)Suppliers.memoize((Supplier)new Supplier<ExpressionDetacher>(){

            public ExpressionDetacher get() {
                return ExpressionCompiler.this.detacherFactory.createExpressionDetacher(reattachPoint);
            }
        })));
    }

    SoyExpression compile(ExprNode node) {
        Label reattachPoint = new Label();
        SoyExpression exec = this.compile(node, reattachPoint);
        return exec.withSource(exec.labelStart(reattachPoint));
    }

    private static final class RequiresDetachVisitor
    extends EnhancedAbstractExprNodeVisitor<Boolean> {
        static final RequiresDetachVisitor INSTANCE = new RequiresDetachVisitor();

        private RequiresDetachVisitor() {
        }

        @Override
        Boolean visitForeachLoopVar(VarRefNode varRef, LocalVar local) {
            return true;
        }

        @Override
        Boolean visitParam(VarRefNode varRef, TemplateParam param) {
            return true;
        }

        @Override
        Boolean visitLetNodeVar(VarRefNode node, LocalVar local) {
            return true;
        }

        @Override
        protected Boolean visitDataAccessNode(DataAccessNode node) {
            return true;
        }

        @Override
        Boolean visitIjParam(VarRefNode node, InjectedParam param) {
            return true;
        }

        @Override
        protected Boolean visitProtoInitNode(ProtoInitNode node) {
            for (Boolean i : this.visitChildren(node)) {
                if (!i.booleanValue()) continue;
                return true;
            }
            SoyProtoType protoType = (SoyProtoType)node.getType();
            for (String paramName : node.getParamNames()) {
                if (!protoType.getFieldDescriptor(paramName).isRepeated()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Boolean visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                for (Boolean i : this.visitChildren((ExprNode.ParentExprNode)node)) {
                    if (!i.booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class CompilerVisitor
    extends EnhancedAbstractExprNodeVisitor<SoyExpression> {
        final Supplier<? extends ExpressionDetacher> detacher;
        final TemplateParameterLookup parameters;
        final TemplateVariableManager varManager;
        final PluginFunctionCompiler functions;

        CompilerVisitor(TemplateParameterLookup parameters, TemplateVariableManager varManager, PluginFunctionCompiler functions, Supplier<? extends ExpressionDetacher> detacher) {
            this.detacher = detacher;
            this.parameters = parameters;
            this.varManager = varManager;
            this.functions = functions;
        }

        @Override
        protected final SoyExpression visitExprRootNode(ExprRootNode node) {
            return (SoyExpression)this.visit(node.getRoot());
        }

        @Override
        protected final SoyExpression visitNullNode(NullNode node) {
            return SoyExpression.NULL;
        }

        @Override
        protected final SoyExpression visitFloatNode(FloatNode node) {
            return SoyExpression.forFloat(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected final SoyExpression visitStringNode(StringNode node) {
            return SoyExpression.forString(BytecodeUtils.constant(node.getValue(), this.varManager));
        }

        @Override
        protected final SoyExpression visitBooleanNode(BooleanNode node) {
            return node.getValue() ? SoyExpression.TRUE : SoyExpression.FALSE;
        }

        @Override
        protected final SoyExpression visitIntegerNode(IntegerNode node) {
            return SoyExpression.forInt(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected final SoyExpression visitGlobalNode(GlobalNode node) {
            return (SoyExpression)this.visit(node.getValue());
        }

        @Override
        protected final SoyExpression visitListLiteralNode(ListLiteralNode node) {
            return SoyExpression.forList((ListType)node.getType(), SoyExpression.asBoxedList(this.visitChildren(node)));
        }

        @Override
        protected final SoyExpression visitMapLiteralNode(MapLiteralNode node) {
            int numItems = node.numChildren() / 2;
            if (numItems == 0) {
                return SoyExpression.forSoyValue(node.getType(), FieldRef.EMPTY_DICT.accessor());
            }
            boolean isRecord = node.getType().getKind() == SoyType.Kind.RECORD;
            ArrayList<SoyExpression> keys = new ArrayList<SoyExpression>(numItems);
            ArrayList<SoyExpression> values = new ArrayList<SoyExpression>(numItems);
            for (int i = 0; i < numItems; ++i) {
                keys.add(((SoyExpression)this.visit(node.getChild(2 * i))).unboxAs(String.class));
                values.add(((SoyExpression)this.visit(node.getChild(2 * i + 1))).box());
            }
            Expression soyDict = MethodRef.DICT_IMPL_FOR_PROVIDER_MAP.invoke(BytecodeUtils.newLinkedHashMap(keys, values));
            if (isRecord) {
                return SoyExpression.forSoyValue(node.getType(), soyDict);
            }
            return SoyExpression.forSoyValue(node.getType(), soyDict);
        }

        @Override
        protected final SoyExpression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.compareSoyEquals((SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1))));
        }

        @Override
        protected final SoyExpression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(BytecodeUtils.compareSoyEquals((SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)))));
        }

        @Override
        protected final SoyExpression visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
            SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(155, left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(155, left.coerceToDouble(), right.coerceToDouble()));
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
            SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(157, left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(157, left.coerceToDouble(), right.coerceToDouble()));
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(right.box(), left.box()));
        }

        @Override
        protected final SoyExpression visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
            SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(158, left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(158, left.coerceToDouble(), right.coerceToDouble()));
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
            SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(156, left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(156, left.coerceToDouble(), right.coerceToDouble()));
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(right.box(), left.box()));
        }

        @Override
        protected final SoyExpression visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
            SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
            SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
            SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
            if (leftRuntimeType.assignableToNullableNumber() && rightRuntimeType.assignableToNullableNumber()) {
                if (leftRuntimeType.assignableToNullableInt() && rightRuntimeType.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(97, left, right);
                }
                if (leftRuntimeType.assignableToNullableFloat() || rightRuntimeType.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(99, left, right);
                }
            }
            if (leftRuntimeType.isKnownString() || rightRuntimeType.isKnownString()) {
                SoyExpression leftString = left.coerceToString();
                SoyExpression rightString = right.coerceToString();
                return SoyExpression.forString(leftString.invoke(MethodRef.STRING_CONCAT, rightString));
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_PLUS.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
            SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(101, left, right);
                }
                if (left.assignableToNullableFloat() || right.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(103, left, right);
                }
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_MINUS.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
            SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(105, left, right);
                }
                if (left.assignableToNullableFloat() || right.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(107, left, right);
                }
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_TIMES.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            return CompilerVisitor.applyBinaryFloatOperator(111, (SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)));
        }

        @Override
        protected final SoyExpression visitModOpNode(OperatorNodes.ModOpNode node) {
            return CompilerVisitor.applyBinaryIntOperator(113, (SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)));
        }

        private static SoyExpression applyBinaryIntOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftInt = left.unboxAs(Long.TYPE);
            final SoyExpression rightInt = right.unboxAs(Long.TYPE);
            return SoyExpression.forInt(new Expression(Type.LONG_TYPE){

                @Override
                void doGen(CodeBuilder mv) {
                    leftInt.gen(mv);
                    rightInt.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        private static SoyExpression applyBinaryFloatOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftFloat = left.coerceToDouble();
            final SoyExpression rightFloat = right.coerceToDouble();
            return SoyExpression.forFloat(new Expression(Type.DOUBLE_TYPE){

                @Override
                void doGen(CodeBuilder mv) {
                    leftFloat.gen(mv);
                    rightFloat.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        @Override
        protected final SoyExpression visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            SoyExpression child = (SoyExpression)this.visit(node.getChild(0));
            if (child.assignableToNullableInt()) {
                final SoyExpression intExpr = child.unboxAs(Long.TYPE);
                return SoyExpression.forInt(new Expression(Type.LONG_TYPE, child.features()){

                    @Override
                    void doGen(CodeBuilder mv) {
                        intExpr.gen(mv);
                        mv.visitInsn(117);
                    }
                });
            }
            if (child.assignableToNullableFloat()) {
                final SoyExpression floatExpr = child.unboxAs(Double.TYPE);
                return SoyExpression.forFloat(new Expression(Type.DOUBLE_TYPE, child.features()){

                    @Override
                    void doGen(CodeBuilder mv) {
                        floatExpr.gen(mv);
                        mv.visitInsn(119);
                    }
                });
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_NEGATIVE.invoke(child.box()));
        }

        @Override
        protected final SoyExpression visitNotOpNode(OperatorNodes.NotOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(((SoyExpression)this.visit(node.getChild(0))).coerceToBoolean()));
        }

        @Override
        protected final SoyExpression visitAndOpNode(OperatorNodes.AndOpNode node) {
            SoyExpression left = ((SoyExpression)this.visit(node.getChild(0))).coerceToBoolean();
            SoyExpression right = ((SoyExpression)this.visit(node.getChild(1))).coerceToBoolean();
            return SoyExpression.forBool(BytecodeUtils.logicalAnd(left, right));
        }

        @Override
        protected final SoyExpression visitOrOpNode(OperatorNodes.OrOpNode node) {
            SoyExpression left = ((SoyExpression)this.visit(node.getChild(0))).coerceToBoolean();
            SoyExpression right = ((SoyExpression)this.visit(node.getChild(1))).coerceToBoolean();
            return SoyExpression.forBool(BytecodeUtils.logicalOr(left, right));
        }

        @Override
        protected SoyExpression visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            SoyExpression left = (SoyExpression)this.visit(node.getLeftChild());
            if (left.isNonNullable()) {
                return left;
            }
            SoyExpression right = (SoyExpression)this.visit(node.getRightChild());
            if (SoyTypes.removeNull(left.soyType()).equals(right.soyType())) {
                SoyExpression result;
                if (left.isBoxed() == right.isBoxed()) {
                    result = right.withSource(BytecodeUtils.firstNonNull(left, right));
                } else {
                    SoyExpression boxedRight = right.box();
                    result = boxedRight.withSource(BytecodeUtils.firstNonNull(left.box(), boxedRight));
                }
                if (Expression.areAllCheap(left, right)) {
                    result = result.asCheap();
                }
                return result;
            }
            Type runtimeType = SoyRuntimeType.getBoxedType(node.getType()).runtimeType();
            return SoyExpression.forSoyValue(node.getType(), BytecodeUtils.firstNonNull(left.box().checkedCast(runtimeType), right.box().checkedCast(runtimeType)));
        }

        @Override
        protected final SoyExpression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            SoyExpression condition = ((SoyExpression)this.visit(node.getChild(0))).coerceToBoolean();
            SoyExpression trueBranch = (SoyExpression)this.visit(node.getChild(1));
            SoyExpression falseBranch = (SoyExpression)this.visit(node.getChild(2));
            boolean typesEqual = trueBranch.soyType().equals(falseBranch.soyType());
            if (typesEqual) {
                if (trueBranch.isBoxed() == falseBranch.isBoxed()) {
                    return trueBranch.withSource(BytecodeUtils.ternary(condition, trueBranch, falseBranch));
                }
                SoyExpression boxedTrue = trueBranch.box();
                return boxedTrue.withSource(BytecodeUtils.ternary(condition, boxedTrue, falseBranch.box()));
            }
            return SoyExpression.forSoyValue(UnknownType.getInstance(), BytecodeUtils.ternary(condition, trueBranch.box().checkedCast(SoyValue.class), falseBranch.box().checkedCast(SoyValue.class)));
        }

        @Override
        SoyExpression visitForLoopIndex(VarRefNode varRef, LocalVar local) {
            return SoyExpression.forInt(BytecodeUtils.numericConversion(this.parameters.getLocal(local), Type.LONG_TYPE));
        }

        @Override
        SoyExpression visitForeachLoopVar(VarRefNode varRef, LocalVar local) {
            Expression expression = this.parameters.getLocal(local);
            expression = ((ExpressionDetacher)this.detacher.get()).resolveSoyValueProvider(expression);
            return SoyExpression.forSoyValue(varRef.getType(), expression.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitParam(VarRefNode varRef, TemplateParam param) {
            Expression paramExpr = ((ExpressionDetacher)this.detacher.get()).resolveSoyValueProvider(this.parameters.getParam(param));
            return SoyExpression.forSoyValue(varRef.getType(), paramExpr.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitIjParam(VarRefNode varRef, InjectedParam param) {
            Expression ij = MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(this.parameters.getIjRecord(), BytecodeUtils.constant(param.name()));
            return SoyExpression.forSoyValue(varRef.getType(), ((ExpressionDetacher)this.detacher.get()).resolveSoyValueProvider(ij).checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitLetNodeVar(VarRefNode varRef, LocalVar local) {
            Expression expression = this.parameters.getLocal(local);
            expression = ((ExpressionDetacher)this.detacher.get()).resolveSoyValueProvider(expression);
            return SoyExpression.forSoyValue(varRef.getType(), expression.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        protected SoyExpression visitDataAccessNode(DataAccessNode node) {
            return new NullSafeAccessVisitor().visit(node);
        }

        @Override
        protected SoyExpression visitFieldAccessNode(FieldAccessNode node) {
            return new NullSafeAccessVisitor().visit(node);
        }

        @Override
        SoyExpression visitIsFirstFunction(FunctionNode node, SyntheticVarName indexVar) {
            final Expression expr = this.parameters.getLocal(indexVar);
            return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE){

                @Override
                void doGen(CodeBuilder adapter) {
                    expr.gen(adapter);
                    Label ifFirst = new Label();
                    adapter.ifZCmp(153, ifFirst);
                    adapter.pushBoolean(false);
                    Label end = new Label();
                    adapter.goTo(end);
                    adapter.mark(ifFirst);
                    adapter.pushBoolean(true);
                    adapter.mark(end);
                }
            });
        }

        @Override
        SoyExpression visitIsLastFunction(FunctionNode node, SyntheticVarName indexVar, SyntheticVarName lengthVar) {
            final Expression index = this.parameters.getLocal(indexVar);
            final Expression length = this.parameters.getLocal(lengthVar);
            return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE){

                @Override
                void doGen(CodeBuilder adapter) {
                    index.gen(adapter);
                    adapter.pushInt(1);
                    adapter.visitInsn(96);
                    length.gen(adapter);
                    Label ifLast = new Label();
                    adapter.ifICmp(153, ifLast);
                    adapter.pushBoolean(false);
                    Label end = new Label();
                    adapter.goTo(end);
                    adapter.mark(ifLast);
                    adapter.pushBoolean(true);
                    adapter.mark(end);
                }
            });
        }

        @Override
        SoyExpression visitIndexFunction(FunctionNode node, SyntheticVarName indexVar) {
            return SoyExpression.forInt(BytecodeUtils.numericConversion(this.parameters.getLocal(indexVar), Type.LONG_TYPE));
        }

        @Override
        SoyExpression visitCheckNotNullFunction(FunctionNode node) {
            final ExprNode childNode = (ExprNode)Iterables.getOnlyElement(node.getChildren());
            final SoyExpression childExpr = (SoyExpression)this.visit(childNode);
            return childExpr.withSource(new Expression(childExpr.resultType(), childExpr.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    childExpr.gen(adapter);
                    adapter.dup();
                    Label end = new Label();
                    adapter.ifNonNull(end);
                    adapter.throwException(BytecodeUtils.NULL_POINTER_EXCEPTION_TYPE, "'" + childNode.toSourceString() + "' evaluates to null");
                    adapter.mark(end);
                }
            }).asNonNullable();
        }

        @Override
        SoyExpression visitPluginFunction(FunctionNode node) {
            return this.functions.callPluginFunction(node, this.visitChildren(node));
        }

        @Override
        protected final SoyExpression visitProtoInitNode(ProtoInitNode node) {
            List<SoyExpression> args = this.visitChildren(node);
            return ProtoUtils.createProto(node, args, this.parameters.getRenderContext(), this.detacher, this.varManager);
        }

        @Override
        protected final SoyExpression visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException("Support for " + (Object)((Object)node.getKind()) + " has not been added yet");
        }

        private final class NullSafeAccessVisitor {
            Label nullSafeExit;

            private NullSafeAccessVisitor() {
            }

            Label getNullSafeExit() {
                Label local = this.nullSafeExit;
                return local == null ? (this.nullSafeExit = new Label()) : local;
            }

            SoyExpression visit(DataAccessNode node) {
                SoyExpression dataAccess = this.visitNullSafeNodeRecurse(node);
                if (this.nullSafeExit == null) {
                    return dataAccess;
                }
                if (BytecodeUtils.isPrimitive(dataAccess.resultType())) {
                    dataAccess = dataAccess.box();
                }
                return dataAccess.asNullable().labelEnd(this.nullSafeExit);
            }

            SoyExpression addNullSafetyCheck(final SoyExpression baseExpr) {
                final Label nullSafeExit = this.getNullSafeExit();
                return baseExpr.withSource(new Expression(baseExpr.resultType(), baseExpr.features()){

                    @Override
                    void doGen(CodeBuilder adapter) {
                        baseExpr.gen(adapter);
                        BytecodeUtils.nullCoalesce(adapter, nullSafeExit);
                    }
                }).asNonNullable();
            }

            SoyExpression visitNullSafeNodeRecurse(ExprNode node) {
                switch (node.getKind()) {
                    case FIELD_ACCESS_NODE: 
                    case ITEM_ACCESS_NODE: {
                        SoyExpression baseExpr = this.visitNullSafeNodeRecurse(((DataAccessNode)node).getBaseExprChild());
                        baseExpr = ((DataAccessNode)node).isNullSafe() ? this.addNullSafetyCheck(baseExpr) : baseExpr.asNonNullable();
                        if (node.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                            return this.visitNullSafeFieldAccess(baseExpr, (FieldAccessNode)node);
                        }
                        return this.visitNullSafeItemAccess(baseExpr, (ItemAccessNode)node);
                    }
                }
                return (SoyExpression)CompilerVisitor.this.visit(node);
            }

            SoyExpression visitNullSafeFieldAccess(SoyExpression baseExpr, FieldAccessNode node) {
                switch (baseExpr.soyType().getKind()) {
                    case PROTO: {
                        SoyProtoType protoType = (SoyProtoType)baseExpr.soyType();
                        return ProtoUtils.accessField(protoType, baseExpr, node, CompilerVisitor.this.parameters.getRenderContext());
                    }
                    case UNKNOWN: 
                    case UNION: 
                    case RECORD: {
                        Expression fieldProvider = MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(baseExpr.box().checkedCast(SoyRecord.class), BytecodeUtils.constant(node.getFieldName()));
                        return SoyExpression.forSoyValue(node.getType(), ((ExpressionDetacher)CompilerVisitor.this.detacher.get()).resolveSoyValueProvider(fieldProvider).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType()));
                    }
                }
                throw new AssertionError((Object)"unexpected field access operation");
            }

            SoyExpression visitNullSafeItemAccess(SoyExpression baseExpr, ItemAccessNode node) {
                SoyExpression keyExpr = (SoyExpression)CompilerVisitor.this.visit(node.getKeyExprChild());
                Expression soyValueProvider = baseExpr.soyRuntimeType().isKnownList() ? MethodRef.RUNTIME_GET_LIST_ITEM.invoke(baseExpr.unboxAs(List.class), keyExpr.unboxAs(Long.TYPE)) : MethodRef.RUNTIME_GET_MAP_ITEM.invoke(baseExpr.box().checkedCast(SoyMap.class), keyExpr.box());
                Expression soyValue = ((ExpressionDetacher)CompilerVisitor.this.detacher.get()).resolveSoyValueProvider(soyValueProvider).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType());
                return SoyExpression.forSoyValue(node.getType(), soyValue);
            }
        }
    }

    static final class BasicExpressionCompiler {
        private final CompilerVisitor compilerVisitor;

        private BasicExpressionCompiler(TemplateParameterLookup parameters, TemplateVariableManager varManager) {
            this.compilerVisitor = new CompilerVisitor(parameters, varManager, new PluginFunctionCompiler(parameters), (Supplier<? extends ExpressionDetacher>)Suppliers.ofInstance((Object)ExpressionDetacher.BasicDetacher.INSTANCE));
        }

        private BasicExpressionCompiler(CompilerVisitor visitor) {
            this.compilerVisitor = visitor;
        }

        SoyExpression compile(ExprNode expr) {
            return (SoyExpression)this.compilerVisitor.exec(expr);
        }

        Expression compileToList(List<? extends ExprNode> children) {
            ArrayList<SoyExpression> soyExprs = new ArrayList<SoyExpression>(children.size());
            for (ExprNode exprNode : children) {
                soyExprs.add(this.compile(exprNode));
            }
            return SoyExpression.asBoxedList(soyExprs);
        }
    }
}

