/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
public final class CeilingFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction {
    @Inject
    CeilingFunction() {
    }

    @Override
    public String getName() {
        return "ceiling";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        return CeilingFunction.ceil(args.get(0));
    }

    public static IntegerData ceil(SoyValue arg) {
        if (arg instanceof IntegerData) {
            return (IntegerData)arg;
        }
        return IntegerData.forValue((int)Math.ceil(arg.floatValue()));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg = args.get(0);
        return new JsExpr("Math.ceil(" + arg.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr arg = args.get(0);
        return new PyExpr("int(math.ceil(" + arg.getText() + "))", Integer.MAX_VALUE);
    }
}

