/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeProvider;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.DescriptorTreeWalker;
import com.google.template.soy.types.proto.Protos;
import com.google.template.soy.types.proto.SafeStringTypes;
import com.google.template.soy.types.proto.SoyProtoEnumTypeImpl;
import com.google.template.soy.types.proto.SoyProtoTypeImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;

public final class SoyProtoTypeProvider
implements SoyTypeProvider {
    private final Object lock = new Object();
    private final ConcurrentMap<String, Descriptors.GenericDescriptor> descriptors = new ConcurrentHashMap<String, Descriptors.GenericDescriptor>();
    @GuardedBy(value="lock")
    private final SetMultimap<String, Descriptors.FieldDescriptor> extensions = MultimapBuilder.hashKeys().treeSetValues((Comparator)new Comparator<Descriptors.FieldDescriptor>(){

        @Override
        public int compare(Descriptors.FieldDescriptor left, Descriptors.FieldDescriptor right) {
            return ComparisonChain.start().compare(left.getNumber(), right.getNumber()).compare((Comparable)((Object)left.getContainingType().getFullName()), (Comparable)((Object)right.getContainingType().getFullName())).result();
        }
    }).build();
    @GuardedBy(value="lock")
    private final Map<String, SoyType> typeCache;

    private SoyProtoTypeProvider() {
        HashMap<String, SoyType> typeCache = new HashMap<String, SoyType>();
        typeCache.putAll((Map<String, SoyType>)SafeStringTypes.SAFE_STRING_PROTO_NAME_TO_SANITIZED_TYPE);
        this.typeCache = typeCache;
    }

    public static SoyProtoTypeProvider empty() {
        return new Builder().buildNoFiles();
    }

    @Override
    public SoyType getType(String name, SoyTypeRegistry typeRegistry) {
        Descriptors.GenericDescriptor descriptor = (Descriptors.GenericDescriptor)this.descriptors.get(name);
        if (descriptor == null) {
            return null;
        }
        return this.doGetType(name, typeRegistry, descriptor);
    }

    SoyProtoTypeImpl getType(Descriptors.Descriptor descriptor, SoyTypeRegistry registry) {
        String fullName = descriptor.getFullName();
        if (!this.descriptors.containsKey(fullName)) {
            DescriptorAddingDescriptorTreeWalker walker = new DescriptorAddingDescriptorTreeWalker();
            walker.walkMessageDescriptor(descriptor);
            walker.commitInto(this);
        }
        return (SoyProtoTypeImpl)this.doGetType(fullName, registry, (Descriptors.GenericDescriptor)descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoyType doGetType(String name, SoyTypeRegistry typeRegistry, Descriptors.GenericDescriptor descriptor) {
        SoyType type;
        Object object = this.lock;
        synchronized (object) {
            type = this.typeCache.get(name);
            if (type == null) {
                type = descriptor instanceof Descriptors.EnumDescriptor ? new SoyProtoEnumTypeImpl((Descriptors.EnumDescriptor)descriptor) : new SoyProtoTypeImpl(typeRegistry, (Descriptors.Descriptor)descriptor, this.extensions.get((Object)name));
                this.typeCache.put(name, type);
            }
        }
        return type;
    }

    static final class DescriptorAddingDescriptorTreeWalker
    extends DescriptorTreeWalker {
        private final Map<String, Descriptors.GenericDescriptor> descriptors = new LinkedHashMap<String, Descriptors.GenericDescriptor>();
        private final Multimap<String, Descriptors.FieldDescriptor> extensions = LinkedListMultimap.create();

        DescriptorAddingDescriptorTreeWalker(ExtensionRegistry extensionRegistry) {
            super(extensionRegistry);
        }

        DescriptorAddingDescriptorTreeWalker() {
            this(ExtensionRegistry.getEmptyRegistry());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commitInto(SoyProtoTypeProvider provider) {
            Object object = provider.lock;
            synchronized (object) {
                provider.descriptors.putAll(this.descriptors);
                provider.extensions.putAll(this.extensions);
            }
        }

        @Override
        void visitMessageDescriptor(Descriptors.Descriptor descriptor) {
            if (this.descriptors.containsKey(descriptor.getFullName())) {
                return;
            }
            this.descriptors.put(descriptor.getFullName(), (Descriptors.GenericDescriptor)descriptor);
        }

        @Override
        void visitFieldDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
            if (Protos.shouldJsIgnoreField(fieldDescriptor)) {
                return;
            }
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                this.maybeWalkMessageDescriptor(fieldDescriptor.getMessageType());
            } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                this.visitEnumDescriptor(fieldDescriptor.getEnumType());
            }
        }

        @Override
        void visitEnumDescriptor(Descriptors.EnumDescriptor enumDescriptor) {
            this.descriptors.put(enumDescriptor.getFullName(), (Descriptors.GenericDescriptor)enumDescriptor);
        }

        @Override
        void visitExtensionDescriptor(Descriptors.FieldDescriptor extension) {
            if (Protos.shouldJsIgnoreField(extension)) {
                return;
            }
            String containingType = extension.getContainingType().getFullName();
            if (this.extensions.put((Object)containingType, (Object)extension) && extension.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                this.maybeWalkMessageDescriptor(extension.getMessageType());
            }
        }

        private void maybeWalkMessageDescriptor(Descriptors.Descriptor descriptor) {
            if (!this.descriptors.containsKey(descriptor.getFullName())) {
                this.walkMessageDescriptor(descriptor);
            }
        }
    }

    static final class RegisterExtensionsDescriptorTreeWalker
    extends DescriptorTreeWalker {
        RegisterExtensionsDescriptorTreeWalker(ExtensionRegistry extensionRegistry) {
            super(extensionRegistry);
        }

        @Override
        void visitFileDescriptor(Descriptors.FileDescriptor fileDescriptor) {
            this.walkGenericDescriptors(fileDescriptor.getExtensions());
        }

        @Override
        void visitMessageDescriptor(Descriptors.Descriptor descriptor) {
            this.walkGenericDescriptors(descriptor.getExtensions());
        }

        @Override
        void visitExtensionDescriptor(Descriptors.FieldDescriptor descriptor) {
            this.extensionRegistry.add(descriptor);
        }
    }

    public static final class Builder {
        private final List<ByteSource> descriptorSources = new ArrayList<ByteSource>();
        private final List<DescriptorProtos.FileDescriptorSet> descriptorSets = new ArrayList<DescriptorProtos.FileDescriptorSet>();
        private final List<Descriptors.GenericDescriptor> descriptors = new ArrayList<Descriptors.GenericDescriptor>();

        public Builder addFileDescriptorSetFromFile(File descriptorFile) {
            return this.addFileDescriptorSetFromByteSource(Files.asByteSource((File)descriptorFile));
        }

        public Builder addFileDescriptorSetFromByteSource(ByteSource descriptorSource) {
            this.descriptorSources.add(descriptorSource);
            return this;
        }

        public Builder addFileDescriptorSet(DescriptorProtos.FileDescriptorSet descriptorSet) {
            this.descriptorSets.add(descriptorSet);
            return this;
        }

        public Builder addDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptorsToAdd) {
            for (Descriptors.GenericDescriptor genericDescriptor : descriptorsToAdd) {
                this.descriptors.add(genericDescriptor);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.descriptorSources.isEmpty() && this.descriptorSets.isEmpty() && this.descriptors.isEmpty();
        }

        private void walkAll(DescriptorTreeWalker walker) throws FileNotFoundException, IOException, Descriptors.DescriptorValidationException {
            for (ByteSource descriptorSource : this.descriptorSources) {
                walker.walkFileDescriptorSetFromByteSource(descriptorSource);
            }
            for (DescriptorProtos.FileDescriptorSet descriptorSet : this.descriptorSets) {
                walker.walkFileDescriptorSet(descriptorSet);
            }
            walker.walkGenericDescriptors(this.descriptors);
        }

        public SoyProtoTypeProvider build() throws FileNotFoundException, IOException, Descriptors.DescriptorValidationException {
            SoyProtoTypeProvider provider = new SoyProtoTypeProvider();
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getEmptyRegistry();
            if (!this.descriptorSources.isEmpty()) {
                extensionRegistry = ExtensionRegistry.newInstance();
                this.walkAll(new RegisterExtensionsDescriptorTreeWalker(extensionRegistry));
            }
            DescriptorAddingDescriptorTreeWalker walker = new DescriptorAddingDescriptorTreeWalker(extensionRegistry);
            this.walkAll(walker);
            walker.commitInto(provider);
            return provider;
        }

        public SoyProtoTypeProvider buildNoFiles() {
            Preconditions.checkState((boolean)this.descriptorSources.isEmpty(), (Object)"use build(), not buildNoFiles() to load descriptors from files");
            try {
                return this.build();
            }
            catch (Descriptors.DescriptorValidationException | IOException ex) {
                throw new AssertionError("File system should not have been touched", ex);
            }
        }
    }
}

