/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public abstract class TemplateNode
extends AbstractBlockCommandNode
implements SoyNode.RenderUnitNode {
    private static final SoyErrorKind ALIAS_USED_WITHOUT_NAMESPACE = SoyErrorKind.of("'''{'alias...'' can only be used in files with valid '''{'namespace ...'' declarations");
    private static final SoyErrorKind INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE = SoyErrorKind.of("Not allowed to alias the last part of the file''s namespace ({0}) to another namespace ({1}).");
    private static final SoyErrorKind DUPLICATE_ALIAS = SoyErrorKind.of("Duplicate alias definition ''{0}''.");
    private final SoyFileHeaderInfo soyFileHeaderInfo;
    private final String templateName;
    @Nullable
    private final String partialTemplateName;
    private final String templateNameForUserMsgs;
    private final Visibility visibility;
    private final AutoescapeMode autoescapeMode;
    @Nullable
    private final SanitizedContent.ContentKind contentKind;
    private final ImmutableList<String> requiredCssNamespaces;
    private final String cssBaseNamespace;
    private String soyDoc;
    private String soyDocDesc;
    @Nullable
    private ImmutableList<TemplateParam> params;
    @Nullable
    private ImmutableList<TemplateParam> injectedParams;
    private int maxLocalVariableTableSize = -1;

    TemplateNode(TemplateNodeBuilder nodeBuilder, String cmdName, SoyFileHeaderInfo soyFileHeaderInfo, Visibility visibility, @Nullable ImmutableList<TemplateParam> params) {
        super(nodeBuilder.getId(), nodeBuilder.sourceLocation, cmdName, nodeBuilder.getCmdText());
        this.maybeSetSyntaxVersionUpperBound(nodeBuilder.getSyntaxVersionBound());
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.templateName = nodeBuilder.getTemplateName();
        this.partialTemplateName = nodeBuilder.getPartialTemplateName();
        this.templateNameForUserMsgs = nodeBuilder.getTemplateNameForUserMsgs();
        this.visibility = visibility;
        this.autoescapeMode = nodeBuilder.getAutoescapeMode();
        this.contentKind = nodeBuilder.getContentKind();
        this.requiredCssNamespaces = nodeBuilder.getRequiredCssNamespaces();
        this.cssBaseNamespace = nodeBuilder.getCssBaseNamespace();
        this.soyDoc = nodeBuilder.getSoyDoc();
        this.soyDocDesc = nodeBuilder.getSoyDocDesc();
        ImmutableList.Builder regularParams = ImmutableList.builder();
        ImmutableList.Builder injectedParams = ImmutableList.builder();
        if (params != null) {
            for (TemplateParam param : params) {
                if (param.isInjected()) {
                    injectedParams.add((Object)param);
                    continue;
                }
                regularParams.add((Object)param);
            }
        }
        this.params = regularParams.build();
        this.injectedParams = injectedParams.build();
    }

    protected TemplateNode(TemplateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.soyFileHeaderInfo = orig.soyFileHeaderInfo;
        this.templateName = orig.templateName;
        this.partialTemplateName = orig.partialTemplateName;
        this.templateNameForUserMsgs = orig.templateNameForUserMsgs;
        this.visibility = orig.visibility;
        this.autoescapeMode = orig.autoescapeMode;
        this.contentKind = orig.contentKind;
        this.requiredCssNamespaces = orig.requiredCssNamespaces;
        this.cssBaseNamespace = orig.cssBaseNamespace;
        this.soyDoc = orig.soyDoc;
        this.soyDocDesc = orig.soyDocDesc;
        this.params = orig.params;
        this.injectedParams = orig.injectedParams;
        this.maxLocalVariableTableSize = orig.maxLocalVariableTableSize;
    }

    public SoyFileHeaderInfo getSoyFileHeaderInfo() {
        return this.soyFileHeaderInfo;
    }

    public String getDelPackageName() {
        return this.soyFileHeaderInfo.delPackageName;
    }

    public String getTemplateNameForUserMsgs() {
        return this.templateNameForUserMsgs;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    @Nullable
    public String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public AutoescapeMode getAutoescapeMode() {
        return this.autoescapeMode;
    }

    @Override
    @Nullable
    public SanitizedContent.ContentKind getContentKind() {
        return this.contentKind;
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.requiredCssNamespaces;
    }

    public String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    public void setMaxLocalVariableTableSize(int size) {
        this.maxLocalVariableTableSize = size;
    }

    public int getMaxLocalVariableTableSize() {
        return this.maxLocalVariableTableSize;
    }

    public void clearSoyDocStrings() {
        this.soyDoc = null;
        this.soyDocDesc = null;
        assert (this.params != null);
        ArrayList newParams = Lists.newArrayListWithCapacity((int)this.params.size());
        for (TemplateParam origParam : this.params) {
            newParams.add(origParam.copyEssential());
        }
        this.params = ImmutableList.copyOf((Collection)newParams);
    }

    @Nullable
    public String getSoyDoc() {
        return this.soyDoc;
    }

    @Nullable
    public String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    public List<TemplateParam> getParams() {
        return this.params;
    }

    public List<TemplateParam> getInjectedParams() {
        return this.injectedParams;
    }

    @Nullable
    public Iterable<TemplateParam> getAllParams() {
        return Iterables.concat(this.params, this.injectedParams);
    }

    @Override
    public SoyFileNode getParent() {
        return (SoyFileNode)super.getParent();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.soyDoc != null) {
            sb.append(this.soyDoc).append("\n");
        }
        sb.append(this.getTagString()).append("\n");
        if (this.params != null) {
            for (TemplateParam param : this.params) {
                if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
                HeaderParam headerParam = (HeaderParam)param;
                sb.append("  {@param");
                if (!headerParam.isRequired()) {
                    sb.append('?');
                }
                sb.append(' ').append(headerParam.name()).append(": ").append(headerParam.typeSrc()).append("}");
                if (headerParam.desc() != null) {
                    sb.append("  /** ").append(headerParam.desc()).append(" */");
                }
                sb.append("\n");
            }
        }
        StringBuilder bodySb = new StringBuilder();
        this.appendSourceStringForChildren(bodySb);
        int bodyLen = bodySb.length();
        if (bodyLen != 0) {
            if (bodyLen != 1 && bodySb.charAt(bodyLen - 1) == ' ') {
                bodySb.replace(bodyLen - 1, bodyLen, "{sp}");
            }
            if (bodySb.charAt(0) == ' ') {
                bodySb.replace(0, 1, "{sp}");
            }
        }
        sb.append((CharSequence)bodySb);
        sb.append("\n");
        sb.append("{/").append(this.getCommandName()).append("}\n");
        return sb.toString();
    }

    public StackTraceElement createStackTraceElement(SourceLocation srcLocation) {
        if (this.partialTemplateName == null) {
            return new StackTraceElement("(UnknownSoyNamespace)", this.templateName, srcLocation.getFileName(), srcLocation.getLineNumber());
        }
        return new StackTraceElement(this.soyFileHeaderInfo.namespace, this.partialTemplateName.substring(1), srcLocation.getFileName(), srcLocation.getLineNumber());
    }

    @Immutable
    public static class SoyFileHeaderInfo {
        public final ImmutableMap<String, String> aliasToNamespaceMap;
        public final ImmutableList<AliasDeclaration> aliasDeclarations;
        @Nullable
        public final String delPackageName;
        final Priority priority;
        @Nullable
        public final String namespace;
        public final AutoescapeMode defaultAutoescapeMode;

        public SoyFileHeaderInfo(ErrorReporter errorReporter, @Nullable String delpackageName, NamespaceDeclaration namespaceDeclaration, Collection<AliasDeclaration> aliases) {
            this(delpackageName, namespaceDeclaration.getNamespace(), namespaceDeclaration.getDefaultAutoescapeMode(), SoyFileHeaderInfo.createAliasMap(errorReporter, namespaceDeclaration, aliases), (ImmutableList<AliasDeclaration>)ImmutableList.copyOf(aliases));
        }

        @VisibleForTesting
        public SoyFileHeaderInfo(String namespace) {
            this(null, namespace, AutoescapeMode.NONCONTEXTUAL, (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableList<AliasDeclaration>)ImmutableList.of());
        }

        private SoyFileHeaderInfo(@Nullable String delPackageName, String namespace, AutoescapeMode defaultAutoescapeMode, ImmutableMap<String, String> aliasToNamespaceMap, ImmutableList<AliasDeclaration> aliasDeclarations) {
            this.delPackageName = delPackageName;
            this.priority = delPackageName == null ? Priority.STANDARD : Priority.HIGH_PRIORITY;
            this.namespace = namespace;
            this.defaultAutoescapeMode = defaultAutoescapeMode;
            this.aliasToNamespaceMap = aliasToNamespaceMap;
            this.aliasDeclarations = aliasDeclarations;
        }

        private static ImmutableMap<String, String> createAliasMap(ErrorReporter errorReporter, NamespaceDeclaration namespaceDeclaration, Collection<AliasDeclaration> aliases) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            String aliasForFileNamespace = namespaceDeclaration.isDefined() ? BaseUtils.extractPartAfterLastDot(namespaceDeclaration.getNamespace()) : null;
            for (AliasDeclaration aliasDeclaration : aliases) {
                if (!namespaceDeclaration.isDefined()) {
                    errorReporter.report(aliasDeclaration.getLocation(), ALIAS_USED_WITHOUT_NAMESPACE, new Object[0]);
                }
                String aliasNamespace = aliasDeclaration.getNamespace();
                String alias = aliasDeclaration.getAlias();
                if (alias.equals(aliasForFileNamespace) && !aliasNamespace.equals(namespaceDeclaration.getNamespace())) {
                    errorReporter.report(aliasDeclaration.getLocation(), INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE, namespaceDeclaration.getNamespace(), aliasNamespace);
                }
                if (map.containsKey(alias)) {
                    errorReporter.report(aliasDeclaration.getLocation(), DUPLICATE_ALIAS, alias);
                }
                map.put(alias, aliasNamespace);
            }
            return ImmutableMap.copyOf((Map)map);
        }
    }

    public static enum Priority {
        STANDARD(0),
        HIGH_PRIORITY(1);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

