/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ArrayListMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.FindIndirectParamsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class CheckTemplateParamsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind UNDECLARED_DATA_KEY = SoyErrorKind.of("Unknown data key ''{0}''.{1}");
    private static final SoyErrorKind UNUSED_PARAM = SoyErrorKind.of("Param ''{0}'' unused in template body.");
    private final SyntaxVersion declaredSyntaxVersion;
    private final ErrorReporter errorReporter;
    private final TemplateRegistry templateRegistry;

    CheckTemplateParamsVisitor(TemplateRegistry templateRegistry, SyntaxVersion declaredSyntaxVersion, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
        this.declaredSyntaxVersion = declaredSyntaxVersion;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            if (this.declaredSyntaxVersion.num < SyntaxVersion.V2_0.num && !this.allNodesInferredAboveV2(soyFile)) continue;
            this.visit(soyFile);
        }
    }

    private boolean allNodesInferredAboveV2(SoyNode node) {
        final AtomicBoolean allV2 = new AtomicBoolean(true);
        SoytreeUtils.visitAllNodes(node, (NodeVisitor<? super Node, Boolean>)new NodeVisitor<Node, Boolean>(){

            @Override
            public Boolean exec(Node node) {
                if (!node.couldHaveSyntaxVersionAtLeast(SyntaxVersion.V2_0)) {
                    allV2.set(false);
                    return false;
                }
                if (node instanceof SoyNode.ExprHolderNode) {
                    for (ExprUnion union : ((SoyNode.ExprHolderNode)node).getAllExprUnions()) {
                        if (union.getExpr() != null) continue;
                        allV2.set(false);
                        return false;
                    }
                }
                return true;
            }
        });
        return allV2.get();
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        ArrayListMultimap dataKeys = ArrayListMultimap.create();
        for (VarRefNode varRefNode : SoytreeUtils.getAllNodesOfType(node, VarRefNode.class)) {
            if (!varRefNode.isPossibleParam().booleanValue()) continue;
            dataKeys.put((Object)varRefNode.getName(), (Object)varRefNode.getSourceLocation());
        }
        FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
        HashSet<String> allParamNames = new HashSet<String>();
        ArrayList<String> unusedParams = new ArrayList<String>();
        for (TemplateParam param : node.getAllParams()) {
            allParamNames.add(param.name());
            if (dataKeys.containsKey((Object)param.name())) {
                dataKeys.removeAll((Object)param.name());
                continue;
            }
            if (ipi.paramKeyToCalleesMultimap.containsKey((Object)param.name()) || ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) continue;
            unusedParams.add(param.name());
        }
        for (Map.Entry undeclared : dataKeys.entries()) {
            String extraErrorMessage = "";
            this.errorReporter.report((SourceLocation)undeclared.getValue(), UNDECLARED_DATA_KEY, undeclared.getKey(), extraErrorMessage);
        }
        if (node instanceof TemplateBasicNode) {
            for (String unusedParam : unusedParams) {
                this.errorReporter.report(node.getSourceLocation(), UNUSED_PARAM, unusedParam);
            }
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

