/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprparse;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParserConstants;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.Token;
import java.util.List;

final class ParseErrors {
    private static final SoyErrorKind LEGACY_AND_ERROR = SoyErrorKind.of("Found use of ''&&'' instead of the ''and'' operator");
    private static final SoyErrorKind LEGACY_OR_ERROR = SoyErrorKind.of("Found use of ''||'' instead of the ''or'' operator");
    private static final SoyErrorKind LEGACY_NOT_ERROR = SoyErrorKind.of("Found use of ''!'' instead of the ''not'' operator");
    private static final SoyErrorKind LEGACY_DOUBLE_QUOTED_STRING = SoyErrorKind.of("Found use of double quotes, Soy strings use single quotes");

    private ParseErrors() {
    }

    static void reportExprParseException(ErrorReporter reporter, SourceLocation location, ParseException e) {
        ParseErrors.reportExprParseException(reporter, "", location, e);
    }

    static void reportExprParseException(ErrorReporter reporter, String expectation, SourceLocation location, ParseException e) {
        Token errorToken = e.currentToken;
        if (errorToken.next != null) {
            errorToken = errorToken.next;
        }
        switch (errorToken.kind) {
            case 31: {
                reporter.report(location, LEGACY_AND_ERROR, new Object[0]);
                return;
            }
            case 32: {
                reporter.report(location, LEGACY_OR_ERROR, new Object[0]);
                return;
            }
            case 33: {
                reporter.report(location, LEGACY_NOT_ERROR, new Object[0]);
                return;
            }
            case 34: {
                reporter.report(location, LEGACY_DOUBLE_QUOTED_STRING, new Object[0]);
                return;
            }
        }
        ImmutableSet.Builder expectedTokenImages = ImmutableSet.builder();
        for (int[] expected : e.expectedTokenSequences) {
            expectedTokenImages.add((Object)ParseErrors.getSoyFileParserTokenDisplayName(expected[0]));
        }
        reporter.report(location, SoyErrorKind.of(expectation + "{0}"), BaseUtils.formatParseExceptionDetails(errorToken.image, (List<String>)expectedTokenImages.build().asList()));
    }

    private static String getSoyFileParserTokenDisplayName(int tokenId) {
        switch (tokenId) {
            case 0: {
                return "eof";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return "an operator";
            }
            case 15: {
                return "an identifier";
            }
            case 17: 
            case 18: {
                return "field access";
            }
            case 16: {
                return "variable";
            }
            case 35: {
                throw new AssertionError((Object)"we should never expect the unexpected token");
            }
        }
        return ExpressionParserConstants.tokenImage[tokenId];
    }
}

