/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class SoyAbstractMap
extends SoyAbstractValue
implements SoyMap {
    @Override
    public SoyValue getItem(SoyValue key) {
        SoyValueProvider valueProvider = this.getItemProvider(key);
        return valueProvider != null ? valueProvider.resolve() : null;
    }

    @Override
    public final String coerceToString() {
        StringBuilder mapStr = new StringBuilder();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mapStr.toString();
    }

    @Override
    public void render(Appendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        for (SoyValue soyValue : this.getItemKeys()) {
            SoyValue value = this.getItem(soyValue);
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            soyValue.render(appendable);
            appendable.append(": ");
            value.render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    @Override
    public final boolean coerceToBoolean() {
        return true;
    }

    public String toString() {
        return this.coerceToString();
    }
}

