/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.CharMatcher;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;

public final class JavaQualifiedNames {
    private static final String OUTER_CLASS_SUFFIX = "OuterClass";

    private JavaQualifiedNames() {
    }

    public static String getPackage(Descriptors.FileDescriptor fileDescriptor) {
        DescriptorProtos.FileOptions fileOptions = fileDescriptor.getOptions();
        String javaPackage = fileDescriptor.getOptions().getJavaPackage();
        if (javaPackage == null || javaPackage.equals("")) {
            String genericPackage = fileDescriptor.getPackage();
            javaPackage = genericPackage == null || genericPackage.equals("") ? "com.google.protos" : "com.google.protos." + fileDescriptor.getPackage();
        }
        return javaPackage;
    }

    private static boolean hasConflictingClassName(Descriptors.Descriptor messageDesc, String name) {
        if (name.equals(messageDesc.getName())) {
            return true;
        }
        for (Descriptors.EnumDescriptor enumDesc : messageDesc.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor nestedMessageDesc : messageDesc.getNestedTypes()) {
            if (!JavaQualifiedNames.hasConflictingClassName(nestedMessageDesc, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConflictingClassName(Descriptors.FileDescriptor fileDesc, String name) {
        for (Descriptors.EnumDescriptor enumDesc : fileDesc.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.ServiceDescriptor serviceDesc : fileDesc.getServices()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor messageDesc : fileDesc.getMessageTypes()) {
            if (!JavaQualifiedNames.hasConflictingClassName(messageDesc, name)) continue;
            return true;
        }
        return false;
    }

    public static String getOuterClassname(Descriptors.FileDescriptor fileDescriptor) {
        String className = fileDescriptor.getOptions().getJavaOuterClassname();
        if (CharMatcher.whitespace().matchesAllOf((CharSequence)className)) {
            int cut1;
            className = fileDescriptor.getName();
            int cut0 = className.lastIndexOf("/");
            if (JavaQualifiedNames.hasConflictingClassName(fileDescriptor, className = JavaQualifiedNames.underscoresToCamelCase(className.substring(cut0 + 1, cut1 = className.lastIndexOf(".")), true))) {
                className = className + OUTER_CLASS_SUFFIX;
            }
        }
        return className;
    }

    private static void appendQualifiedName(StringBuilder builder, Descriptors.FileDescriptor fd, String name, Descriptors.Descriptor parent, boolean useCanonicalNames) {
        if (parent == null) {
            boolean topLevelClassSet = false;
            builder.append(JavaQualifiedNames.getPackage(fd));
            if (!fd.getOptions().getJavaMultipleFiles()) {
                builder.append('.').append(JavaQualifiedNames.getOuterClassname(fd));
                topLevelClassSet = true;
            }
            builder.append(!topLevelClassSet || useCanonicalNames ? (char)'.' : '$').append(name);
        } else {
            JavaQualifiedNames.appendQualifiedName(builder, fd, parent.getName(), parent.getContainingType(), useCanonicalNames);
            builder.append(useCanonicalNames ? (char)'.' : '$').append(name);
        }
    }

    private static String getQualifiedName(Descriptors.FileDescriptor fd, String name, Descriptors.Descriptor parent, boolean useCanonicalNames) {
        StringBuilder builder = new StringBuilder();
        JavaQualifiedNames.appendQualifiedName(builder, fd, name, parent, useCanonicalNames);
        return builder.toString();
    }

    private static String getQualifiedName(Descriptors.Descriptor msg, boolean useCanonicalNames) {
        return JavaQualifiedNames.getQualifiedName(msg.getFile(), msg.getName(), msg.getContainingType(), useCanonicalNames);
    }

    private static String getQualifiedName(Descriptors.EnumDescriptor enumType, boolean useCanonicalNames) {
        return JavaQualifiedNames.getQualifiedName(enumType.getFile(), enumType.getName(), enumType.getContainingType(), useCanonicalNames);
    }

    public static String getQualifiedName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getQualifiedName(msg, true);
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getQualifiedName(enumType, true);
    }

    public static String getClassName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getQualifiedName(msg, false);
    }

    public static String getClassName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getQualifiedName(enumType, false);
    }

    public static String getCaseEnumClassName(Descriptors.OneofDescriptor oneOfDescriptor) {
        return JavaQualifiedNames.getQualifiedName(oneOfDescriptor.getContainingType(), false) + '$' + JavaQualifiedNames.underscoresToCamelCase(oneOfDescriptor.getName(), true) + "Case";
    }

    public static String underscoresToCamelCase(String input, boolean capitializeNextLetter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                if (capitializeNextLetter) {
                    result.append((char)(ch + -32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                if (i == 0 && !capitializeNextLetter) {
                    result.append((char)(ch + 32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                result.append(ch);
                capitializeNextLetter = true;
                continue;
            }
            capitializeNextLetter = true;
        }
        return result.toString();
    }
}

