/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.primitive.AnyType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.proto.Protos;
import java.util.List;
import java.util.Map;

abstract class FieldInterpreter {
    private static final FieldInterpreter ANY = new FieldInterpreter(){

        @Override
        public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
            return converter.convert(field);
        }

        @Override
        public SoyType type() {
            return AnyType.getInstance();
        }
    };
    private static final FieldInterpreter BOOL = new FieldInterpreter(){

        @Override
        public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
            return BooleanData.forValue((Boolean)field);
        }

        @Override
        public SoyType type() {
            return BoolType.getInstance();
        }
    };
    private static final FieldInterpreter INT = new FieldInterpreter(){

        @Override
        public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
            return IntegerData.forValue(((Number)field).longValue());
        }

        @Override
        public SoyType type() {
            return IntType.getInstance();
        }
    };
    private static final FieldInterpreter FLOAT = new FieldInterpreter(){

        @Override
        public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
            return FloatData.forValue(((Number)field).doubleValue());
        }

        @Override
        public SoyType type() {
            return FloatType.getInstance();
        }
    };
    private static final FieldInterpreter STRING = new FieldInterpreter(){

        @Override
        public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
            return StringData.forValue(field.toString());
        }

        @Override
        public SoyType type() {
            return StringType.getInstance();
        }
    };
    private static volatile FieldInterpreter numberFactory;

    static FieldInterpreter create(SoyTypeRegistry typeRegistry, Descriptors.FieldDescriptor fieldDescriptor) {
        FieldInterpreter field = FieldInterpreter.getScalarType(typeRegistry, fieldDescriptor);
        if (fieldDescriptor.isRepeated()) {
            if (Protos.hasJsMapKey(fieldDescriptor)) {
                return FieldInterpreter.getMapType(typeRegistry, field, fieldDescriptor);
            }
            return FieldInterpreter.getListType(typeRegistry, field);
        }
        return field;
    }

    private static FieldInterpreter getListType(SoyTypeRegistry typeRegistry, final FieldInterpreter local) {
        final ListType listType = typeRegistry.getOrCreateListType(local.type());
        return new FieldInterpreter(){

            @Override
            public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
                List entries = (List)field;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object item : entries) {
                    builder.add((Object)local.intepretField(converter, item));
                }
                return ListImpl.forProviderList((List<? extends SoyValueProvider>)builder.build());
            }

            @Override
            public SoyType type() {
                return listType;
            }
        };
    }

    private static FieldInterpreter getMapType(SoyTypeRegistry typeRegistry, final FieldInterpreter scalarImpl, Descriptors.FieldDescriptor fieldDescriptor) {
        String keyFieldName = Protos.getJsMapKeyFieldName(fieldDescriptor);
        final Descriptors.FieldDescriptor keyDescriptor = fieldDescriptor.getMessageType().findFieldByName(keyFieldName);
        if (keyDescriptor == null) {
            throw new IllegalArgumentException("Cannot find field with name \"" + keyFieldName + "\".");
        }
        if (keyDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.STRING || keyDescriptor.isRepeated()) {
            throw new IllegalArgumentException("\"" + keyFieldName + "\" must be an optional/required string field.");
        }
        final MapType type = typeRegistry.getOrCreateMapType(StringType.getInstance(), scalarImpl.type());
        return new FieldInterpreter(){

            @Override
            public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
                List entries = (List)field;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Message message : entries) {
                    String key = (String)message.getField(keyDescriptor);
                    if (key.isEmpty()) continue;
                    builder.put((Object)key, (Object)scalarImpl.intepretField(converter, message));
                }
                return DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build());
            }

            @Override
            public SoyType type() {
                return type;
            }
        };
    }

    private static FieldInterpreter getScalarType(SoyTypeRegistry typeRegistry, Descriptors.FieldDescriptor fieldDescriptor) {
        if (Protos.hasJsType(fieldDescriptor)) {
            Protos.JsType jsType = Protos.getJsType(fieldDescriptor);
            switch (jsType) {
                case INT52: {
                    return INT;
                }
                case NUMBER: {
                    return FieldInterpreter.getNumberFieldInterpreter(typeRegistry);
                }
                case STRING: {
                    return STRING;
                }
            }
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                return BOOL;
            }
            case DOUBLE: 
            case FLOAT: {
                return FLOAT;
            }
            case BYTES: 
            case GROUP: {
                break;
            }
            case INT32: 
            case INT64: 
            case SINT32: 
            case UINT32: 
            case FIXED32: 
            case SFIXED32: {
                return INT;
            }
            case FIXED64: 
            case SINT64: 
            case SFIXED64: 
            case UINT64: {
                throw new IllegalArgumentException(fieldDescriptor.getFullName() + ": 64-bit integer types are not supported.  " + "Instead, add [(jspb.jstype) = INT52] to the field.");
            }
            case ENUM: {
                return FieldInterpreter.dynamicTypeField(typeRegistry.getType(fieldDescriptor.getEnumType().getFullName()));
            }
            case MESSAGE: {
                return FieldInterpreter.dynamicTypeField(typeRegistry.getType(fieldDescriptor.getMessageType().getFullName()));
            }
            case STRING: {
                return STRING;
            }
            default: {
                throw new AssertionError((Object)"Unexpected field type in proto");
            }
        }
        return ANY;
    }

    private static final FieldInterpreter dynamicTypeField(final SoyType type) {
        Preconditions.checkNotNull((Object)type);
        return new FieldInterpreter(){

            @Override
            public SoyType type() {
                return type;
            }

            @Override
            public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
                return converter.convert(field);
            }
        };
    }

    private static FieldInterpreter getNumberFieldInterpreter(SoyTypeRegistry registry) {
        FieldInterpreter factory = numberFactory;
        if (factory == null) {
            final SoyType type = SoyTypes.NUMBER_TYPE;
            numberFactory = factory = new FieldInterpreter(){

                @Override
                public SoyType type() {
                    return type;
                }

                @Override
                public SoyValueProvider intepretField(SoyValueConverter converter, Object field) {
                    if (field instanceof Long | field instanceof Integer) {
                        return IntegerData.forValue(((Number)field).longValue());
                    }
                    if (field instanceof Double | field instanceof Float) {
                        return FloatData.forValue(((Number)field).doubleValue());
                    }
                    throw new AssertionError((Object)("unknown number value: " + field));
                }
            };
        }
        return factory;
    }

    private FieldInterpreter() {
    }

    abstract SoyType type();

    abstract SoyValueProvider intepretField(SoyValueConverter var1, Object var2);
}

