/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;

abstract class DescriptorTreeWalker {
    protected final ExtensionRegistry extensionRegistry;

    DescriptorTreeWalker(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    void visitFileDescriptorSetFromFile(File file) {
    }

    void visitFileDescriptorSet(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
    }

    void visitFileDescriptor(Descriptors.FileDescriptor fileDescriptor) {
    }

    void visitGenericDescriptors(ImmutableList<Descriptors.GenericDescriptor> descriptors) {
    }

    void visitMessageDescriptor(Descriptors.Descriptor descriptor) {
    }

    void visitFieldDescriptor(Descriptors.FieldDescriptor descriptor) {
    }

    void visitEnumDescriptor(Descriptors.EnumDescriptor descriptor) {
    }

    void visitExtensionDescriptor(Descriptors.FieldDescriptor descriptor) {
    }

    final void walkFileDescriptorSetFromFile(File file) throws FileNotFoundException, IOException, Descriptors.DescriptorValidationException {
        this.visitFileDescriptorSetFromFile(file);
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.walkFileDescriptorSet(DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream, (ExtensionRegistryLite)this.extensionRegistry));
        }
    }

    final void walkFileDescriptorSet(DescriptorProtos.FileDescriptorSet descriptorSet) throws Descriptors.DescriptorValidationException {
        this.visitFileDescriptorSet(descriptorSet);
        LinkedHashMap fileDescriptors = Maps.newLinkedHashMap();
        for (DescriptorProtos.FileDescriptorProto fileDescriptorProto : descriptorSet.getFileList()) {
            Descriptors.FileDescriptor[] deps = new Descriptors.FileDescriptor[fileDescriptorProto.getDependencyCount()];
            for (int i = 0; i < fileDescriptorProto.getDependencyCount(); ++i) {
                String name = fileDescriptorProto.getDependency(i);
                deps[i] = (Descriptors.FileDescriptor)Preconditions.checkNotNull(fileDescriptors.get(name), (String)"Missing file descriptor for [%s]", (Object[])new Object[]{name});
            }
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])deps);
            fileDescriptors.put(fileDescriptor.getName(), fileDescriptor);
        }
        for (Descriptors.FileDescriptor fileDescriptor : fileDescriptors.values()) {
            this.walkFileDescriptor(fileDescriptor);
        }
    }

    final void walkFileDescriptor(Descriptors.FileDescriptor fileDescriptor) {
        this.visitFileDescriptor(fileDescriptor);
        ImmutableList descriptors = ImmutableList.builder().addAll((Iterable)fileDescriptor.getMessageTypes()).addAll((Iterable)fileDescriptor.getExtensions()).addAll((Iterable)fileDescriptor.getEnumTypes()).build();
        this.walkGenericDescriptors((Iterable<? extends Descriptors.GenericDescriptor>)descriptors);
    }

    final void walkGenericDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
        ImmutableList descriptorList = ImmutableList.copyOf(descriptors);
        this.visitGenericDescriptors((ImmutableList<Descriptors.GenericDescriptor>)descriptorList);
        for (Descriptors.GenericDescriptor descriptor : descriptorList) {
            this.walkGenericDescriptor(descriptor);
        }
    }

    final void walkGenericDescriptor(Descriptors.GenericDescriptor descriptor) {
        if (descriptor instanceof Descriptors.Descriptor) {
            this.walkMessageDescriptor((Descriptors.Descriptor)descriptor);
        } else if (descriptor instanceof Descriptors.FieldDescriptor) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)descriptor;
            if (fieldDescriptor.isExtension()) {
                this.visitExtensionDescriptor(fieldDescriptor);
            } else {
                this.visitFieldDescriptor(fieldDescriptor);
            }
        } else if (descriptor instanceof Descriptors.EnumDescriptor) {
            this.visitEnumDescriptor((Descriptors.EnumDescriptor)descriptor);
        }
    }

    final void walkMessageDescriptor(Descriptors.Descriptor descriptor) {
        this.visitMessageDescriptor(descriptor);
        this.walkGenericDescriptors((Iterable<? extends Descriptors.GenericDescriptor>)ImmutableList.builder().addAll((Iterable)descriptor.getNestedTypes()).addAll((Iterable)descriptor.getExtensions()).addAll((Iterable)descriptor.getEnumTypes()).addAll((Iterable)descriptor.getFields()).build());
    }
}

